/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.ClassFile;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.optimize.evaluation.BranchUnit;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.InstructionOffsetValueFactory;
import proguard.optimize.evaluation.value.Value;

class TracedBranchUnit
implements BranchUnit {
    private static final boolean DEBUG = true;
    private boolean wasCalled;
    private InstructionOffsetValue traceBranchTargets;
    private Value traceReturnValue;

    TracedBranchUnit() {
    }

    public void resetCalled() {
        this.wasCalled = false;
    }

    public boolean wasCalled() {
        return this.wasCalled;
    }

    public void setTraceBranchTargets(InstructionOffsetValue instructionOffsetValue) {
        this.traceBranchTargets = instructionOffsetValue;
    }

    public InstructionOffsetValue getTraceBranchTargets() {
        return this.traceBranchTargets;
    }

    public void setTraceReturnValue(Value value) {
        this.traceReturnValue = value;
    }

    public Value getTraceReturnValue() {
        return this.traceReturnValue;
    }

    public void branch(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n, int n2) {
        this.branchConditionally(classFile, codeAttrInfo, n, n2, 1);
    }

    public void branchConditionally(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n, int n2, int n3) {
        if (n3 != -1) {
            InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create(n2);
            this.traceBranchTargets = n3 == 1 ? instructionOffsetValue : this.traceBranchTargets.generalize(instructionOffsetValue).instructionOffsetValue();
        }
        this.wasCalled = true;
    }

    public void returnFromMethod(Value value) {
        this.traceReturnValue = this.traceReturnValue == null ? value : this.traceReturnValue.generalize(value);
        this.traceBranchTargets = InstructionOffsetValueFactory.create();
        this.wasCalled = true;
    }

    public void throwException() {
        this.traceBranchTargets = InstructionOffsetValueFactory.create();
        this.wasCalled = true;
    }
}

