/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.optimize.evaluation.Stack;
import proguard.optimize.evaluation.value.Value;

class TracedStack
extends Stack {
    private Stack traceStack;
    private Value storeValue;
    private Value traceValue;

    public TracedStack(int n) {
        super(n);
        this.traceStack = new Stack(n);
    }

    public TracedStack(TracedStack tracedStack) {
        super(tracedStack);
        this.traceStack = new Stack(tracedStack.traceStack);
    }

    public void setStoreValue(Value value) {
        this.storeValue = value;
    }

    public void setTraceValue(Value value) {
        this.traceValue = value;
    }

    public Value getTraceValue() {
        return this.traceValue;
    }

    public Value getBottomTraceValue(int n) {
        return this.traceStack.getBottom(n);
    }

    public Value getTopTraceValue(int n) {
        return this.traceStack.getTop(n);
    }

    public void reset(int n) {
        super.reset(n);
        this.traceStack.reset(n);
    }

    public void copy(TracedStack tracedStack) {
        super.copy(tracedStack);
        this.traceStack.copy(tracedStack.traceStack);
    }

    public boolean generalize(TracedStack tracedStack) {
        return super.generalize(tracedStack) | this.traceStack.generalize(tracedStack.traceStack);
    }

    public void clear() {
        super.clear();
        this.traceStack.clear();
    }

    public void push(Value value) {
        super.push(value);
        this.tracePush();
        if (value.isCategory2()) {
            this.tracePush();
        }
    }

    public Value pop() {
        Value value = super.pop();
        this.tracePop();
        if (value.isCategory2()) {
            this.tracePop();
        }
        return value;
    }

    public void pop1() {
        super.pop1();
        this.tracePop();
    }

    public void pop2() {
        super.pop2();
        this.tracePop();
        this.tracePop();
    }

    public void dup() {
        super.dup();
        Value value = this.tracePop();
        this.tracePush();
        this.traceStack.push(value);
    }

    public void dup_x1() {
        super.dup_x1();
        Value value = this.tracePop();
        Value value2 = this.traceStack.pop();
        this.tracePush();
        this.traceStack.push(value2);
        this.traceStack.push(value);
    }

    public void dup_x2() {
        super.dup_x2();
        Value value = this.tracePop();
        Value value2 = this.traceStack.pop();
        Value value3 = this.traceStack.pop();
        this.tracePush();
        this.traceStack.push(value3);
        this.traceStack.push(value2);
        this.traceStack.push(value);
    }

    public void dup2() {
        super.dup2();
        Value value = this.tracePop();
        Value value2 = this.tracePop();
        this.tracePush();
        this.tracePush();
        this.traceStack.push(value2);
        this.traceStack.push(value);
    }

    public void dup2_x1() {
        super.dup2_x1();
        Value value = this.tracePop();
        Value value2 = this.tracePop();
        Value value3 = this.traceStack.pop();
        this.tracePush();
        this.tracePush();
        this.traceStack.push(value3);
        this.traceStack.push(value2);
        this.traceStack.push(value);
    }

    public void dup2_x2() {
        super.dup2_x2();
        Value value = this.tracePop();
        Value value2 = this.tracePop();
        Value value3 = this.traceStack.pop();
        Value value4 = this.traceStack.pop();
        this.tracePush();
        this.tracePush();
        this.traceStack.push(value4);
        this.traceStack.push(value3);
        this.traceStack.push(value2);
        this.traceStack.push(value);
    }

    public void swap() {
        super.swap();
        this.tracePop();
        Value value = this.traceStack.pop();
        this.tracePush();
        this.traceStack.push(value);
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TracedStack tracedStack = (TracedStack)object;
        return super.equals(object) && this.traceStack.equals(tracedStack.traceStack);
    }

    public int hashCode() {
        return super.hashCode() ^ this.traceStack.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.traceStack.values[i];
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty" : value2.toString()).append('>').append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }

    private void tracePush() {
        this.traceStack.push(this.storeValue);
    }

    private Value tracePop() {
        Value value = this.traceStack.pop();
        if (this.traceValue != null) {
            this.traceValue = this.traceValue.generalize(value);
        }
        return value;
    }
}

