/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.optimize.evaluation.Variables;
import proguard.optimize.evaluation.value.Value;

class TracedVariables
extends Variables {
    private Variables traceVariables;
    private Value storeValue;
    private Value traceValue;
    private boolean initialization;

    public TracedVariables(int n) {
        super(n);
        this.traceVariables = new Variables(n);
    }

    public TracedVariables(TracedVariables tracedVariables) {
        super(tracedVariables);
        this.traceVariables = new Variables(tracedVariables.traceVariables);
    }

    public void setStoreValue(Value value) {
        this.storeValue = value;
    }

    public void setTraceValue(Value value) {
        this.traceValue = value;
    }

    public Value getTraceValue() {
        return this.traceValue;
    }

    public void resetInitialization() {
        this.initialization = false;
    }

    public boolean wasInitialization() {
        return this.initialization;
    }

    public void reset(int n) {
        super.reset(n);
        this.traceVariables.reset(n);
    }

    public void initialize(TracedVariables tracedVariables) {
        super.initialize(tracedVariables);
        this.traceVariables.initialize(tracedVariables.traceVariables);
    }

    public boolean generalize(TracedVariables tracedVariables) {
        return super.generalize(tracedVariables) | this.traceVariables.generalize(tracedVariables.traceVariables);
    }

    public void store(int n, Value value) {
        Value value2 = super.load(n);
        this.initialization = this.initialization || value2 == null || value2.computationalType() != value.computationalType();
        super.store(n, value);
        this.traceVariables.store(n, this.storeValue);
    }

    public Value load(int n) {
        if (this.traceValue != null) {
            this.traceValue = this.traceValue.generalize(this.traceVariables.load(n));
        }
        return super.load(n);
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TracedVariables tracedVariables = (TracedVariables)object;
        return super.equals(object) && this.traceVariables.equals(tracedVariables.traceVariables);
    }

    public int hashCode() {
        return super.hashCode() ^ this.traceVariables.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.traceVariables.values[i];
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty" : value2.toString()).append('>').append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

