/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.optimize.KeepMarker;

public class ClassFileFinalizer
implements ClassFileVisitor,
MemberInfoVisitor {
    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if ((programClassFile.u2accessFlags & 0x610) == 0 && !KeepMarker.isKept(programClassFile) && programClassFile.subClasses == null) {
            programClassFile.u2accessFlags |= 0x10;
        }
        programClassFile.methodsAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = programMethodInfo.getName(programClassFile);
        if (!((programMethodInfo.u2accessFlags & 0x410) != 0 || string.equals("<clinit>") || string.equals("<init>") || (programClassFile.u2accessFlags & 0x10) == 0 && (KeepMarker.isKept(programMethodInfo) || this.isOverriden(programClassFile, programMethodInfo)))) {
            programMethodInfo.u2accessFlags |= 0x10;
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private boolean isOverriden(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (programClassFile.subClasses == null) {
            return false;
        }
        try {
            String string = programMethodInfo.getName(programClassFile);
            String string2 = programMethodInfo.getDescriptor(programClassFile);
            programClassFile.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(new MyMemberFinder(), string, string2));
        }
        catch (MyMemberFinder.MemberFoundException memberFoundException) {
            return true;
        }
        return false;
    }

    private static class MyMemberFinder
    implements MemberInfoVisitor {
        private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();

        private MyMemberFinder() {
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            throw MEMBER_FOUND;
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            throw MEMBER_FOUND;
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
            throw MEMBER_FOUND;
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
            throw MEMBER_FOUND;
        }

        private static class MemberFoundException
        extends IllegalArgumentException {
            private MemberFoundException() {
            }
        }
    }
}

