/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.optimize.peephole.BranchTargetFinder;

public class PushPopRemover
implements InstructionVisitor {
    private BranchTargetFinder branchTargetFinder;
    private CodeAttrInfoEditor codeAttrInfoEditor;

    public PushPopRemover(BranchTargetFinder branchTargetFinder, CodeAttrInfoEditor codeAttrInfoEditor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttrInfoEditor = codeAttrInfoEditor;
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 89: 
            case 92: {
                this.deleteWithSubsequentPop(codeAttrInfo, n, simpleInstruction);
            }
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        if (variableInstruction.isLoad() && variableInstruction.opcode != -87) {
            this.deleteWithSubsequentPop(codeAttrInfo, n, variableInstruction);
        }
    }

    private void deleteWithSubsequentPop(CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        boolean bl = instruction.isCategory2();
        int n2 = n + instruction.length(n);
        if (!(this.codeAttrInfoEditor.isModified(n) || this.codeAttrInfoEditor.isModified(n2) || this.branchTargetFinder.isBranchTarget(n2))) {
            Instruction instruction2 = InstructionFactory.create(codeAttrInfo.code, n2);
            byte by = instruction2.opcode;
            if ((by == 87 || by == 88) && instruction2.isCategory2() == bl) {
                this.codeAttrInfoEditor.deleteInstruction(n);
                this.codeAttrInfoEditor.deleteInstruction(n2);
            }
        }
    }
}

