/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.optimize.peephole.SingleImplementationMarker;

public class SingleImplementationInliner
implements MemberInfoVisitor,
AttrInfoVisitor,
InstructionVisitor,
CpInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private MyMemberFinder memberFinder = new MyMemberFinder();
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();
    private CodeAttrInfoEditor codeAttrInfoEditor = new CodeAttrInfoEditor(1024);
    private int cpIndex;
    private ClassFile singleImplementationClassFile;

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        ClassFile[] classFileArray = this.updateReferencedClassFiles(programMemberInfo.referencedClassFiles);
        if (classFileArray != null) {
            programMemberInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, this.newDescriptor(programMemberInfo.getDescriptor(programClassFile), classFileArray));
            programMemberInfo.referencedClassFiles = classFileArray;
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        this.codeAttrInfoEditor.reset(codeAttrInfo.u4codeLength);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        this.codeAttrInfoEditor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        this.cpIndex = 0;
        classFile.constantPoolEntryAccept(this, cpInstruction.cpIndex);
        if (this.cpIndex != 0) {
            byte by = cpInstruction.opcode;
            if (by == -71 && this.singleImplementationClassFile != null) {
                by = -74;
            }
            Instruction instruction = new CpInstruction(by, this.cpIndex, cpInstruction.constant).shrink();
            this.codeAttrInfoEditor.replaceInstruction(n, instruction);
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        this.singleImplementationClassFile = SingleImplementationMarker.singleImplementation(stringCpInfo.referencedClassFile);
        if (this.singleImplementationClassFile != null) {
            this.cpIndex = this.constantPoolEditor.addStringCpInfo((ProgramClassFile)classFile, this.singleImplementationClassFile.getName(), this.singleImplementationClassFile);
        }
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.cpIndex = 0;
        classFile.constantPoolEntryAccept(this, fieldrefCpInfo.getNameAndTypeIndex());
        int n = this.cpIndex;
        if (n != 0) {
            this.cpIndex = this.constantPoolEditor.addFieldrefCpInfo((ProgramClassFile)classFile, fieldrefCpInfo.getClassIndex(), n, fieldrefCpInfo.referencedClassFile, fieldrefCpInfo.referencedMemberInfo);
        }
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.cpIndex = 0;
        classFile.constantPoolEntryAccept(this, methodrefCpInfo.getNameAndTypeIndex());
        int n = this.cpIndex;
        if (n != 0) {
            this.cpIndex = this.constantPoolEditor.addMethodrefCpInfo((ProgramClassFile)classFile, methodrefCpInfo.getClassIndex(), n, methodrefCpInfo.referencedClassFile, methodrefCpInfo.referencedMemberInfo);
        }
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.cpIndex = 0;
        classFile.constantPoolEntryAccept(this, interfaceMethodrefCpInfo.getClassIndex());
        int n = this.cpIndex;
        this.cpIndex = 0;
        classFile.constantPoolEntryAccept(this, interfaceMethodrefCpInfo.getNameAndTypeIndex());
        int n2 = this.cpIndex;
        if (n != 0) {
            String string;
            String string2;
            ClassFile classFile2;
            MemberInfo memberInfo;
            if (n2 == 0) {
                n2 = interfaceMethodrefCpInfo.getNameAndTypeIndex();
            }
            if ((memberInfo = (classFile2 = this.singleImplementationClassFile).findMethod(string2 = interfaceMethodrefCpInfo.getName(classFile), string = interfaceMethodrefCpInfo.getType(classFile))) == null) {
                try {
                    classFile2.hierarchyAccept(false, true, false, false, new NamedMethodVisitor(this.memberFinder, string2, string));
                }
                catch (MyMemberFinder.MemberFoundException memberFoundException) {
                    classFile2 = this.memberFinder.classFile;
                    memberInfo = this.memberFinder.memberInfo;
                }
            }
            this.cpIndex = this.constantPoolEditor.addMethodrefCpInfo((ProgramClassFile)classFile, n, n2, classFile2, memberInfo);
        } else if (n2 != 0) {
            n = interfaceMethodrefCpInfo.getClassIndex();
            this.cpIndex = this.constantPoolEditor.addInterfaceMethodrefCpInfo((ProgramClassFile)classFile, n, n2, interfaceMethodrefCpInfo.referencedClassFile, interfaceMethodrefCpInfo.referencedMemberInfo);
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        this.singleImplementationClassFile = SingleImplementationMarker.singleImplementation(classCpInfo.referencedClassFile);
        if (this.singleImplementationClassFile != null) {
            this.cpIndex = this.constantPoolEditor.addClassCpInfo((ProgramClassFile)classFile, this.newClassName(classCpInfo.getName(classFile), this.singleImplementationClassFile), this.singleImplementationClassFile);
        }
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        ClassFile[] classFileArray = this.updateReferencedClassFiles(nameAndTypeCpInfo.referencedClassFiles);
        if (classFileArray != null) {
            this.cpIndex = this.constantPoolEditor.addNameAndTypeCpInfo((ProgramClassFile)classFile, nameAndTypeCpInfo.getName(classFile), this.newDescriptor(nameAndTypeCpInfo.getType(classFile), classFileArray), classFileArray);
        }
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        ClassFile classFile2 = SingleImplementationMarker.singleImplementation(localVariableInfo.referencedClassFile);
        if (classFile2 != null) {
            localVariableInfo.u2descriptorIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, this.newClassName(classFile.getCpString(localVariableInfo.u2descriptorIndex), classFile2));
        }
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        ClassFile[] classFileArray = this.updateReferencedClassFiles(localVariableTypeInfo.referencedClassFiles);
        if (classFileArray != null) {
            localVariableTypeInfo.u2signatureIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, this.newDescriptor(classFile.getCpString(localVariableTypeInfo.u2signatureIndex), classFileArray));
        }
    }

    private ClassFile[] updateReferencedClassFiles(ClassFile[] classFileArray) {
        ClassFile[] classFileArray2 = null;
        if (classFileArray != null && this.referencedClassFilesChanged(classFileArray)) {
            classFileArray2 = new ClassFile[classFileArray.length];
            for (int i = 0; i < classFileArray.length; ++i) {
                ClassFile classFile = classFileArray[i];
                ClassFile classFile2 = SingleImplementationMarker.singleImplementation(classFile);
                classFileArray2[i] = classFile2 != null ? classFile2 : classFile;
            }
        }
        return classFileArray2;
    }

    private boolean referencedClassFilesChanged(ClassFile[] classFileArray) {
        for (int i = 0; i < classFileArray.length; ++i) {
            if (SingleImplementationMarker.singleImplementation(classFileArray[i]) == null) continue;
            return true;
        }
        return false;
    }

    private String newDescriptor(String string, ClassFile[] classFileArray) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        String string2 = descriptorClassEnumeration.nextFluff();
        int n = 0;
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String string3;
            String string4 = descriptorClassEnumeration.nextClassName();
            String string5 = descriptorClassEnumeration.nextFluff();
            if ((string3 = this.newClassName(string4, classFileArray[n++])) == null) {
                string3 = string4;
            }
            string2 = string2 + string3 + string5;
        }
        return string2;
    }

    private String newClassName(String string, ClassFile classFile) {
        if (classFile == null) {
            return string;
        }
        String string2 = classFile.getName();
        if (string.charAt(0) == '[') {
            string2 = string.substring(0, string.indexOf(76) + 1) + string2 + ';';
        }
        return string2;
    }

    private static class MyMemberFinder
    implements MemberInfoVisitor {
        private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();
        private ClassFile classFile;
        private MemberInfo memberInfo;

        private MyMemberFinder() {
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            this.visitMemberInfo(programClassFile, programFieldInfo);
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            this.visitMemberInfo(programClassFile, programMethodInfo);
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
            this.visitMemberInfo(libraryClassFile, libraryFieldInfo);
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
            this.visitMemberInfo(libraryClassFile, libraryMethodInfo);
        }

        private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
            this.classFile = classFile;
            this.memberInfo = memberInfo;
            throw MEMBER_FOUND;
        }

        private static class MemberFoundException
        extends IllegalArgumentException {
            private MemberFoundException() {
            }
        }
    }
}

