/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.optimize.KeepMarker;

public class SingleImplementationMarker
implements ClassFileVisitor {
    private static final Object SINGLE_IMPLEMENTATION = new Object();
    private boolean allowAccessModification;

    public SingleImplementationMarker(boolean bl) {
        this.allowAccessModification = bl;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if ((programClassFile.getAccessFlags() & 0x200) == 0 || KeepMarker.isKept(programClassFile)) {
            return;
        }
        ClassFile[] classFileArray = programClassFile.subClasses;
        if (classFileArray == null || classFileArray.length != 1) {
            return;
        }
        ClassFile classFile = classFileArray[0];
        int n = classFile.getAccessFlags();
        if ((n & 0x200) != 0) {
            classFile.accept(this);
            classFile = SingleImplementationMarker.singleImplementation(classFile);
            if (classFile == null) {
                return;
            }
            n = classFile.getAccessFlags();
        } else if ((n & 0x400) != 0) {
            return;
        }
        if (AccessUtil.accessLevel(n) < AccessUtil.accessLevel(programClassFile.getAccessFlags())) {
            if (this.allowAccessModification) {
                ((ProgramClassFile)classFile).u2accessFlags = AccessUtil.replaceAccessFlags(n, programClassFile.getAccessFlags());
            } else {
                return;
            }
        }
        SingleImplementationMarker.markSingleImplementation(programClassFile, classFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public static void markSingleImplementation(VisitorAccepter visitorAccepter, ClassFile classFile) {
        visitorAccepter.setVisitorInfo(classFile);
        classFile.setVisitorInfo(SINGLE_IMPLEMENTATION);
    }

    public static ClassFile singleImplementation(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() instanceof ClassFile ? (ClassFile)visitorAccepter.getVisitorInfo() : null;
    }

    public static boolean isSingleImplementation(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() == SINGLE_IMPLEMENTATION;
    }
}

