/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.optimize.peephole.BranchTargetFinder;

public class StoreLoadReplacer
implements InstructionVisitor {
    private Instruction dupInstruction = new SimpleInstruction(89);
    private Instruction dup2Instruction = new SimpleInstruction(92);
    private BranchTargetFinder branchTargetFinder;
    private CodeAttrInfoEditor codeAttrInfoEditor;

    public StoreLoadReplacer(BranchTargetFinder branchTargetFinder, CodeAttrInfoEditor codeAttrInfoEditor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttrInfoEditor = codeAttrInfoEditor;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        if (!variableInstruction.isLoad() && variableInstruction.opcode != -124) {
            Instruction instruction;
            byte by = variableInstruction.opcode;
            int n2 = variableInstruction.variableIndex;
            int n3 = n + variableInstruction.length(n);
            if (!this.codeAttrInfoEditor.isModified(n) && !this.codeAttrInfoEditor.isModified(n3) && !this.branchTargetFinder.isBranchTarget(n3) && (instruction = InstructionFactory.create(codeAttrInfo.code, n3)) instanceof VariableInstruction && (variableInstruction = (VariableInstruction)instruction).isLoad() && variableInstruction.opcode != -87 && variableInstruction.variableIndex == n2) {
                Instruction instruction2 = variableInstruction.isCategory2() ? this.dup2Instruction : this.dupInstruction;
                this.codeAttrInfoEditor.replaceInstruction(n, instruction2);
                Instruction instruction3 = new VariableInstruction(by, variableInstruction.variableIndex).shrink();
                this.codeAttrInfoEditor.replaceInstruction(n3, instruction3);
            }
        }
    }
}

