/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.shrink.UsageMarker;

public class InterfaceUsageMarker
implements ClassFileVisitor,
CpInfoVisitor {
    private boolean used;

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        boolean bl = UsageMarker.isUsed(programClassFile);
        boolean bl2 = UsageMarker.isPossiblyUsed(programClassFile);
        if (bl || bl2) {
            for (int i = 0; i < programClassFile.u2interfacesCount; ++i) {
                this.markCpEntry(programClassFile, programClassFile.u2interfaces[i]);
                bl |= this.used;
            }
            if (bl2) {
                if (bl) {
                    UsageMarker.markAsUsed(programClassFile);
                    this.markCpEntry(programClassFile, programClassFile.u2thisClass);
                    if (programClassFile.u2superClass != 0) {
                        this.markCpEntry(programClassFile, programClassFile.u2superClass);
                    }
                } else {
                    UsageMarker.markAsUnused(programClassFile);
                }
            }
        }
        this.used = bl;
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.used = true;
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        boolean bl = UsageMarker.isUsed(classCpInfo);
        if (!bl) {
            classCpInfo.referencedClassAccept(this);
            bl = this.used;
            if (bl) {
                UsageMarker.markAsUsed(classCpInfo);
                this.markCpEntry(classFile, classCpInfo.u2nameIndex);
            }
        }
        this.used = bl;
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        if (!UsageMarker.isUsed(utf8CpInfo)) {
            UsageMarker.markAsUsed(utf8CpInfo);
        }
    }

    private void markCpEntry(ClassFile classFile, int n) {
        classFile.constantPoolEntryAccept(this, n);
    }
}

