/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ConcreteClassFileDownTraveler;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class UsageMarker
implements ClassFileVisitor,
MemberInfoVisitor,
CpInfoVisitor,
AttrInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private static final Object POSSIBLY_USED = new Object();
    private static final Object USED = new Object();
    private MyInterfaceUsageMarker interfaceUsageMarker = new MyInterfaceUsageMarker();
    private boolean processing = false;
    private boolean invokeVirtual = false;

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (!UsageMarker.isUsed(programClassFile)) {
            UsageMarker.markAsUsed(programClassFile);
            this.markCpEntry(programClassFile, programClassFile.u2thisClass);
            if (programClassFile.u2superClass != 0) {
                this.markCpEntry(programClassFile, programClassFile.u2superClass);
            }
            programClassFile.hierarchyAccept(false, false, true, false, this.interfaceUsageMarker);
            programClassFile.methodAccept(this, "<clinit>", "()V");
            this.processing = true;
            programClassFile.fieldsAccept(this);
            programClassFile.methodsAccept(this);
            this.processing = false;
            programClassFile.attributesAccept(this);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (!UsageMarker.isUsed(libraryClassFile)) {
            ClassFile[] classFileArray;
            UsageMarker.markAsUsed(libraryClassFile);
            ClassFile classFile = libraryClassFile.superClass;
            if (classFile != null) {
                classFile.accept(this);
            }
            if ((classFileArray = libraryClassFile.interfaceClasses) != null) {
                for (int i = 0; i < classFileArray.length; ++i) {
                    if (classFileArray[i] == null) continue;
                    classFileArray[i].accept(this);
                }
            }
            libraryClassFile.methodsAccept(this);
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        if (!UsageMarker.isUsed(programMemberInfo)) {
            if (this.processing ? UsageMarker.isPossiblyUsed(programMemberInfo) : UsageMarker.isUsed(programClassFile)) {
                boolean bl = this.processing;
                this.processing = false;
                UsageMarker.markAsUsed(programMemberInfo);
                this.markCpEntry(programClassFile, programMemberInfo.u2nameIndex);
                this.markCpEntry(programClassFile, programMemberInfo.u2descriptorIndex);
                programMemberInfo.attributesAccept(programClassFile, this);
                programMemberInfo.referencedClassesAccept(this);
                this.processing = bl;
            } else {
                UsageMarker.markAsPossiblyUsed(programMemberInfo);
            }
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (!UsageMarker.isUsed(libraryMethodInfo)) {
            UsageMarker.markAsUsed(libraryMethodInfo);
            String string = libraryMethodInfo.getName(libraryClassFile);
            String string2 = libraryMethodInfo.getDescriptor(libraryClassFile);
            libraryClassFile.accept((libraryMethodInfo.getAccessFlags() & 0x400) != 0 ? new ConcreteClassFileDownTraveler(new ClassFileHierarchyTraveler(true, true, false, true, new NamedMethodVisitor(this, string, string2))) : new ClassFileHierarchyTraveler(false, false, false, true, new NamedMethodVisitor(this, string, string2)));
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        if (!UsageMarker.isUsed(integerCpInfo)) {
            UsageMarker.markAsUsed(integerCpInfo);
        }
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        if (!UsageMarker.isUsed(longCpInfo)) {
            UsageMarker.markAsUsed(longCpInfo);
        }
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        if (!UsageMarker.isUsed(floatCpInfo)) {
            UsageMarker.markAsUsed(floatCpInfo);
        }
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        if (!UsageMarker.isUsed(doubleCpInfo)) {
            UsageMarker.markAsUsed(doubleCpInfo);
        }
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        if (!UsageMarker.isUsed(stringCpInfo)) {
            UsageMarker.markAsUsed(stringCpInfo);
            this.markCpEntry(classFile, stringCpInfo.u2stringIndex);
            stringCpInfo.referencedClassAccept(this);
        }
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        if (!UsageMarker.isUsed(utf8CpInfo)) {
            UsageMarker.markAsUsed(utf8CpInfo);
        }
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        if (!UsageMarker.isUsed(fieldrefCpInfo)) {
            UsageMarker.markAsUsed(fieldrefCpInfo);
            this.markCpEntry(classFile, fieldrefCpInfo.u2classIndex);
            this.markCpEntry(classFile, fieldrefCpInfo.u2nameAndTypeIndex);
            fieldrefCpInfo.referencedClassAccept(this);
            fieldrefCpInfo.referencedMemberInfoAccept(this);
        }
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        if (!UsageMarker.isUsed(interfaceMethodrefCpInfo)) {
            UsageMarker.markAsUsed(interfaceMethodrefCpInfo);
            this.markCpEntry(classFile, interfaceMethodrefCpInfo.u2classIndex);
            this.markCpEntry(classFile, interfaceMethodrefCpInfo.u2nameAndTypeIndex);
            interfaceMethodrefCpInfo.referencedClassAccept(this);
            interfaceMethodrefCpInfo.referencedMemberInfoAccept(this);
            String string = interfaceMethodrefCpInfo.getName(classFile);
            String string2 = interfaceMethodrefCpInfo.getType(classFile);
            interfaceMethodrefCpInfo.referencedClassAccept(new ConcreteClassFileDownTraveler(new ClassFileHierarchyTraveler(true, true, false, true, new NamedMethodVisitor(this, string, string2))));
        }
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        if (!UsageMarker.isUsed(methodrefCpInfo)) {
            UsageMarker.markAsUsed(methodrefCpInfo);
            boolean bl = this.invokeVirtual;
            this.invokeVirtual = false;
            this.markCpEntry(classFile, methodrefCpInfo.u2classIndex);
            this.markCpEntry(classFile, methodrefCpInfo.u2nameAndTypeIndex);
            methodrefCpInfo.referencedClassAccept(this);
            methodrefCpInfo.referencedMemberInfoAccept(this);
            if (bl) {
                String string = methodrefCpInfo.getName(classFile);
                String string2 = methodrefCpInfo.getType(classFile);
                methodrefCpInfo.referencedClassAccept(new ClassFileHierarchyTraveler(false, false, false, true, new NamedMethodVisitor(this, string, string2)));
            }
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        if (!UsageMarker.isUsed(classCpInfo)) {
            UsageMarker.markAsUsed(classCpInfo);
            this.markCpEntry(classFile, classCpInfo.u2nameIndex);
            classCpInfo.referencedClassAccept(this);
        }
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        if (!UsageMarker.isUsed(nameAndTypeCpInfo)) {
            UsageMarker.markAsUsed(nameAndTypeCpInfo);
            this.markCpEntry(classFile, nameAndTypeCpInfo.u2nameIndex);
            this.markCpEntry(classFile, nameAndTypeCpInfo.u2descriptorIndex);
            nameAndTypeCpInfo.referencedClassesAccept(this);
        }
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        UsageMarker.markAsUsed(unknownAttrInfo);
        this.markCpEntry(classFile, unknownAttrInfo.u2attrNameIndex);
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        innerClassesAttrInfo.innerClassEntriesAccept(classFile, this);
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        UsageMarker.markAsUsed(enclosingMethodAttrInfo);
        this.markCpEntry(classFile, enclosingMethodAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, enclosingMethodAttrInfo.u2classIndex);
        this.markCpEntry(classFile, enclosingMethodAttrInfo.u2nameAndTypeIndex);
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        UsageMarker.markAsUsed(constantValueAttrInfo);
        this.markCpEntry(classFile, constantValueAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, constantValueAttrInfo.u2constantValueIndex);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        UsageMarker.markAsUsed(exceptionsAttrInfo);
        this.markCpEntry(classFile, exceptionsAttrInfo.u2attrNameIndex);
        exceptionsAttrInfo.exceptionEntriesAccept((ProgramClassFile)classFile, this);
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        UsageMarker.markAsUsed(codeAttrInfo);
        this.markCpEntry(classFile, codeAttrInfo.u2attrNameIndex);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        UsageMarker.markAsUsed(lineNumberTableAttrInfo);
        this.markCpEntry(classFile, lineNumberTableAttrInfo.u2attrNameIndex);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        UsageMarker.markAsUsed(localVariableTableAttrInfo);
        this.markCpEntry(classFile, localVariableTableAttrInfo.u2attrNameIndex);
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        UsageMarker.markAsUsed(localVariableTypeTableAttrInfo);
        this.markCpEntry(classFile, localVariableTypeTableAttrInfo.u2attrNameIndex);
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        UsageMarker.markAsUsed(sourceFileAttrInfo);
        this.markCpEntry(classFile, sourceFileAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, sourceFileAttrInfo.u2sourceFileIndex);
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        UsageMarker.markAsUsed(sourceDirAttrInfo);
        this.markCpEntry(classFile, sourceDirAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, sourceDirAttrInfo.u2sourceDirIndex);
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        UsageMarker.markAsUsed(deprecatedAttrInfo);
        this.markCpEntry(classFile, deprecatedAttrInfo.u2attrNameIndex);
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        UsageMarker.markAsUsed(syntheticAttrInfo);
        this.markCpEntry(classFile, syntheticAttrInfo.u2attrNameIndex);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        UsageMarker.markAsUsed(signatureAttrInfo);
        this.markCpEntry(classFile, signatureAttrInfo.u2attrNameIndex);
        this.markCpEntry(classFile, signatureAttrInfo.u2signatureIndex);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        UsageMarker.markAsUsed(runtimeVisibleAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeVisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        UsageMarker.markAsUsed(runtimeInvisibleAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeInvisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        UsageMarker.markAsUsed(runtimeVisibleParameterAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeVisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        UsageMarker.markAsUsed(runtimeInvisibleParameterAnnotationsAttrInfo);
        this.markCpEntry(classFile, runtimeInvisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        UsageMarker.markAsUsed(annotationDefaultAttrInfo);
        this.markCpEntry(classFile, annotationDefaultAttrInfo.u2attrNameIndex);
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        UsageMarker.markAsUsed(exceptionInfo);
        if (exceptionInfo.u2catchType != 0) {
            this.markCpEntry(classFile, exceptionInfo.u2catchType);
        }
    }

    public void visitInnerClassesInfo(ClassFile classFile, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassInfoIndex == 0 && classFile.getName().equals(classFile.getCpClassNameString(innerClassesInfo.u2innerClassInfoIndex))) {
            UsageMarker.markAsUsed(innerClassesInfo);
            if (innerClassesInfo.u2innerClassInfoIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2innerClassInfoIndex);
            }
            if (innerClassesInfo.u2outerClassInfoIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2outerClassInfoIndex);
            }
            if (innerClassesInfo.u2innerNameIndex != 0) {
                this.markCpEntry(classFile, innerClassesInfo.u2innerNameIndex);
            }
        }
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        this.markCpEntry(classFile, localVariableInfo.u2nameIndex);
        this.markCpEntry(classFile, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markCpEntry(classFile, localVariableTypeInfo.u2nameIndex);
        this.markCpEntry(classFile, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        this.markCpEntry(classFile, annotation.u2typeIndex);
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        if (constantElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, constantElementValue.u2elementName);
        }
        this.markCpEntry(classFile, constantElementValue.u2constantValueIndex);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (enumConstantElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, enumConstantElementValue.u2elementName);
        }
        this.markCpEntry(classFile, enumConstantElementValue.u2typeNameIndex);
        this.markCpEntry(classFile, enumConstantElementValue.u2constantNameIndex);
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        if (classElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, classElementValue.u2elementName);
        }
        this.markCpEntry(classFile, classElementValue.u2classInfoIndex);
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (annotationElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, annotationElementValue.u2elementName);
        }
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (arrayElementValue.u2elementName != 0) {
            this.markCpEntry(classFile, arrayElementValue.u2elementName);
        }
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        this.invokeVirtual = cpInstruction.opcode == -74;
        this.markCpEntry(classFile, cpInstruction.cpIndex);
    }

    private void markCpEntry(ClassFile classFile, int n) {
        classFile.constantPoolEntryAccept(this, n);
    }

    static void markAsUnused(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(null);
    }

    static void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(POSSIBLY_USED);
    }

    static boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == POSSIBLY_USED;
    }

    static void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    static boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    private class MyInterfaceUsageMarker
    implements ClassFileVisitor {
        private MyInterfaceUsageMarker() {
        }

        public void visitProgramClassFile(ProgramClassFile programClassFile) {
            if (!UsageMarker.isUsed(programClassFile)) {
                UsageMarker.markAsPossiblyUsed(programClassFile);
            }
        }

        public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
            UsageMarker.this.visitLibraryClassFile(libraryClassFile);
        }
    }
}

