/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintStream;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.shrink.UsageMarker;

public class UsagePrinter
implements ClassFileVisitor,
MemberInfoVisitor {
    private boolean printUnusedItems;
    private PrintStream ps;
    private String className;

    public UsagePrinter(boolean bl) {
        this(bl, System.out);
    }

    public UsagePrinter(boolean bl, PrintStream printStream) {
        this.printUnusedItems = bl;
        this.ps = printStream;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (UsageMarker.isUsed(programClassFile)) {
            if (this.printUnusedItems) {
                this.className = programClassFile.getName();
                programClassFile.fieldsAccept(this);
                programClassFile.methodsAccept(this);
                this.className = null;
            } else {
                this.ps.println(ClassUtil.externalClassName(programClassFile.getName()));
            }
        } else if (this.printUnusedItems) {
            this.ps.println(ClassUtil.externalClassName(programClassFile.getName()));
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (UsageMarker.isUsed(programFieldInfo) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.ps.println("    " + UsagePrinter.lineNumberRange(programClassFile, programFieldInfo) + ClassUtil.externalFullFieldDescription(programFieldInfo.getAccessFlags(), programFieldInfo.getName(programClassFile), programFieldInfo.getDescriptor(programClassFile)));
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (UsageMarker.isUsed(programMethodInfo) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.ps.println("    " + UsagePrinter.lineNumberRange(programClassFile, programMethodInfo) + ClassUtil.externalFullMethodDescription(programClassFile.getName(), programMethodInfo.getAccessFlags(), programMethodInfo.getName(programClassFile), programMethodInfo.getDescriptor(programClassFile)));
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private void printClassNameHeader() {
        if (this.className != null) {
            this.ps.println(ClassUtil.externalClassName(this.className) + ":");
            this.className = null;
        }
    }

    private static String lineNumberRange(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        String string = programMemberInfo.getLineNumberRange(programClassFile);
        return string != null ? string + ":" : "";
    }
}

