/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.web3d.util.FileHandler;
import org.web3d.util.VRMLFileFilter;
import org.web3d.util.X3DFileFilter;

public class OpenAction
extends AbstractAction {
    private FileHandler fileHandler;
    private Component parent;
    private JFileChooser fc;

    public OpenAction(Component component, FileHandler fileHandler, String string) {
        super("Open");
        this.parent = component;
        this.fileHandler = fileHandler;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(79, 2);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("MnemonicKey", new Integer(79));
        this.putValue("ShortDescription", "Open A new VRML or X3D file");
        String string2 = null;
        string2 = string == null ? System.getProperty("user.dir") : string;
        this.fc = new JFileChooser(string2);
        this.fc.addChoosableFileFilter(new X3DFileFilter());
        this.fc.addChoosableFileFilter(new VRMLFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            File file;
            int n = this.fc.showDialog(this.parent, "Open File");
            if (n == 0 && (file = this.fc.getSelectedFile()).exists()) {
                this.fileHandler.loadURL(file.toURL().toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

