/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.web3d.util.FileHandler;
import org.web3d.util.VRMLFileFilter;
import org.web3d.util.X3DFileFilter;

public class ReloadAction
extends AbstractAction {
    private FileHandler fileHandler;
    private Component parent;
    private JFileChooser fc;
    private JTextComponent url;

    public ReloadAction(Component component, FileHandler fileHandler, JTextComponent jTextComponent) {
        super("Reload");
        this.parent = component;
        this.fileHandler = fileHandler;
        this.url = jTextComponent;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(79, 2);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("MnemonicKey", new Integer(79));
        this.putValue("ShortDescription", "Open A new VRML or X3D file");
        String string = System.getProperty("user.dir");
        this.fc = new JFileChooser(string);
        this.fc.addChoosableFileFilter(new X3DFileFilter());
        this.fc.addChoosableFileFilter(new VRMLFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileHandler.loadURL(this.url.getText());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

