/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.jinput;

import net.java.games.input.Axis;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerState;

public class AxisTracker
extends Tracker {
    private static final int mask = 4;
    private static final float DEVICE_THRESHOLD = 0.02f;
    private static final float DEVICE_ZERO = 0.1f;
    private TrackerState tstate = new TrackerState();
    private boolean inMotion;
    private boolean newButton;
    private float rot_speed;
    private float trans_speed;
    float yVal;
    float xVal;
    private float xSpeed;
    private float ySpeed;
    private float currOrientX;
    private float currOrientY;
    private Axis[] axes;
    private int[] funcs;
    private float[] lastVal;

    public AxisTracker(Axis[] axisArray, int[] nArray) {
        this.axes = axisArray;
        this.funcs = nArray;
        this.trans_speed = 1.6f;
        this.xSpeed = this.rot_speed = 0.64f;
        this.ySpeed = this.trans_speed;
        this.currOrientX = 0.0f;
        this.currOrientY = 0.0f;
        this.lastVal = new float[axisArray.length];
    }

    public int getActionMask() {
        return 4;
    }

    public void getState(TrackerState trackerState) {
        this.updateData();
        trackerState.actionMask = 4;
        trackerState.actionType = this.tstate.actionType;
        trackerState.devicePos[0] = this.tstate.devicePos[0];
        trackerState.devicePos[1] = this.tstate.devicePos[1];
        trackerState.devicePos[2] = this.tstate.devicePos[2];
        trackerState.deviceOri[0] = this.tstate.deviceOri[0];
        trackerState.deviceOri[1] = this.tstate.deviceOri[1];
        trackerState.deviceOri[2] = this.tstate.deviceOri[2];
        trackerState.worldPos[0] = this.tstate.worldPos[0];
        trackerState.worldPos[1] = this.tstate.worldPos[1];
        trackerState.worldPos[2] = this.tstate.worldPos[2];
        trackerState.worldOri[0] = this.tstate.worldOri[0];
        trackerState.worldOri[1] = this.tstate.worldOri[1];
        trackerState.worldOri[2] = this.tstate.worldOri[2];
        trackerState.buttonMode[0] = 10;
        trackerState.buttonMode[1] = 10;
        trackerState.buttonMode[2] = this.tstate.buttonMode[2];
        for (int i = 0; i < this.tstate.buttonState.length; ++i) {
            trackerState.buttonState[i] = this.tstate.buttonState[i];
        }
        if (this.inMotion) {
            this.tstate.actionType = 4;
            this.tstate.devicePos[0] = this.xVal * this.xSpeed;
            this.tstate.devicePos[1] = this.yVal * this.ySpeed;
        } else {
            this.tstate.actionType = this.newButton ? 128 : 0;
        }
        this.newButton = false;
    }

    public void updateData() {
        int n = this.axes.length;
        block10: for (int i = 0; i < n; ++i) {
            float f;
            Axis axis = this.axes[i];
            if (axis == null || Math.abs(this.lastVal[i] - (f = axis.getPollData())) < 0.1f) continue;
            this.lastVal[i] = f;
            switch (this.funcs[i]) {
                case 3: {
                    this.tstate.actionType = 64;
                    this.currOrientX = f;
                    this.tstate.deviceOri[0] = this.currOrientY;
                    this.tstate.deviceOri[1] = this.currOrientX;
                    this.tstate.deviceOri[2] = 0.0f;
                    continue block10;
                }
                case 4: {
                    this.tstate.actionType = 64;
                    this.tstate.deviceOri[0] = this.currOrientY = -f;
                    this.tstate.deviceOri[1] = this.currOrientX;
                    this.tstate.deviceOri[2] = 0.0f;
                    continue block10;
                }
                case 0: {
                    this.xSpeed = this.rot_speed * (1.05f - f);
                    this.ySpeed = this.trans_speed * (1.05f - f);
                    continue block10;
                }
                default: {
                    this.tstate.buttonState[0] = true;
                    if (!this.inMotion) {
                        this.tstate.actionType = 2;
                        this.tstate.devicePos[0] = 0.0f;
                        this.tstate.devicePos[1] = 0.0f;
                        this.tstate.devicePos[2] = 0.0f;
                    }
                    switch (this.funcs[i]) {
                        case 1: {
                            this.inMotion = true;
                            this.xVal = f;
                            break;
                        }
                        case 2: {
                            this.inMotion = true;
                            this.yVal = f;
                            break;
                        }
                        case 5: {
                            this.inMotion = true;
                            this.yVal = 3.0f * f;
                        }
                    }
                    if (!(Math.abs(this.xVal) <= 0.1f) || !(Math.abs(this.yVal) <= 0.1f)) continue block10;
                    this.inMotion = false;
                    this.xVal = 0.0f;
                    this.yVal = 0.0f;
                    this.tstate.actionType = 16;
                    this.tstate.buttonState[0] = false;
                }
            }
        }
    }
}

