/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.jinput;

import net.java.games.input.Axis;
import net.java.games.input.Controller;
import net.java.games.input.Rumbler;
import org.web3d.vrml.device.GamepadDevice;
import org.web3d.vrml.device.GamepadState;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerDevice;
import org.web3d.vrml.device.jinput.AxisTracker;

public class Gamepad
implements GamepadDevice,
TrackerDevice {
    private static final float DEVICE_THRESHOLD = 0.02f;
    private Controller controller;
    private String name;
    private Tracker[] trackers;
    private int[] controllerFuncs;
    private Axis[] axes;
    private float[] lastVals;
    private Rumbler rumblerX;
    private Rumbler rumblerY;
    private int[] rumblerFuncs;

    public Gamepad(Controller controller, String string) {
        this.controller = controller;
        this.name = string;
        this.axes = controller.getAxes();
        this.trackers = new Tracker[1];
        Axis[] axisArray = new Axis[2];
        int[] nArray = new int[2];
        this.controllerFuncs = new int[this.axes.length];
        this.lastVals = new float[this.axes.length];
        int n = this.axes.length;
        for (int i = 0; i < n; ++i) {
            System.out.println("   axes: " + this.axes[i].getName() + " type: " + this.axes[i].getIdentifier().getName());
            if (this.axes[i].getName().equalsIgnoreCase("X axis")) {
                axisArray[0] = this.axes[i];
                nArray[0] = 1;
                this.controllerFuncs[i] = 6;
                continue;
            }
            if (this.axes[i].getName().equalsIgnoreCase("Y axis")) {
                axisArray[1] = this.axes[i];
                nArray[1] = 2;
                this.controllerFuncs[i] = 7;
                continue;
            }
            if (this.axes[i].getName().equals("Rudder")) {
                this.controllerFuncs[i] = 8;
                continue;
            }
            if (this.axes[i].getName().equals("Z Rotation")) {
                this.controllerFuncs[i] = 8;
                continue;
            }
            if (this.axes[i].getName().equals("Z Axis")) {
                System.out.println("Z Axis mapped");
                this.controllerFuncs[i] = 9;
                continue;
            }
            this.controllerFuncs[i] = this.axes[i].getName().equals("Extra") ? 9 : (this.axes[i].getName().equals("Throttle") ? 0 : (this.axes[i].getName().equals("S Button") ? 13 : (this.axes[i].getName().equals("Left Trigger") ? 11 : (this.axes[i].getName().equals("Right Trigger") ? 12 : (this.axes[i].getName().equals("Button 4") ? 11 : (this.axes[i].getName().equals("Button 5") ? 12 : (this.axes[i].getName().equals("Hat Switch") ? 10 : -1)))))));
        }
        AxisTracker axisTracker = new AxisTracker(axisArray, nArray);
        this.trackers[0] = axisTracker;
        Rumbler[] rumblerArray = controller.getRumblers();
        n = rumblerArray.length;
        this.rumblerFuncs = new int[rumblerArray.length];
        System.out.println("Rumblers:");
        for (int i = 0; i < n; ++i) {
            string = rumblerArray[i].getAxisName();
            if (string.equals("X axis")) {
                this.rumblerX = rumblerArray[i];
                continue;
            }
            if (!string.equals("Y axis")) continue;
            this.rumblerY = rumblerArray[i];
        }
    }

    public String getName() {
        return this.name;
    }

    public void getState(GamepadState gamepadState) {
        this.controller.poll();
        int n = this.axes.length;
        block11: for (int i = 0; i < n; ++i) {
            float f = this.axes[i].getPollData();
            if (Math.abs(this.lastVals[i] - f) < 0.02f) continue;
            this.lastVals[i] = f;
            switch (this.controllerFuncs[i]) {
                case 6: {
                    gamepadState.leftStickX = f;
                    gamepadState.leftStickX_changed = true;
                    continue block11;
                }
                case 7: {
                    gamepadState.leftStickY = -f;
                    gamepadState.leftStickY_changed = true;
                    continue block11;
                }
                case 8: {
                    gamepadState.rightStickX = f;
                    gamepadState.rightStickX_changed = true;
                    continue block11;
                }
                case 9: {
                    gamepadState.rightStickY = -f;
                    gamepadState.rightStickY_changed = true;
                    continue block11;
                }
                case 10: {
                    if (f == 1.0f) {
                        gamepadState.leftHatX = -1.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.875f) {
                        gamepadState.leftHatX = -0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.75f) {
                        gamepadState.leftHatX = 0.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 1.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.625f) {
                        gamepadState.leftHatX = 0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.5f) {
                        gamepadState.leftHatX = 1.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = 0.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.375f) {
                        gamepadState.leftHatX = 0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.25f) {
                        gamepadState.leftHatX = 0.0f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -1.0f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    if (f == 0.125f) {
                        gamepadState.leftHatX = -0.5f;
                        gamepadState.leftHatX_changed = true;
                        gamepadState.leftHatY = -0.5f;
                        gamepadState.leftHatY_changed = true;
                        continue block11;
                    }
                    gamepadState.leftHatX = 0.0f;
                    gamepadState.leftHatX_changed = true;
                    gamepadState.leftHatY = 0.0f;
                    gamepadState.leftHatY_changed = true;
                    continue block11;
                }
                case 0: {
                    gamepadState.throttleSlider = -f;
                    gamepadState.throttleSlider_changed = true;
                    continue block11;
                }
                case 13: {
                    gamepadState.startButton = f == 1.0f;
                    gamepadState.startButton_changed = true;
                    continue block11;
                }
                case 11: {
                    gamepadState.l1Button = f == 1.0f;
                    gamepadState.l1Button_changed = true;
                    continue block11;
                }
                case 12: {
                    gamepadState.r1Button = f == 1.0f;
                    gamepadState.r1Button_changed = true;
                }
            }
        }
    }

    public void setRumblerX(float f) {
        if (this.rumblerX != null) {
            this.rumblerX.rumble(f);
        }
    }

    public void setRumblerY(float f) {
        if (this.rumblerY != null) {
            this.rumblerY.rumble(f);
        }
    }

    public int getTrackerCount() {
        return this.trackers.length;
    }

    public Tracker[] getTrackers() {
        return this.trackers;
    }
}

