/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.jinput;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import net.java.games.input.Axis;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.device.DeviceListener;
import org.web3d.vrml.device.DeviceManager;
import org.web3d.vrml.device.InputDevice;
import org.web3d.vrml.device.jinput.Gamepad;
import org.web3d.vrml.device.jinput.Joystick;
import org.web3d.vrml.device.jinput.Wheel;

public class USBManager
implements DeviceManager {
    private ArrayList devices;
    private ArrayList deviceListeners;
    private ErrorReporter errorReporter;

    public USBManager() {
        this.setupProperties();
        this.devices = new ArrayList();
        this.deviceListeners = new ArrayList();
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        Controller[] controllerArray = controllerEnvironment.getControllers();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = controllerArray.length;
        System.out.println("Jinput USB devices detected: " + n4);
        for (int i = 0; i < n4; ++i) {
            Controller controller = controllerArray[i];
            System.out.println("device: " + controller.getName() + " rumblers: " + controller.getRumblers().length);
            Controller.Type type = controller.getType();
            String string = controller.getName();
            if (string == null) {
                System.out.println("No name for device, skipping");
                continue;
            }
            if (string.indexOf("RumblePad") > -1 || string.indexOf("WingMan Cordless Gamepad") > -1 || string.indexOf("Logitech Dual Action") > -1) {
                this.devices.add(new Gamepad(controller, "Gamepad-" + n));
                ++n;
                continue;
            }
            if (string.indexOf("Extreme Digital 3D") > -1 || string.indexOf("Freedom 2.4") > -1) {
                this.devices.add(new Joystick(controller, "Joystick-" + n2));
                ++n2;
                continue;
            }
            if (string.indexOf("MOMO Racing") > -1) {
                this.devices.add(new Wheel(controller, "Wheel-" + n3));
                ++n3;
                continue;
            }
            if (string.indexOf("SpaceBall 5000") > -1 || string.startsWith("Mouse") || string.startsWith("Keyboard")) continue;
            System.out.println("Unhandled device.  Printing properties: ");
            this.printDevice(controller);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public int getNumDevices() {
        return this.devices.size();
    }

    public InputDevice[] getDevices() {
        InputDevice[] inputDeviceArray = new InputDevice[this.devices.size()];
        this.devices.toArray(inputDeviceArray);
        return inputDeviceArray;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        if (!this.deviceListeners.contains(deviceListener)) {
            this.deviceListeners.add(deviceListener);
        }
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.remove(deviceListener);
    }

    private void setupProperties() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String string = System.getProperty("os.name").toLowerCase();
                    if (string.startsWith("windows")) {
                        System.setProperty("jinput.plugins", "net.java.games.input.DirectInputEnvironmentPlugin");
                    } else if (!string.startsWith("mac") && !string.startsWith("linux")) {
                        System.out.println("No JInput plugin defined for: " + string);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in USBManger");
        }
    }

    private void printDevice(Controller controller) {
        Axis[] axisArray = controller.getAxes();
        int n = axisArray.length;
        for (int i = 0; i < n; ++i) {
            System.out.println("   axes: " + axisArray[i].getName() + " type: " + axisArray[i].getIdentifier().getName());
        }
    }
}

