/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.jinput;

import java.util.ArrayList;
import java.util.HashMap;
import net.java.games.input.Axis;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerState;
import org.web3d.vrml.device.jinput.AxisHolder;

public class USBTracker
extends Tracker {
    private static final int mask = 4;
    private static final int FUNC_THROTTLE = 0;
    private static final int FUNC_NAV_X = 1;
    private static final int FUNC_NAV_Y = 2;
    private static final int FUNC_ORIENT_X = 3;
    private static final int FUNC_ORIENT_Y = 4;
    private static final int FUNC_NAV_Y_CENTERED = 5;
    private static final int FUNC_VIEWPOINT_NEXT = 10;
    private static final float DEVICE_THRESHOLD = 0.02f;
    private static final float DEVICE_ZERO = 0.1f;
    private TrackerState tstate = new TrackerState();
    private boolean active_forward;
    private boolean active_backward;
    private boolean active_left;
    private boolean active_right;
    private boolean inMotion;
    private boolean newButton;
    private float rot_speed;
    private float trans_speed = 1.6f;
    private HashMap features;
    float yVal;
    float xVal;
    private float xSpeed;
    private float ySpeed;
    private float currOrientX = 0.0f;
    private float currOrientY = 0.0f;
    private ArrayList axes = new ArrayList();
    private float[] lastVal;
    private int numChecks = 0;

    public USBTracker() {
        this.xSpeed = this.rot_speed = 0.64f;
        this.ySpeed = this.trans_speed;
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        Controller[] controllerArray = controllerEnvironment.getControllers();
        int n = controllerArray.length;
        System.out.println("Jinput USB devices detected: " + n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            Controller controller = controllerArray[i];
            System.out.println("device: " + controller.getName() + " rumblers: " + controller.getRumblers().length);
            Axis[] axisArray = controller.getAxes();
            String string = controller.getName();
            if (string.indexOf("RumblePad 2") > -1) {
                System.out.println("RumbledPad 2 detected");
                for (n2 = 0; n2 < axisArray.length; ++n2) {
                    System.out.println("   axis: " + axisArray[n2].getName() + " type: " + axisArray[n2].getIdentifier().getName());
                    if (axisArray[n2].getName().equalsIgnoreCase("X Axis")) {
                        System.out.println("NAV_X mapped");
                        this.axes.add(new AxisHolder(axisArray[n2], 1));
                        continue;
                    }
                    if (axisArray[n2].getName().equalsIgnoreCase("Y Axis")) {
                        System.out.println("NAV_Y mapped");
                        this.axes.add(new AxisHolder(axisArray[n2], 2));
                        continue;
                    }
                    if (axisArray[n2].getName().equals("Rudder")) continue;
                    if (axisArray[n2].getName().equalsIgnoreCase("Extra")) {
                        this.axes.add(new AxisHolder(axisArray[n2], 4));
                        continue;
                    }
                    if (!axisArray[n2].getName().equalsIgnoreCase("Throttle")) continue;
                    this.axes.add(new AxisHolder(axisArray[n2], 0));
                }
                continue;
            }
            if (string.indexOf("RumblePad") <= -1 && string.indexOf("WingMan Cordless Gamepad") <= -1) continue;
            System.out.println("RumbledPad detected");
            for (n2 = 0; n2 < axisArray.length; ++n2) {
                System.out.println("   axis: " + axisArray[n2].getName() + " type: " + axisArray[n2].getIdentifier().getName());
                if (axisArray[n2].getName().equalsIgnoreCase("X axis")) {
                    this.axes.add(new AxisHolder(axisArray[n2], 1));
                    continue;
                }
                if (axisArray[n2].getName().equalsIgnoreCase("Y axis")) {
                    this.axes.add(new AxisHolder(axisArray[n2], 2));
                    continue;
                }
                if (axisArray[n2].getName().equals("Rudder")) continue;
                if (axisArray[n2].getName().equalsIgnoreCase("Extra")) {
                    this.axes.add(new AxisHolder(axisArray[n2], 4));
                    continue;
                }
                if (!axisArray[n2].getName().equalsIgnoreCase("Throttle")) continue;
                this.axes.add(new AxisHolder(axisArray[n2], 0));
            }
        }
        this.lastVal = new float[this.axes.size()];
    }

    public int getActionMask() {
        return 4;
    }

    public void getState(TrackerState trackerState) {
        this.updateData();
        trackerState.actionMask = 4;
        trackerState.actionType = this.tstate.actionType;
        trackerState.devicePos[0] = this.tstate.devicePos[0];
        trackerState.devicePos[1] = this.tstate.devicePos[1];
        trackerState.devicePos[2] = this.tstate.devicePos[2];
        trackerState.deviceOri[0] = this.tstate.deviceOri[0];
        trackerState.deviceOri[1] = this.tstate.deviceOri[1];
        trackerState.deviceOri[2] = this.tstate.deviceOri[2];
        trackerState.worldPos[0] = this.tstate.worldPos[0];
        trackerState.worldPos[1] = this.tstate.worldPos[1];
        trackerState.worldPos[2] = this.tstate.worldPos[2];
        trackerState.worldOri[0] = this.tstate.worldOri[0];
        trackerState.worldOri[1] = this.tstate.worldOri[1];
        trackerState.worldOri[2] = this.tstate.worldOri[2];
        trackerState.buttonMode[0] = 10;
        trackerState.buttonMode[1] = 10;
        trackerState.buttonMode[2] = this.tstate.buttonMode[2];
        for (int i = 0; i < this.tstate.buttonState.length; ++i) {
            trackerState.buttonState[i] = this.tstate.buttonState[i];
        }
        ++this.numChecks;
        if (this.inMotion) {
            this.tstate.actionType = 4;
            this.tstate.devicePos[0] = this.xVal * this.xSpeed;
            this.tstate.devicePos[1] = this.yVal * this.ySpeed;
        } else {
            this.tstate.actionType = this.newButton ? 128 : 0;
        }
        this.newButton = false;
    }

    public void updateData() {
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        Controller[] controllerArray = controllerEnvironment.getControllers();
        int n = controllerArray.length;
        for (int i = 0; i < n; ++i) {
            controllerArray[i].poll();
        }
        n = this.axes.size();
        block11: for (int i = 0; i < n; ++i) {
            AxisHolder axisHolder = (AxisHolder)this.axes.get(i);
            Axis axis = axisHolder.axis;
            int n2 = axisHolder.function;
            float f = axis.getPollData();
            if (Math.abs(this.lastVal[i] - f) < 0.1f) continue;
            this.lastVal[i] = f;
            switch (n2) {
                case 3: {
                    this.tstate.actionType = 64;
                    this.currOrientX = f;
                    this.tstate.deviceOri[0] = this.currOrientY;
                    this.tstate.deviceOri[1] = this.currOrientX;
                    this.tstate.deviceOri[2] = 0.0f;
                    continue block11;
                }
                case 4: {
                    this.tstate.actionType = 64;
                    this.tstate.deviceOri[0] = this.currOrientY = -f;
                    this.tstate.deviceOri[1] = this.currOrientX;
                    this.tstate.deviceOri[2] = 0.0f;
                    continue block11;
                }
                case 0: {
                    this.xSpeed = this.rot_speed * (1.05f - f);
                    this.ySpeed = this.trans_speed * (1.05f - f);
                    continue block11;
                }
                default: {
                    this.tstate.buttonState[0] = true;
                    if (!this.inMotion) {
                        this.tstate.actionType = 2;
                        this.tstate.devicePos[0] = 0.0f;
                        this.tstate.devicePos[1] = 0.0f;
                        this.tstate.devicePos[2] = 0.0f;
                    }
                    switch (n2) {
                        case 1: {
                            this.inMotion = true;
                            this.xVal = f;
                            break;
                        }
                        case 2: {
                            this.inMotion = true;
                            this.yVal = f;
                            break;
                        }
                        case 5: {
                            this.inMotion = true;
                            this.yVal = 3.0f * (f - 0.5f);
                        }
                    }
                    if (Math.abs(this.xVal) <= 0.1f && Math.abs(this.yVal) <= 0.1f) {
                        this.inMotion = false;
                        this.xVal = 0.0f;
                        this.yVal = 0.0f;
                        this.tstate.actionType = 16;
                        this.tstate.buttonState[0] = false;
                        continue block11;
                    }
                    this.numChecks = 0;
                }
            }
        }
    }
}

