/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.keyboard;

import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.device.DeviceListener;
import org.web3d.vrml.device.DeviceManager;
import org.web3d.vrml.device.InputDevice;
import org.web3d.vrml.device.keyboard.KeyboardDevice;

public class KeyboardManager
implements DeviceManager {
    private ArrayList devices = new ArrayList();
    private ArrayList deviceListeners = new ArrayList();
    private ErrorReporter errorReporter;

    public KeyboardManager() {
        KeyboardDevice keyboardDevice = new KeyboardDevice("Keyboard-0");
        this.devices.add(keyboardDevice);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public int getNumDevices() {
        return this.devices.size();
    }

    public InputDevice[] getDevices() {
        InputDevice[] inputDeviceArray = new InputDevice[this.devices.size()];
        this.devices.toArray(inputDeviceArray);
        return inputDeviceArray;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        if (!this.deviceListeners.contains(deviceListener)) {
            this.deviceListeners.add(deviceListener);
        }
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.remove(deviceListener);
    }
}

