/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.device.keyboard;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerState;

public class KeyboardTracker
extends Tracker
implements KeyListener {
    private static final int mask = 4;
    private TrackerState tstate = new TrackerState();
    private boolean active_forward;
    private boolean active_backward;
    private boolean active_left;
    private boolean active_right;
    private boolean inMotion;
    private float rot_speed = 0.5f;
    private float trans_speed = 1.0f;

    public int getActionMask() {
        return 4;
    }

    public void getState(TrackerState trackerState) {
        trackerState.actionMask = 4;
        trackerState.actionType = this.tstate.actionType;
        trackerState.devicePos[0] = this.tstate.devicePos[0];
        trackerState.devicePos[1] = this.tstate.devicePos[1];
        trackerState.devicePos[2] = this.tstate.devicePos[2];
        trackerState.deviceOri[0] = this.tstate.deviceOri[0];
        trackerState.deviceOri[1] = this.tstate.deviceOri[1];
        trackerState.deviceOri[2] = this.tstate.deviceOri[2];
        trackerState.worldPos[0] = this.tstate.worldPos[0];
        trackerState.worldPos[1] = this.tstate.worldPos[1];
        trackerState.worldPos[2] = this.tstate.worldPos[2];
        trackerState.worldOri[0] = this.tstate.worldOri[0];
        trackerState.worldOri[1] = this.tstate.worldOri[1];
        trackerState.worldOri[2] = this.tstate.worldOri[2];
        trackerState.buttonMode[0] = 2;
        trackerState.buttonMode[1] = 2;
        for (int i = 0; i < this.tstate.buttonState.length; ++i) {
            trackerState.buttonState[i] = this.tstate.buttonState[i];
        }
        if (this.inMotion) {
            this.tstate.actionType = 4;
            this.tstate.devicePos[1] = this.active_forward ? -this.trans_speed : (this.active_backward ? this.trans_speed : 0.0f);
            this.tstate.devicePos[0] = this.active_right ? this.rot_speed : (this.active_left ? -this.rot_speed : 0.0f);
        } else {
            this.tstate.actionType = 0;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (!this.inMotion) {
                    bl = true;
                }
                this.active_forward = true;
                n = 0;
                break;
            }
            case 39: {
                if (!this.inMotion) {
                    bl = true;
                }
                this.active_right = true;
                n = 1;
                break;
            }
            case 37: {
                if (!this.inMotion) {
                    bl = true;
                }
                this.active_left = true;
                n = 1;
                break;
            }
            case 40: {
                if (!this.inMotion) {
                    bl = true;
                }
                this.active_backward = true;
                n = 0;
            }
        }
        this.trans_speed = keyEvent.isShiftDown() ? 3.0f : 1.0f;
        if (bl) {
            this.inMotion = true;
            this.tstate.actionType = 2;
            this.tstate.devicePos[0] = 0.0f;
            this.tstate.devicePos[1] = 0.0f;
            this.tstate.devicePos[2] = 0.0f;
            this.tstate.buttonState[0] = false;
            this.tstate.buttonState[1] = false;
            this.tstate.buttonState[n] = true;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.trans_speed = keyEvent.isShiftDown() ? 3.0f : 1.0f;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.active_forward = false;
                break;
            }
            case 39: {
                this.active_right = false;
                break;
            }
            case 37: {
                this.active_left = false;
                break;
            }
            case 40: {
                this.active_backward = false;
            }
        }
        if (!(this.active_forward || this.active_right || this.active_left)) {
            this.inMotion = false;
            this.tstate.actionType = 16;
            this.tstate.buttonState[0] = false;
            this.tstate.buttonState[1] = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

