/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.web3d.vrml.io.ReadProgressListener;

public class ReportableInputStream
extends FilterInputStream {
    private int bytesRead = 0;
    private int totalBytesRead;
    private boolean relative;
    private int updateSize;
    private ReadProgressListener listener;

    public ReportableInputStream(boolean bl, int n, ReadProgressListener readProgressListener, InputStream inputStream) {
        super(inputStream);
        this.relative = bl;
        this.updateSize = n;
        this.listener = readProgressListener;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.bytesRead;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray, 0, byArray.length);
        if (n != -1) {
            this.bytesRead += n;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.bytesRead += n3;
        }
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return n3;
    }

    public void reset() throws IOException {
        super.reset();
        this.totalBytesRead = 0;
        this.bytesRead = 0;
    }

    public long skip(long l) throws IOException {
        long l2 = this.skip(l);
        this.bytesRead = (int)((long)this.bytesRead + l);
        if (this.bytesRead >= this.updateSize) {
            this.totalBytesRead += this.bytesRead;
            if (this.relative) {
                this.listener.progressUpdate(this.bytesRead);
            } else {
                this.listener.progressUpdate(this.totalBytesRead);
            }
            this.bytesRead = 0;
        }
        return l2;
    }
}

