/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;

public abstract class AbstractScene
implements BasicScene {
    protected SceneMetaData metaData;
    protected VRMLNode rootNode;
    protected ArrayList routeList;
    protected HashSet allNodes;
    protected ArrayList templateList;
    protected HashMap templateMap;
    private HashMap defMap;
    private HashMap importMap;
    private IntHashMap primaryTypes;
    private IntHashMap secondaryTypes;
    protected int majorVersion;
    protected int minorVersion;
    protected VRMLNodeFactory nodeFactory;
    protected String worldURL;
    protected String loadedURI;

    protected AbstractScene(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.allNodes = new HashSet();
        this.routeList = new ArrayList();
        this.templateList = new ArrayList();
        this.templateMap = new HashMap();
        this.primaryTypes = new IntHashMap();
        this.secondaryTypes = new IntHashMap();
        this.defMap = new HashMap();
        this.importMap = new HashMap();
    }

    public void setWorldRootURL(String string) {
        this.worldURL = string;
    }

    public void setLoadedURI(String string) {
        this.loadedURI = string;
    }

    public String getWorldRootURL() {
        return this.worldURL;
    }

    public String getLoadedURI() {
        return this.loadedURI;
    }

    public void setRootNode(VRMLNode vRMLNode) {
        this.rootNode = vRMLNode;
    }

    public VRMLNode getRootNode() {
        return this.rootNode;
    }

    public SceneMetaData getMetaData() {
        return this.metaData;
    }

    public int getSpecificationMajorVersion() {
        return this.majorVersion;
    }

    public int getSpecificationMinorVersion() {
        return this.minorVersion;
    }

    public VRMLNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(VRMLNodeFactory vRMLNodeFactory) throws IllegalArgumentException, IllegalStateException {
        if (this.nodeFactory != null) {
            throw new IllegalStateException("Node factory already set");
        }
        if (vRMLNodeFactory == null) {
            throw new IllegalArgumentException("Node factory was null");
        }
        this.nodeFactory = vRMLNodeFactory;
    }

    public void addNode(VRMLNode vRMLNode) {
        if (this.allNodes.contains(vRMLNode)) {
            return;
        }
        int n = vRMLNode.getPrimaryType();
        ArrayList<VRMLNode> arrayList = (ArrayList<VRMLNode>)this.primaryTypes.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<VRMLNode>();
            this.primaryTypes.put(n, arrayList);
        }
        arrayList.add(vRMLNode);
        int[] nArray = vRMLNode.getSecondaryType();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList = (ArrayList<VRMLNode>)this.secondaryTypes.get(nArray[i]);
            if (arrayList == null) {
                arrayList = new ArrayList<VRMLNode>();
                this.secondaryTypes.put(nArray[i], arrayList);
            }
            arrayList.add(vRMLNode);
        }
    }

    public void removeNode(VRMLNode vRMLNode) {
        if (!this.allNodes.contains(vRMLNode)) {
            return;
        }
        int n = vRMLNode.getPrimaryType();
        ArrayList arrayList = (ArrayList)this.primaryTypes.get(n);
        arrayList.remove(vRMLNode);
        int[] nArray = vRMLNode.getSecondaryType();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList = (ArrayList)this.secondaryTypes.get(nArray[i]);
            arrayList.remove(vRMLNode);
        }
    }

    public void addTemplate(VRMLNodeTemplate vRMLNodeTemplate) {
        if (this.templateList.contains(vRMLNodeTemplate)) {
            return;
        }
        this.templateList.add(vRMLNodeTemplate);
        this.templateMap.put(vRMLNodeTemplate.getVRMLNodeName(), vRMLNodeTemplate);
    }

    public void removeTemplate(VRMLNodeTemplate vRMLNodeTemplate) {
        this.templateList.remove(vRMLNodeTemplate);
        this.templateMap.remove(vRMLNodeTemplate.getVRMLNodeName());
    }

    public ArrayList getRoutes() {
        return this.routeList;
    }

    public ArrayList getNodeTemplates() {
        return this.templateList;
    }

    public ArrayList getByPrimaryType(int n) {
        ArrayList arrayList = (ArrayList)this.primaryTypes.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.primaryTypes.put(n, arrayList);
        }
        return arrayList;
    }

    public ArrayList getBySecondaryType(int n) {
        ArrayList arrayList = (ArrayList)this.secondaryTypes.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.secondaryTypes.put(n, arrayList);
        }
        return arrayList;
    }

    public VRMLNodeTemplate getNodeTemplate(String string) {
        return (VRMLNodeTemplate)this.templateMap.get(string);
    }

    public void addDEFNode(String string, VRMLNode vRMLNode) {
        if (vRMLNode != null && string != null) {
            this.defMap.put(string, vRMLNode);
        }
    }

    public void removeDEFNode(String string) {
        this.defMap.remove(string);
    }

    public Map getDEFNodes() {
        return this.defMap;
    }

    public void addImportedNode(String string, String string2, String string3) {
        if (string2 != null) {
            if (string != null) {
                this.importMap.put(string, new String[]{string2, string3});
            } else {
                this.importMap.put(string3, new String[]{string2, string3});
            }
        }
    }

    public void removeImportedNode(String string) {
        this.importMap.remove(string);
    }

    public Map getImports() {
        return this.importMap;
    }
}

