/*
 * Decompiled with CFR 0.152.
 */
package psengine.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LibraryLoader {
    private static List tested = null;

    private LibraryLoader() {
    }

    public static String mapLibraryName(String string) {
        String string2 = System.getProperty("os.name");
        String string3 = System.mapLibraryName(string);
        if (string2.equals("Mac OS X")) {
            string3 = string3.replaceAll("jnilib$", "dylib");
        }
        return string3;
    }

    public static void loadLibrary(String string) {
        String string2 = LibraryLoader.getResolvedName(string);
        if (string2 == null) {
            String string3 = "";
            for (int i = 0; i < tested.size(); ++i) {
                string3 = string3 + "\n" + tested.get(i).toString();
            }
            throw new UnsatisfiedLinkError("no " + string + " in java.library.path tested for:" + string3);
        }
        System.load(string2);
        tested = null;
    }

    public static String getResolvedName(String string) {
        String string2 = null;
        String string3 = LibraryLoader.mapLibraryName(string);
        String[] stringArray = System.getProperty("java.library.path").split(File.pathSeparator);
        tested = new ArrayList(stringArray.length + 2);
        for (int i = 0; i < stringArray.length && string2 == null; ++i) {
            string2 = LibraryLoader.testLibName(stringArray[i], string3);
        }
        if (string2 == null && System.getenv("EUROPA_HOME") != null) {
            string2 = LibraryLoader.testLibName(System.getenv("EUROPA_HOME") + File.separator + "lib", string3);
        }
        if (string2 == null && System.getenv("PLASMA_HOME") != null) {
            string2 = LibraryLoader.testLibName(System.getenv("PLASMA_HOME") + File.separator + "lib", string3);
        }
        return string2;
    }

    private static String testLibName(String string, String string2) {
        File file = new File(string, string2);
        tested.add(file);
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }
}

