/*
 * Decompiled with CFR 0.152.
 */
package psengine.util;

import java.text.NumberFormat;

public class SimpleTimer {
    private long startTime_;
    private long totalTime_;
    private boolean running_;
    private static final NumberFormat decimal3 = NumberFormat.getNumberInstance();

    public SimpleTimer() {
        decimal3.setMaximumFractionDigits(3);
        this.reset();
    }

    public SimpleTimer reset() {
        this.startTime_ = 0L;
        this.totalTime_ = 0L;
        this.running_ = false;
        return this;
    }

    public SimpleTimer start() {
        this.running_ = true;
        this.startTime_ = System.currentTimeMillis();
        return this;
    }

    public SimpleTimer stop() {
        if (this.running_) {
            this.updateTotal();
            this.running_ = false;
        }
        return this;
    }

    public long getElapsed() {
        if (this.running_) {
            this.updateTotal();
        }
        return this.totalTime_;
    }

    public String getElapsedString() {
        return SimpleTimer.format(this.getElapsed());
    }

    public String getElapsedPer(int n) {
        if (n == 0) {
            return "Infinity";
        }
        long l = this.getElapsed();
        double d = (double)l * 1.0 / (double)n;
        if (d < 1000.0) {
            return decimal3.format(d) + " msecs";
        }
        return SimpleTimer.format(l);
    }

    public static String format(long l) {
        if (l < 1000L) {
            return Long.toString(l) + " msecs";
        }
        if (l < 60000L) {
            return decimal3.format((double)l / 1000.0) + " secs";
        }
        return decimal3.format((double)l / 60000.0) + " mins";
    }

    private void updateTotal() {
        long l = System.currentTimeMillis();
        this.totalTime_ += l - this.startTime_;
        this.startTime_ = l;
    }
}

