/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.cmdsenders;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.TextMessage;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.plugins.cmdsenders.ITextMsgSender;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;

public class AcousticModemSender
implements ITextMsgSender {
    @Override
    public String getName() {
        return "Send acoustically";
    }

    @Override
    public boolean available(String vehicleId) {
        return ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true).length > 0;
    }

    @Override
    public Future<String> sendToVehicle(String source, String destination, String command) {
        TextMessage tm = new TextMessage();
        tm.setText(command);
        tm.setOrigin(source);
        final boolean result = IMCSendMessageUtils.sendMessageByAcousticModem((IMCMessage)tm, (String)destination, (ImcSystem[])ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true));
        return new Future<String>(){

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return result ? "Sent" : "Error sending";
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return result ? "Sent" : "Error sending";
            }
        };
    }

    public static void main(String[] args) throws Exception {
        ImcMsgManager.getManager().start();
        MonitorIMCComms monitor = new MonitorIMCComms(ImcMsgManager.getManager());
        GuiUtils.testFrame((JComponent)monitor);
        AcousticModemSender sender = new AcousticModemSender();
        for (int i = 0; i < 15; ++i) {
            Thread.sleep(1000L);
        }
        try {
            System.out.println(sender.sendToVehicle("neptus", "lauv-xtreme-2", "yoyo").get());
            System.out.println(sender.sendToVehicle("neptus", "lauv-seacon-1", "yoyo").get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

