/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.cmdsenders;

import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.IridiumCommand;
import pt.lsts.neptus.comm.iridium.IridiumManager;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.plugins.cmdsenders.ITextMsgSender;

public class IridiumSender
implements ITextMsgSender {
    private static long lastSuccess = -1L;

    @Override
    public String getName() {
        return "Send via Iridium";
    }

    @Override
    public boolean available(String vehicleId) {
        return IridiumManager.getManager().isAvailable();
    }

    @Override
    public Future<String> sendToVehicle(String source, String destination, String command) {
        final IridiumCommand cmd = new IridiumCommand();
        cmd.setCommand(command);
        cmd.setSource(ImcMsgManager.getManager().getLocalId().intValue());
        ImcSystem dest = ImcSystemsHolder.getSystemWithName((String)destination);
        if (dest != null) {
            cmd.setDestination(dest.getId().intValue());
        } else {
            cmd.setDestination(65535);
        }
        return new Future<String>(){
            String result = "In progress";
            boolean complete = false;
            {
                try {
                    IridiumManager.getManager().send((IridiumMessage)cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.result = e.getClass().getSimpleName() + ": " + e.getMessage();
                }
                this.complete = true;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return this.result;
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.result;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.complete;
            }
        };
    }

    public static Future<Boolean> rockBlockIsReachable() {
        return new Future<Boolean>(){
            Boolean result = null;
            boolean canceled = false;
            long start = System.currentTimeMillis();
            {
                if (System.currentTimeMillis() - lastSuccess < 15000L) {
                    this.result = true;
                }
                try {
                    URL url = new URL("https://secure.rock7mobile.com/rockblock");
                    int len = url.openConnection().getContentLength();
                    if (len > 0) {
                        lastSuccess = System.currentTimeMillis();
                    }
                    this.result = len > 0;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                    this.result = false;
                }
            }

            @Override
            public Boolean get() throws InterruptedException, ExecutionException {
                while (this.result == null) {
                    Thread.sleep(100L);
                }
                return this.result;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.canceled = true;
                return false;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                while (this.result == null) {
                    Thread.sleep(100L);
                    if (System.currentTimeMillis() - this.start <= unit.toMillis(timeout)) continue;
                    throw new TimeoutException("Time out while connecting");
                }
                return this.result;
            }

            @Override
            public boolean isCancelled() {
                return this.canceled;
            }

            @Override
            public boolean isDone() {
                return this.result != null;
            }
        };
    }

    public static void main(String[] args) throws Exception {
        IridiumSender sender = new IridiumSender();
        System.out.println(sender.available("lauv-xtreme-2"));
        System.out.println(sender.available("lauv-xtreme-2"));
        System.out.println(sender.available("lauv-xtreme-2"));
        System.out.println(sender.available("lauv-xtreme-2"));
        System.out.println(sender.available("lauv-xtreme-2"));
        System.out.println(sender.available("lauv-xtreme-2"));
    }
}

