/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.cmdsenders;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Sms;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.plugins.cmdsenders.ITextMsgSender;
import pt.lsts.neptus.types.comm.protocol.GsmArgs;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;

public class SmsSender
implements ITextMsgSender {
    @Override
    public String getName() {
        return "Send via SMS";
    }

    @Override
    public boolean available(String vehicleId) {
        try {
            VehicleType vt = VehiclesHolder.getVehicleById((String)vehicleId);
            GsmArgs gsmArgs = (GsmArgs)vt.getProtocolsArgs().get("gsm");
            ImcSystem[] systems = ImcSystemsHolder.lookupSystemByService((String)"sms", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true);
            if (systems.length == 0) {
                throw new Exception("No visible system is capable of sending SMS messages");
            }
            return gsmArgs != null;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    @Override
    public Future<String> sendToVehicle(String source, String destination, String command) {
        try {
            VehicleType vt = VehiclesHolder.getVehicleById((String)destination);
            GsmArgs gsmArgs = (GsmArgs)vt.getProtocolsArgs().get("gsm");
            if (gsmArgs == null) {
                throw new Exception("No known GSM number exists for this destination");
            }
            ImcSystem[] systems = ImcSystemsHolder.lookupSystemByService((String)"sms", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true);
            if (systems.length == 0) {
                throw new Exception("No visible system is capable of sending SMS messages");
            }
            final String sender = systems[0].getName();
            System.out.println("Sending SMS to " + destination + " via " + sender);
            final Sms sms = new Sms(gsmArgs.getNumber(), 120, command);
            return new Future<String>(){
                Future<ImcMsgManager.SendResult> result;
                {
                    this.result = ImcMsgManager.getManager().sendMessageReliably((IMCMessage)sms, sender);
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return this.result.cancel(mayInterruptIfRunning);
                }

                @Override
                public String get() throws InterruptedException, ExecutionException {
                    return this.result.get().toString();
                }

                @Override
                public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return this.result.get(timeout, unit).toString();
                }

                @Override
                public boolean isCancelled() {
                    return this.result.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return this.result.isDone();
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            FutureTask<String> ft = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return "Error: " + e.getMessage();
                }
            });
            ft.run();
            return ft;
        }
    }

    public static void main(String[] args) throws Exception {
        ImcMsgManager.getManager().start();
        MonitorIMCComms monitor = new MonitorIMCComms(ImcMsgManager.getManager());
        GuiUtils.testFrame((JComponent)monitor);
        SmsSender sender = new SmsSender();
        for (int i = 0; i < 15; ++i) {
            Thread.sleep(1000L);
        }
        try {
            System.out.println(sender.sendToVehicle("neptus", "lauv-xtreme-2", "test").get());
            System.out.println(sender.sendToVehicle("neptus", "lauv-seacon-1", "test").get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

