/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.cmdsenders;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.TextMessage;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.plugins.cmdsenders.ITextMsgSender;
import pt.lsts.neptus.util.GuiUtils;

public class WiFiSender
implements ITextMsgSender {
    @Override
    public String getName() {
        return "Send via Wi-Fi";
    }

    @Override
    public boolean available(String vehicleId) {
        return ImcMsgManager.getManager().getCommInfoById(vehicleId) != null && ImcMsgManager.getManager().getCommInfoById(vehicleId).isActive();
    }

    @Override
    public Future<String> sendToVehicle(String source, String destination, String command) {
        TextMessage tm = new TextMessage();
        tm.setText(command);
        tm.setOrigin(source);
        final Future res = ImcMsgManager.getManager().sendMessageReliably((IMCMessage)tm, destination);
        return new Future<String>(){

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return ((ImcMsgManager.SendResult)res.get()).toString();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return res.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return res.isCancelled();
            }

            @Override
            public boolean isDone() {
                return res.isDone();
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return ((ImcMsgManager.SendResult)res.get(timeout, unit)).toString();
            }
        };
    }

    public static void main(String[] args) throws Exception {
        ImcMsgManager.getManager().start();
        MonitorIMCComms monitor = new MonitorIMCComms(ImcMsgManager.getManager());
        GuiUtils.testFrame((JComponent)monitor);
        WiFiSender sender = new WiFiSender();
        for (int i = 0; i < 15; ++i) {
            Thread.sleep(1000L);
        }
        try {
            System.out.println(sender.sendToVehicle("neptus", "lauv-xtreme-2", "yoyo").get());
            System.out.println(sender.sendToVehicle("neptus", "lauv-seacon-1", "yoyo").get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

