/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.txtcmd;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.txtcmd.ITextCommand;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public abstract class AbstractTextCommand
implements ITextCommand {
    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties((Object)this);
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, (Property[])properties);
    }

    public String getPropertiesDialogTitle() {
        return this.getCommand() + " properties";
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, (Property[])properties);
    }

    @Override
    public String buildCommand() {
        DefaultProperty[] props = this.getProperties();
        String ret = this.getCommand() + " ";
        boolean added = false;
        for (DefaultProperty p : props) {
            if (added) {
                ret = ret + ";";
            }
            if (p.getType() == LocationType.class) {
                LocationType loc = (LocationType)p.getValue();
                loc.convertToAbsoluteLatLonDepth();
                ret = ret + "lat=" + GuiUtils.getNeptusDecimalFormat((int)8).format(loc.getLatitudeDegs());
                ret = ret + ";lon=" + GuiUtils.getNeptusDecimalFormat((int)8).format(loc.getLongitudeDegs());
            } else {
                ret = ret + p.getName() + "=" + p.getValue();
            }
            added = true;
        }
        return ret;
    }

    @Override
    public PlanType resultingPlan(MissionType mt) {
        return null;
    }

    @Override
    public void parseCommand(String text) throws Exception {
        throw new Exception("Not implemented");
    }
}

