/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.txtcmd;

import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.txtcmd.AbstractTextCommand;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class CommandYoyo
extends AbstractTextCommand {
    @NeptusProperty(description="Survey center (the vehicle will move around this point)")
    LocationType loc = new LocationType();
    @NeptusProperty(description="Side length of the survey (in meters)")
    double size = 50.0;
    @NeptusProperty(description="Vehicle speed during the survey, in meters per second")
    double speed = 1.1;
    @NeptusProperty(description="Speed of the point of interest towards North")
    double vn = 0.0;
    @NeptusProperty(description="Speed of the point of interest towards East")
    double ve = 0.0;
    @NeptusProperty(description="Maximum depth for the survey, in meters")
    double maxdepth = 4.0;
    @NeptusProperty(description="Minimum depth for the survey, in meters")
    double minDepth = 1.0;
    @NeptusProperty(description="Pitch angle in degress to use for the survey")
    double pitch = 15.0;
    @NeptusProperty(description="Rotation of the survey, in degrees")
    double rot = 0.0;
    @NeptusProperty(description="Ammount of time to wait at surface on popups (0 means no popups)")
    double popup = 0.0;

    @Override
    public String getCommand() {
        return "yoyo";
    }

    @Override
    public PlanType resultingPlan(MissionType mt) {
        PlanCreator planCreator = new PlanCreator(mt);
        planCreator.setSpeed(this.speed, Maneuver.SPEED_UNITS.METERS_PS);
        LocationType center = new LocationType(this.loc);
        double radius = Math.sqrt(this.size * this.size / 2.0);
        double ang = Math.toRadians(45.0 + this.rot);
        double time = 0.0;
        planCreator.setLocation(center);
        planCreator.move(Math.sin(ang) * radius + this.vn * time, Math.cos(ang) * radius + this.ve * time);
        planCreator.setDepth(this.minDepth);
        planCreator.addGoto(null);
        if (this.popup > 0.0) {
            planCreator.setDepth(0.0);
            planCreator.addManeuver("PopUp", new Object[]{"duration", this.popup, "radius", 20});
        }
        double amplitude = (this.maxdepth - this.minDepth) / 2.0;
        double depth = (this.maxdepth + this.minDepth) / 2.0;
        for (int i = 0; i < 4; ++i) {
            ang = Math.toRadians((double)(i * 90 + 135) + this.rot);
            planCreator.setLocation(center);
            planCreator.move(Math.sin(ang) * radius + (time += this.size * this.speed) * this.vn, Math.cos(ang) * radius + time * this.ve);
            planCreator.setDepth(depth);
            planCreator.addManeuver("YoYo", new Object[]{"amplitude", amplitude, "pitchAngle", Math.toRadians(this.pitch)});
            if (!(this.popup > 0.0)) continue;
            planCreator.setDepth(0.0);
            planCreator.addManeuver("PopUp", new Object[]{"duration", this.popup, "radius", 20});
        }
        PlanType pt = planCreator.getPlan();
        pt.setId("yoyo");
        return pt;
    }

    public static void main(String[] args) {
        CommandYoyo gt = new CommandYoyo();
        PluginUtils.editPluginProperties((Object)gt, (boolean)true);
        System.out.println(gt.buildCommand());
    }
}

