/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.txtcmd;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.cmdsenders.AcousticModemSender;
import pt.lsts.neptus.plugins.cmdsenders.ITextMsgSender;
import pt.lsts.neptus.plugins.cmdsenders.IridiumSender;
import pt.lsts.neptus.plugins.cmdsenders.SmsSender;
import pt.lsts.neptus.plugins.cmdsenders.WiFiSender;
import pt.lsts.neptus.plugins.txtcmd.ITextCommand;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Text Commands")
@Popup(name="Text Commands", accelerator=113, height=500, width=500, pos=Popup.POSITION.CENTER)
public class TextCommands
extends ConsolePanel {
    private static final long serialVersionUID = 2849289726554619882L;
    private JLabel lblCmd = new JLabel(I18n.text((String)"Command") + ":");
    private JLabel lblMean = new JLabel(I18n.text((String)"Comm. Mean") + ":");
    private JTextArea txtResult = new JTextArea();
    private JComboBox<String> comboCmd = null;
    private JComboBox<String> comboMean = null;
    private LinkedHashMap<String, ITextCommand> commands = new LinkedHashMap();
    private PropertySheetPanel propsTable = new PropertySheetPanel();
    private WiFiSender wifiSender = new WiFiSender();
    private IridiumSender iridiumSender = new IridiumSender();
    private SmsSender smsSender = new SmsSender();
    private AcousticModemSender acousticSender = new AcousticModemSender();

    public TextCommands(ConsoleLayout console) {
        super(console);
        this.setLayout((LayoutManager)new TableLayout(new double[]{100.0, -1.0}, new double[]{24.0, 24.0, -1.0, 38.0, 32.0}));
        for (String pkg : new String[]{((Object)((Object)this)).getClass().getPackage().getName()}) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class c : reflections.getSubTypesOf(ITextCommand.class)) {
                if (Modifier.isAbstract(c.getModifiers())) continue;
                try {
                    ITextCommand cmd = (ITextCommand)c.newInstance();
                    this.commands.put(cmd.getCommand(), cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.addAll(this.commands.keySet());
        Collections.sort(cmdList);
        this.comboCmd = new JComboBox<String>(cmdList.toArray(new String[0]));
        this.comboMean = new JComboBox<String>(new String[]{"Wi-Fi", "Iridium", "SMS", "Acoustic Modem"});
        this.add(this.lblCmd, "0,0");
        this.add(this.lblMean, "0,1");
        this.add(this.comboCmd, "1,0");
        this.add(this.comboMean, "1,1");
        this.propsTable.setEditorFactory((PropertyEditorFactory)PropertiesEditor.getPropertyEditorRegistry());
        this.propsTable.setRendererFactory((PropertyRendererFactory)PropertiesEditor.getPropertyRendererRegistry());
        this.propsTable.setToolBarVisible(false);
        this.add((Component)this.propsTable, "0,2 1,2");
        this.txtResult.setEditable(false);
        this.add(new JScrollPane(this.txtResult), "0,3 1,3");
        this.comboCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ITextCommand selection = (ITextCommand)TextCommands.this.commands.get(TextCommands.this.comboCmd.getSelectedItem());
                TextCommands.this.propsTable.setProperties((Property[])selection.getProperties());
                TextCommands.this.parse();
            }
        });
        this.propsTable.addPropertySheetChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextCommands.this.parse();
            }
        });
        JPanel bottom = new JPanel(new FlowLayout(2, 3, 2));
        JButton btnSend = new JButton(I18n.text((String)"Send"));
        JButton btnPreview = new JButton(I18n.text((String)"Preview"));
        btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextCommands.this.send();
            }
        });
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextCommands.this.preview();
            }
        });
        this.parse();
        bottom.add(btnPreview);
        bottom.add(btnSend);
        this.add(bottom, "0,4 1,4");
    }

    public void cleanSubPanel() {
    }

    public String parse() {
        this.commands.get(this.comboCmd.getSelectedItem()).setProperties(this.propsTable.getProperties());
        String cmd = this.commands.get(this.comboCmd.getSelectedItem()).buildCommand();
        this.txtResult.setText(cmd);
        return cmd;
    }

    public void initSubPanel() {
    }

    private void preview() {
        this.parse();
        ITextCommand cmd = this.commands.get(this.comboCmd.getSelectedItem());
        PlanType pt = cmd.resultingPlan(this.getConsole().getMission());
        if (pt == null) {
            GuiUtils.errorMessage((String)I18n.text((String)"Preview command"), (String)I18n.textf((String)"The command %cmd can not be previewed", (Object[])new Object[]{cmd.getCommand()}));
            return;
        }
        StateRenderer2D r2d = new StateRenderer2D(MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission()));
        PlanElement planElem = new PlanElement(MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission()), new MapType());
        planElem.setPlan(pt);
        planElem.setBeingEdited(true);
        planElem.setShowManNames(true);
        planElem.setShowDistances(true);
        planElem.setShowVelocities(true);
        planElem.setRenderer(r2d);
        planElem.setTransp2d(1.0);
        r2d.addPostRenderPainter((Renderer2DPainter)planElem, "Plan");
        JDialog dialog = new JDialog((Frame)this.getConsole());
        GuiUtils.centerOnScreen((Window)dialog);
        dialog.getContentPane().add((Component)r2d);
        dialog.setSize(600, 600);
        dialog.setModal(true);
        dialog.setTitle("Previewing " + cmd.getCommand() + " command");
        dialog.setVisible(true);
    }

    private void send() {
        ITextCommand cmd = this.commands.get(this.comboCmd.getSelectedItem());
        String command = cmd.buildCommand();
        ITextMsgSender sender = null;
        switch (this.comboMean.getSelectedItem().toString()) {
            case "SMS": {
                sender = this.smsSender;
                break;
            }
            case "Iridium": {
                sender = this.iridiumSender;
                break;
            }
            case "Acoustic Modem": {
                sender = this.acousticSender;
                break;
            }
            default: {
                sender = this.wifiSender;
            }
        }
        try {
            Future<String> result = sender.sendToVehicle("neptus", this.getConsole().getMainSystem(), command);
            GuiUtils.infoMessage((Component)this.getConsole(), (String)I18n.text((String)"Send command"), (String)result.get());
            PlanType pt = cmd.resultingPlan(this.getConsole().getMission());
            pt.setVehicle(this.getMainVehicleId());
            if (pt != null) {
                this.getConsole().getMission().addPlan(pt);
                this.getConsole().getMission().save(true);
                this.getConsole().warnMissionListeners();
                this.getConsole().setPlan(pt);
            }
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        TextCommands cmds = new TextCommands(null);
        cmds.initSubPanel();
        GuiUtils.testFrame((JComponent)((Object)cmds));
    }
}

