/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.norender.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeListener;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.norender.browser.PerFrameManager;
import org.web3d.vrml.renderer.norender.nodes.NRVRMLNode;

public class NRUniverse
implements BrowserCore,
BindableNodeListener,
EventModelInitListener {
    private static final float INFINITE_VIS_LIMIT = 10000.0f;
    private static final int VP_TRANSITION_TIME = 2000;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private VRMLViewpointNodeType currentViewpoint;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private BindableNodeManager viewpointStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;
    private ArrayList viewList;
    private PerFrameManager frameManager;
    private EventModelEvaluator eventModel;
    private boolean inSetup;
    private ArrayList coreListeners;
    private ArrayList viewpointStatusListeners;

    public NRUniverse(EventModelEvaluator eventModelEvaluator) {
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener((EventModelInitListener)this);
        this.viewpointStack = new BindableNodeManager();
        this.navInfoStack = new BindableNodeManager();
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        this.viewpointStatusListeners = new ArrayList(1);
        this.viewList = new ArrayList();
        this.frameManager = new PerFrameManager(this.eventModel);
        this.frameManager.setEnable(false);
        this.frameManager.start();
        VRMLNodeFactory vRMLNodeFactory = DefaultNodeFactory.createFactory((String)"null");
        try {
            vRMLNodeFactory.setSpecVersion(3, 1);
            vRMLNodeFactory.setProfile("Interactive");
            vRMLNodeFactory.addComponent("EnvironmentalEffects", 2);
        }
        catch (UnsupportedProfileException unsupportedProfileException) {
            // empty catch block
        }
        VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)vRMLNodeFactory.createVRMLNode("Viewpoint", false);
        vRMLViewpointNodeType.setDescription("Default viewpoint");
        vRMLViewpointNodeType.setupFinished();
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)vRMLNodeFactory.createVRMLNode("NavigationInfo", false);
        vRMLNavigationInfoNodeType.setupFinished();
        VRMLBackgroundNodeType vRMLBackgroundNodeType = (VRMLBackgroundNodeType)vRMLNodeFactory.createVRMLNode("Background", false);
        vRMLBackgroundNodeType.setupFinished();
        VRMLFogNodeType vRMLFogNodeType = (VRMLFogNodeType)vRMLNodeFactory.createVRMLNode("Fog", false);
        vRMLFogNodeType.setFogType(0);
        vRMLFogNodeType.setupFinished();
        this.eventModel.setDefaultBindables(vRMLViewpointNodeType, vRMLNavigationInfoNodeType, vRMLBackgroundNodeType, vRMLFogNodeType);
        this.viewpointStack = this.eventModel.getBindableManager(55);
        this.navInfoStack = this.eventModel.getBindableManager(31);
        this.backgroundStack = this.eventModel.getBindableManager(4);
        this.fogStack = this.eventModel.getBindableManager(18);
        this.viewpointStack.setNodeChangeListener((BindableNodeListener)this);
        this.navInfoStack.setNodeChangeListener((BindableNodeListener)this);
        this.inSetup = false;
    }

    public void worldInitComplete() {
        this.fireInitEvent();
        this.inSetup = false;
    }

    public void changeWorld() {
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = this.nextScene;
        if (this.currentScene == null) {
            return;
        }
        this.frameManager.setEnable(false);
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.defMap = this.currentScene.getDEFNodes();
        NRVRMLNode nRVRMLNode = (NRVRMLNode)this.currentScene.getRootNode();
        this.currentSpace = (VRMLExecutionSpace)nRVRMLNode;
        VRMLClock vRMLClock = this.eventModel.getVRMLClock();
        vRMLClock.resetTimeZero();
        this.frameManager.setEnable(true);
    }

    public void newNodeBound(VRMLBindableNodeType vRMLBindableNodeType) {
        int n = vRMLBindableNodeType.getPrimaryType();
        if (vRMLBindableNodeType instanceof VRMLViewpointNodeType) {
            this.changeViewpoints((VRMLViewpointNodeType)vRMLBindableNodeType);
        } else if (vRMLBindableNodeType instanceof VRMLNavigationInfoNodeType) {
            this.changeNavInfo((VRMLNavigationInfoNodeType)vRMLBindableNodeType);
        }
    }

    public void bindableAdded(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointAdded((VRMLViewpointNodeType)vRMLBindableNodeType, bl);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public void bindableRemoved(VRMLBindableNodeType vRMLBindableNodeType) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointRemoved((VRMLViewpointNodeType)vRMLBindableNodeType);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public int getRendererType() {
        return 2;
    }

    public String getIDString() {
        return "norender";
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        return 0.0f;
    }

    public void setLastRenderTime(long l) {
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener != null && !this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        this.viewpointStatusListeners.remove(viewpointStatusListener);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        if (this.currentScene != null) {
            string = this.currentScene.getWorldRootURL();
        }
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.inSetup = true;
        this.nextScene = vRMLScene;
        this.eventModel.setScene(vRMLScene, string);
        this.frameManager.setEnable(true);
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void setNavigationMode(String string) {
    }

    public void fitToWorld(boolean bl) {
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public VRMLViewpointNodeType getViewpoint() {
        return this.currentViewpoint;
    }

    private void clearCurrentWorld() {
        this.frameManager.setEnable(false);
        this.currentSpace = null;
        this.eventModel.clear();
        this.clearInlines((BasicScene)this.currentScene);
    }

    private void changeViewpoints(VRMLViewpointNodeType vRMLViewpointNodeType) {
    }

    private void changeNavInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        float f = this.currentNavInfo.getVisibilityLimit();
        if (f <= 0.0f) {
            f = 10000.0f;
        }
        float[] fArray = this.currentNavInfo.getAvatarSize();
    }

    private void clearInlines(BasicScene basicScene) {
        NRVRMLNode nRVRMLNode;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(24);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            nRVRMLNode = (NRVRMLNode)arrayList.get(n);
            VRMLScene vRMLScene = (VRMLScene)((VRMLInlineNodeType)nRVRMLNode).getContainedScene();
            if (vRMLScene == null) continue;
            this.clearInlines((BasicScene)vRMLScene);
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            nRVRMLNode = (VRMLProtoInstance)arrayList.get(n);
            this.clearInlines(nRVRMLNode.getContainedScene());
        }
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }
}

