/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.norender.browser;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;

public class PerFrameManager
extends Thread {
    private static final int TIME_FUDGE_FACTOR = 1;
    private static final long INACTIVE_TIME = 500L;
    private static final String NULL_EVENT_MSG = "The event model instance provided is null";
    private ErrorReporter errorReporter;
    private EventModelEvaluator eventModel;
    private boolean enabled;
    private boolean shutdown;
    private long currentWallTime;
    private long lastWallTime;

    public PerFrameManager(EventModelEvaluator eventModelEvaluator) throws IllegalArgumentException {
        if (eventModelEvaluator == null) {
            throw new IllegalArgumentException(NULL_EVENT_MSG);
        }
        this.eventModel = eventModelEvaluator;
        this.currentWallTime = this.lastWallTime = System.currentTimeMillis();
        this.enabled = false;
        this.shutdown = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void run() {
        while (!this.shutdown) {
            if (!this.enabled) {
                try {
                    PerFrameManager.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.shutdown) break;
            this.currentWallTime = System.currentTimeMillis();
            if (this.currentWallTime - this.lastWallTime <= 0L) {
                // empty if block
            }
            this.lastWallTime = ++this.currentWallTime;
            this.eventModel.evaluate(this.currentWallTime);
            if (!this.shutdown) continue;
            break;
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setEnable(boolean bl) {
        this.enabled = bl;
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

