/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.norender.input;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.InputDeviceManager;
import org.web3d.vrml.nodes.runtime.InputEventBuffer;
import org.web3d.vrml.nodes.runtime.KeyDeviceSensorManager;
import org.web3d.vrml.nodes.runtime.PickingManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.TerrainSectorManager;
import org.web3d.vrml.nodes.runtime.UserInputHandler;
import org.web3d.vrml.renderer.common.input.TimeSensorManager;
import org.web3d.vrml.util.NodeArray;

public class DefaultSensorManager
implements SensorManager {
    private static final int DEFAULT_EVENT_SIZE = 128;
    private TimeSensorManager timeSensors;
    private KeyDeviceSensorManager keySensors;
    private PickingManager pickManager;
    private InputDeviceManager inputManager;
    private InputEventBuffer inputBuffer;
    private MouseEvent[] mouseEvents;
    private KeyEvent[] keyEvents;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private BindableNodeManager viewStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;

    public DefaultSensorManager() {
        this.timeSensors = new TimeSensorManager();
        this.keySensors = new KeyDeviceSensorManager();
        this.mouseEvents = new MouseEvent[128];
        this.keyEvents = new KeyEvent[128];
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.timeSensors.setErrorReporter(errorReporter);
        this.keySensors.setErrorReporter(this.errorReporter);
        if (this.inputManager != null) {
            this.inputManager.setErrorReporter(this.errorReporter);
        }
        if (this.pickManager != null) {
            this.pickManager.setErrorReporter(this.errorReporter);
        }
    }

    public UserInputHandler getUserInputHandler() {
        return null;
    }

    public void setInputManager(InputDeviceManager inputDeviceManager) {
        this.inputManager = inputDeviceManager;
        if (inputDeviceManager != null) {
            inputDeviceManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setPickingManager(PickingManager pickingManager) {
        this.pickManager = pickingManager;
        if (pickingManager != null) {
            pickingManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setNavigationStacks(BindableNodeManager bindableNodeManager, BindableNodeManager bindableNodeManager2, BindableNodeManager bindableNodeManager3, BindableNodeManager bindableNodeManager4) {
        this.viewStack = bindableNodeManager;
        this.navInfoStack = bindableNodeManager2;
        this.backgroundStack = bindableNodeManager3;
        this.fogStack = bindableNodeManager4;
    }

    public void processUserInput(long l) {
        this.timeSensors.clockTick(l);
        if (this.inputBuffer != null) {
            int n = this.inputBuffer.getMouseEvents(this.mouseEvents);
            n = this.inputBuffer.getKeyEvents(this.keyEvents);
            if (n != 0) {
                this.keySensors.sendEvents(this.keyEvents, n);
            }
        }
        VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.viewStack.getBoundNode();
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)this.navInfoStack.getBoundNode();
        this.pickManager.processPickSensors((double)l);
    }

    public void removeSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block5: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 26: {
                    this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block5;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock(null);
                    continue block5;
                }
                case 73: {
                    this.pickManager.removeSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block5;
                }
                default: {
                    System.out.println("Unhandled node type " + vRMLSensorNodeType.getVRMLNodeName());
                }
            }
        }
    }

    public void addSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block5: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 26: {
                    this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block5;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)vRMLSensorNodeType).setVRMLClock((VRMLClock)this.timeSensors);
                    continue block5;
                }
                case 73: {
                    this.pickManager.addSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block5;
                }
                default: {
                    System.out.println("Unhandled node type " + vRMLSensorNodeType.getVRMLNodeName());
                }
            }
        }
    }

    public void addViewDependentNodes(NodeArray nodeArray) {
    }

    public void removeViewDependentNodes(NodeArray nodeArray) {
    }

    public void setTerrainSectorManager(TerrainSectorManager terrainSectorManager) {
    }

    public void loadScene(BasicScene basicScene) {
        Object e;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(26);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)arrayList.get(n));
        }
        arrayList = basicScene.getBySecondaryType(52);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            ((VRMLTimeDependentNodeType)e).setVRMLClock((VRMLClock)this.timeSensors);
        }
        arrayList = basicScene.getBySecondaryType(53);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            ((VRMLTimeControlledNodeType)e).setVRMLClock((VRMLClock)this.timeSensors);
        }
        arrayList = basicScene.getByPrimaryType(14);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
        }
        this.pickManager.loadScene(basicScene);
    }

    public void unloadScene(BasicScene basicScene) {
    }

    public void clear() {
        this.timeSensors.clear();
        this.keySensors.clear();
    }

    public VRMLClock getVRMLClock() {
        return this.timeSensors;
    }

    public void updateViewMatrix() {
    }
}

