/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.norender.nodes.extensions;

import java.util.ArrayList;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.common.nodes.extensions.BaseDISEntityManager;
import org.web3d.vrml.renderer.norender.nodes.NRVRMLNode;
import org.web3d.vrml.renderer.norender.nodes.dis.NREspduTransform;
import org.web3d.xmsf.dis.EntityStatePduType;

public class NRDISEntityManager
extends BaseDISEntityManager
implements NRVRMLNode {
    private ArrayList addedEntities;
    private ArrayList removedEntities;
    private boolean newAddedEntities;
    private boolean newRemovedEntities;

    public NRDISEntityManager() {
        this.init();
    }

    public NRDISEntityManager(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allEventsComplete() {
        ArrayList arrayList;
        if (this.newAddedEntities) {
            this.vfAddedEntities.clear();
            arrayList = this.addedEntities;
            synchronized (arrayList) {
                this.vfAddedEntities.addAll(this.addedEntities);
                this.addedEntities.clear();
                this.newAddedEntities = false;
            }
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
        if (this.newRemovedEntities) {
            this.vfRemovedEntities.clear();
            arrayList = this.removedEntities;
            synchronized (arrayList) {
                this.vfRemovedEntities.addAll(this.removedEntities);
                this.removedEntities.clear();
                this.newRemovedEntities = false;
            }
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityRemoved(VRMLDISNodeType vRMLDISNodeType) {
        ArrayList arrayList = this.removedEntities;
        synchronized (arrayList) {
            this.removedEntities.add(vRMLDISNodeType);
            this.newRemovedEntities = true;
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public void entityArrived(EntityStatePduType entityStatePduType) {
        System.out.println("entityArrived ignore for NR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityArrived(EntityStatePdu entityStatePdu) {
        if (this.nodeFactory == null) {
            this.nodeFactory = DefaultNodeFactory.createFactory((String)"ogl");
        }
        try {
            this.nodeFactory.setSpecVersion(this.vrmlMajorVersion, this.vrmlMinorVersion);
            this.nodeFactory.setProfile("Interchange");
            this.nodeFactory.addComponent("DIS", 1);
        }
        catch (UnsupportedProfileException unsupportedProfileException) {
            unsupportedProfileException.printStackTrace();
        }
        NREspduTransform nREspduTransform = (NREspduTransform)this.nodeFactory.createVRMLNode("EspduTransform", false);
        int n = nREspduTransform.getFieldIndex("entityID");
        EntityID entityID = entityStatePdu.getEntityID();
        nREspduTransform.setValue(n, entityID.getEntityIDValue());
        n = nREspduTransform.getFieldIndex("applicationID");
        nREspduTransform.setValue(n, entityID.getApplicationIDValue());
        n = nREspduTransform.getFieldIndex("siteID");
        nREspduTransform.setValue(n, entityID.getSiteIDValue());
        n = nREspduTransform.getFieldIndex("networkMode");
        nREspduTransform.setValue(n, "networkReader");
        n = nREspduTransform.getFieldIndex("address");
        nREspduTransform.setValue(n, this.vfAddress);
        n = nREspduTransform.getFieldIndex("port");
        nREspduTransform.setValue(n, this.vfPort);
        nREspduTransform.setFrameStateManager(this.stateManager);
        nREspduTransform.setupFinished();
        ArrayList arrayList = this.addedEntities;
        synchronized (arrayList) {
            this.addedEntities.add(nREspduTransform);
            this.newAddedEntities = true;
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    private void init() {
        this.addedEntities = new ArrayList();
        this.removedEntities = new ArrayList();
        this.newAddedEntities = false;
        this.newRemovedEntities = false;
    }
}

