/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ipcam;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.ipcam.Camera;
import pt.lsts.neptus.plugins.ipcam.ImagePanel;
import pt.lsts.neptus.plugins.ipcam.Status;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.util.conf.StringPatternValidator;

@Popup(pos=Popup.POSITION.RIGHT, width=640, height=400)
@LayerPriority(priority=0)
@PluginDescription(name="AirCam Display", version="2.2", author="Sergio Ferreira", description="Video displayer for IP Cameras", icon="pt/lsts/neptus/plugins/ipcam/camera.png")
public class AirCamDisplay
extends ConsolePanel
implements ConfigurationListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Camera IP", description="The IP address of the camera you want to display", userLevel=NeptusProperty.LEVEL.REGULAR)
    public String ip = "10.0.20.209";
    @NeptusProperty(name="Camera Brand", description="Brand for the installed camera (not case sensitive)", userLevel=NeptusProperty.LEVEL.REGULAR)
    public String brand = "ubiquiti";
    @NeptusProperty(name="Camera Alias", description="Camera's network alias camera (not case sensitive)", userLevel=NeptusProperty.LEVEL.REGULAR)
    public String alias = "camera-03";
    private Camera activeCamera;
    private MouseAdapter mouseListener;
    private Status status = Status.OFF;
    protected Thread updater = null;
    protected LinkedHashMap<String, Camera> cameraList;
    private JComboBox<String> choicelist = null;
    private JTextField ipField = null;
    private JTextField positionField = null;
    private JTextField zoomField = null;
    private JPanel propertiesPanel = null;
    private JPanel controlPanel = null;
    private ImagePanel imagePanel = null;
    private JToggleButton recordButton = null;
    private JToggleButton connectButton = null;

    public AirCamDisplay(ConsoleLayout console) {
        super(console);
        this.removeAll();
    }

    public static String validateIP(String value) {
        return new StringPatternValidator("\\d{2,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}").validate((Object)value);
    }

    private void setMouseListener() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(I18n.text((String)"Settings")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties((PropertiesProvider)AirCamDisplay.this, (Frame)AirCamDisplay.this.getConsole(), (boolean)true);
                        }
                    });
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        };
    }

    public Dimension getPreferredSize() {
        return new Dimension(640, 400);
    }

    public void establishConnection() {
        NeptusLog.pub().info((Object)(this.getClass().getSimpleName() + " attemptig to establish connection with " + this.ip));
        if (this.status == Status.STOP || this.status == Status.OFF) {
            this.status = Status.INIT;
            this.updater = this.updaterThread();
            this.updater.start();
        } else {
            this.status = Status.RCON;
        }
    }

    private Thread updaterThread() {
        Thread ret = new Thread("RTSP Worker Thread"){
            boolean isRunning;
            boolean isRecording;
            String path;
            String recordPath;
            Calendar date;
            IMediaReader mediaReader;
            IMediaWriter mediaWriter;
            private IMediaListener mediaListener;
            {
                this.isRunning = true;
                this.isRecording = false;
                this.path = null;
                this.recordPath = "./log/";
                this.date = Calendar.getInstance();
                this.mediaListener = new MediaListenerAdapter(){

                    public void onVideoPicture(IVideoPictureEvent event) {
                        try {
                            AirCamDisplay.this.imagePanel.setImage(event.getImage());
                            if (AirCamDisplay.this.recordButton.isSelected()) {
                                if (!isRecording) {
                                    date.setTimeInMillis(System.currentTimeMillis());
                                    mediaWriter = ToolFactory.makeWriter((String)(recordPath + date.getTime() + "_" + ((AirCamDisplay)AirCamDisplay.this).activeCamera.alias + ".mp4"));
                                    mediaWriter.addVideoStream(0, 0, ICodec.ID.CODEC_ID_H264, event.getImage().getWidth(), event.getImage().getHeight());
                                    isRecording = true;
                                }
                                mediaWriter.encodeVideo(0, event.getImage(), System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                            } else {
                                if (isRecording) {
                                    mediaWriter.close();
                                }
                                isRecording = AirCamDisplay.this.recordButton.isSelected();
                            }
                            AirCamDisplay.this.repaint();
                        }
                        catch (Exception ex) {
                            AirCamDisplay.this.status = Status.STOP;
                            NeptusLog.pub().error((Object)ex);
                            NeptusLog.pub().warn((Object)"Verify camera settings before attempting to connect");
                        }
                    }
                };
            }

            @Override
            public void run() {
                while (this.isRunning) {
                    if (AirCamDisplay.this.updater == this) {
                        if (AirCamDisplay.this.status != Status.STOP) {
                            if (AirCamDisplay.this.status == Status.INIT) {
                                if (((AirCamDisplay)AirCamDisplay.this).activeCamera.brand.equalsIgnoreCase("axis")) {
                                    this.path = "rtsp://" + ((AirCamDisplay)AirCamDisplay.this).activeCamera.ip + "/axis-media/media.amp";
                                } else if (((AirCamDisplay)AirCamDisplay.this).activeCamera.brand.equalsIgnoreCase("ubiquiti")) {
                                    this.path = "rtsp://" + ((AirCamDisplay)AirCamDisplay.this).activeCamera.ip + ":554/live/ch00_0";
                                }
                                this.mediaReader = ToolFactory.makeReader((String)this.path);
                                this.mediaReader.setBufferedImageTypeToGenerate(5);
                                this.mediaReader.setQueryMetaData(false);
                                this.mediaReader.addListener(this.mediaListener);
                                AirCamDisplay.this.status = Status.CONN;
                                try {
                                    this.mediaReader.open();
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                    NeptusLog.pub().warn((Object)"Verify camera settings before attempting to connect");
                                    AirCamDisplay.this.status = Status.STOP;
                                }
                            } else if (AirCamDisplay.this.status == Status.RCON) {
                                this.mediaReader.removeListener(this.mediaListener);
                                this.mediaReader.close();
                                AirCamDisplay.this.status = Status.INIT;
                            }
                            if (AirCamDisplay.this.status != Status.CONN) continue;
                            IError err = null;
                            if (this.mediaReader != null) {
                                err = this.mediaReader.readPacket();
                            }
                            if (err == null) continue;
                            NeptusLog.pub().error((Object)err);
                            NeptusLog.pub().warn((Object)"Verify camera settings before attempting to connect");
                            AirCamDisplay.this.status = Status.STOP;
                            continue;
                        }
                        this.isRunning = false;
                        continue;
                    }
                    this.isRunning = false;
                }
                AirCamDisplay.this.status = Status.STOP;
                AirCamDisplay.this.connectButton.setSelected(false);
                AirCamDisplay.this.recordButton.setSelected(false);
                AirCamDisplay.this.recordButton.setEnabled(false);
                if (this.isRecording) {
                    this.mediaWriter.close();
                }
                NeptusLog.pub().info((Object)(this.getName() + " exiting"));
            }
        };
        return ret;
    }

    public void cleanSubPanel() {
        this.status = Status.STOP;
    }

    public void propertiesChanged() {
        if (this.status != Status.OFF) {
            Camera newCam = new Camera(this.ip, this.alias, "Nose", this.brand, 52.0, 1.0);
            if (this.cameraList.get(this.alias) != null) {
                this.choicelist.addItem(this.alias);
            }
            this.cameraList.put(this.alias, newCam);
        }
    }

    public void initSubPanel() {
        this.setMouseListener();
        this.addMouseListener(this.mouseListener);
        this.cameraList = new LinkedHashMap();
        this.imagePanel = new ImagePanel();
        this.choicelist = new JComboBox();
        this.ipField = new JTextField();
        this.positionField = new JTextField();
        this.zoomField = new JTextField();
        this.recordButton = new JToggleButton();
        this.connectButton = new JToggleButton();
        this.loadCameraList();
        this.propertiesPanelSetup();
        this.controlPanelSetup();
        this.recordButton.addItemListener(this);
        this.connectButton.addItemListener(this);
        this.choicelist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirCamDisplay.this.activeCamera = AirCamDisplay.this.cameraList.get(AirCamDisplay.this.choicelist.getSelectedItem());
                AirCamDisplay.this.ipField.setText(((AirCamDisplay)AirCamDisplay.this).activeCamera.ip);
                AirCamDisplay.this.positionField.setText(((AirCamDisplay)AirCamDisplay.this).activeCamera.position);
                AirCamDisplay.this.zoomField.setText(Double.toString(((AirCamDisplay)AirCamDisplay.this).activeCamera.zoom));
                if (AirCamDisplay.this.status != Status.STOP && AirCamDisplay.this.status != Status.OFF) {
                    AirCamDisplay.this.establishConnection();
                }
            }
        });
        this.setLayout((LayoutManager)new MigLayout());
        this.add(this.imagePanel, "w 100%, h 100%, span 1 2, growy");
        this.add(this.propertiesPanel, "w 100px!, h 100%, wrap");
        this.add(this.controlPanel, "w 100px!, h 100px!");
    }

    private void controlPanelSetup() {
        this.controlPanel = new JPanel((LayoutManager)new MigLayout());
        this.controlPanel.add((Component)new JLabel(I18n.text((String)"Connection"), 0), "w 100%, wrap");
        this.connectButton.setText(I18n.text((String)"Off"));
        this.connectButton.setBackground(Color.red.darker());
        this.connectButton.setHorizontalAlignment(0);
        this.controlPanel.add((Component)this.connectButton, "w 100%, wrap");
        this.controlPanel.add((Component)new JLabel(I18n.text((String)"Record Stream"), 0), "w 100%, wrap");
        this.recordButton.setText(I18n.text((String)"Off"));
        this.recordButton.setBackground(Color.red.darker());
        this.recordButton.setHorizontalAlignment(0);
        this.recordButton.setEnabled(false);
        this.controlPanel.add((Component)this.recordButton, "w 100%, wrap");
    }

    private void propertiesPanelSetup() {
        this.propertiesPanel = new JPanel((LayoutManager)new MigLayout());
        this.propertiesPanel.add((Component)new JLabel(I18n.text((String)"Camera Alias"), 0), "w 100%, wrap");
        this.propertiesPanel.add(this.choicelist, "w 100%, wrap");
        this.propertiesPanel.add((Component)new JLabel(I18n.text((String)"IP Address"), 0), "w 100%, wrap");
        this.ipField.setText(this.activeCamera.ip);
        this.ipField.setHorizontalAlignment(0);
        this.ipField.setEditable(false);
        this.propertiesPanel.add((Component)this.ipField, "w 100%, wrap");
        this.propertiesPanel.add((Component)new JLabel(I18n.text((String)"Position"), 0), "w 100%, wrap");
        this.positionField.setText(this.activeCamera.position);
        this.positionField.setHorizontalAlignment(0);
        this.positionField.setEditable(false);
        this.propertiesPanel.add((Component)this.positionField, "w 100%, wrap");
        this.propertiesPanel.add((Component)new JLabel(I18n.text((String)"Zoom"), 0), "w 100%, wrap");
        this.zoomField.setText(Double.toString(this.activeCamera.zoom));
        this.zoomField.setHorizontalAlignment(0);
        this.zoomField.setEditable(false);
        this.propertiesPanel.add((Component)this.zoomField, "w 100%, wrap");
    }

    private void loadCameraList() {
        this.activeCamera = new Camera("10.0.20.209", "camera-03", "Nose", "Ubiquiti", 52.0, 1.0);
        this.cameraList.put("camera-04", new Camera("10.0.20.97", "camera-04", "Nose", "Ubiquiti", 52.0, 1.0));
        this.cameraList.put("camera-03", this.activeCamera);
        this.cameraList.put("camera-08", new Camera("10.0.20.199", "camera-08", "Nose", "Axis", 52.0, 1.0));
        for (Camera cam : this.cameraList.values()) {
            this.choicelist.addItem(cam.alias);
        }
        this.choicelist.setSelectedIndex(0);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JToggleButton input = (JToggleButton)e.getSource();
        if (input.equals(this.connectButton)) {
            if (e.getStateChange() == 1) {
                this.activeCamera = this.cameraList.get(this.choicelist.getSelectedItem());
                this.connectButton.setText(I18n.text((String)"On"));
                this.ipField.setText(this.activeCamera.ip);
                this.positionField.setText(this.activeCamera.position);
                this.zoomField.setText(Double.toString(this.activeCamera.zoom));
                this.establishConnection();
                this.recordButton.setEnabled(true);
            } else {
                this.status = Status.STOP;
                this.connectButton.setText(I18n.text((String)"Off"));
                this.recordButton.setSelected(false);
                this.recordButton.setEnabled(false);
            }
        } else if (input.equals(this.recordButton)) {
            if (e.getStateChange() == 1) {
                NeptusLog.pub().info((Object)"Starting recording");
                this.recordButton.setText(I18n.text((String)"On"));
            } else {
                NeptusLog.pub().info((Object)"Stopping recording");
                this.recordButton.setText(I18n.text((String)"Off"));
            }
        }
    }
}

