/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ipcam;

import com.l2fprod.common.propertysheet.DefaultProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.ipcam.MJPEGCreator;
import pt.lsts.neptus.util.GuiUtils;

@Popup(pos=Popup.POSITION.RIGHT, width=400, height=400)
@PluginDescription(name="IP Camera Display", author="ZP", description="Video display for Conceptronic IP Camera", icon="pt/lsts/neptus/plugins/ipcam/camera.png")
public class IPCameraDisplay
extends ConsolePanel
implements ConfigurationListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="MJPEG URL", description="The URL where to download the MJPEG stream")
    public String url = "http://192.168.106.59/cgi/mjpg/mjpeg.cgi";
    @NeptusProperty(name="Fit video to panel size")
    public boolean autoSize = true;
    @NeptusProperty(name="Record to disk")
    public boolean record = true;
    @NeptusProperty(name="Recorded Video FPS")
    public int fps = 10;
    @NeptusProperty(name="Milliseconds between connection retries")
    public long millisBetweenTries = 1000L;
    protected MJPEGCreator videoCreator = null;
    protected BufferedImage imageToDisplay = null;
    protected byte[] cache = new byte[102400];
    protected HttpClient client;
    protected ThreadSafeClientConnManager httpConnectionManager;
    protected boolean connected = true;
    private final byte[] buff = new byte[256];
    protected Thread updater = null;
    protected String status = "initializing";
    protected String previousURL = null;
    protected boolean wasRecording = false;

    public IPCameraDisplay(ConsoleLayout console) {
        super(console);
        this.removeAll();
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)params, (long)1000L);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        this.httpConnectionManager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.httpConnectionManager, (HttpParams)params);
        this.status = "initializing...";
        this.updater = this.updaterThread();
        this.updater.setPriority(1);
        this.updater.start();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add("Reconnect").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            IPCameraDisplay.this.reconnect();
                        }
                    });
                    popup.add("Camera settings").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties((PropertiesProvider)IPCameraDisplay.this, (Frame)IPCameraDisplay.this.getConsole(), (boolean)true);
                        }
                    });
                    JCheckBoxMenuItem recordOption = new JCheckBoxMenuItem("Record to disk");
                    recordOption.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            IPCameraDisplay.this.record = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                        }
                    });
                    recordOption.setSelected(IPCameraDisplay.this.record);
                    popup.add(recordOption);
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    public void paint(Graphics g) {
        if (this.imageToDisplay != null) {
            if (!this.autoSize) {
                g.drawImage(this.imageToDisplay, 1, 1, null);
            } else {
                double factor1 = ((double)this.getWidth() - 2.0) / (double)this.imageToDisplay.getWidth();
                double factor2 = ((double)this.getHeight() - 2.0) / (double)this.imageToDisplay.getHeight();
                double factor = Math.min(factor1, factor2);
                ((Graphics2D)g).scale(factor, factor);
                g.drawImage(this.imageToDisplay, 0, 0, null);
                ((Graphics2D)g).scale(1.0 / factor, 1.0 / factor);
            }
        } else {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.gray);
            g.drawRect(0, 0, 320, 240);
            g.drawRect(0, 0, 640, 480);
        }
        g.setColor(Color.red);
        g.drawString(this.status, 10, 20);
    }

    public Dimension getPreferredSize() {
        return new Dimension(320, 240);
    }

    public void reconnect() {
        NeptusLog.pub().info((Object)("IPCameraDisplay: reconnecting to " + this.url + "..."));
        this.connected = false;
    }

    private Thread updaterThread() {
        return new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    if (IPCameraDisplay.this.updater != this) {
                        return;
                    }
                    if (IPCameraDisplay.this.videoCreator != null) {
                        try {
                            IPCameraDisplay.this.videoCreator.finishAVI();
                            IPCameraDisplay.this.videoCreator = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (IPCameraDisplay.this.url == null) break;
                    HttpGet get = new HttpGet(IPCameraDisplay.this.url);
                    IPCameraDisplay.this.connected = true;
                    try {
                        HttpResponse resp = IPCameraDisplay.this.client.execute((HttpUriRequest)get);
                        InputStream is = resp.getEntity().getContent();
                        while (IPCameraDisplay.this.connected) {
                            BufferedImage image;
                            IPCameraDisplay.this.status = IPCameraDisplay.this.record ? "[REC]" : "";
                            int prev = 0;
                            int cur = 0;
                            while (prev != 45 && cur != 45) {
                                prev = cur;
                                cur = is.read();
                            }
                            String line = "--" + IPCameraDisplay.this.readLine(is, false);
                            String cl = line = IPCameraDisplay.this.readLine(is, false);
                            while (!line.startsWith("Content-Length:")) {
                                line = IPCameraDisplay.this.readLine(is, false);
                            }
                            cl = line;
                            IPCameraDisplay.this.readLine(is, false);
                            int numBytes = 0;
                            if (cl != null) {
                                numBytes = Integer.parseInt(cl.split(":")[1].trim());
                            }
                            int offset = 2;
                            int r = 0;
                            int count = 0;
                            int lastByte = 0;
                            int thisByte = 0;
                            while (true) {
                                thisByte = is.read();
                                ++count;
                                if (lastByte == 255 && thisByte == 216) break;
                                lastByte = thisByte;
                            }
                            numBytes -= count + offset;
                            IPCameraDisplay.this.cache[0] = -1;
                            IPCameraDisplay.this.cache[1] = -40;
                            while (numBytes > offset) {
                                r = is.read(IPCameraDisplay.this.cache, offset, numBytes - offset);
                                if (r == -1) {
                                    is.close();
                                    IPCameraDisplay.this.imageToDisplay = null;
                                    IPCameraDisplay.this.connected = false;
                                    NeptusLog.pub().error((Object)"IPCamera: disconnected");
                                    System.err.println("IPCamera: disconnected");
                                    break;
                                }
                                offset += r;
                            }
                            if (IPCameraDisplay.this.videoCreator != null && !IPCameraDisplay.this.record) {
                                IPCameraDisplay.this.videoCreator.finishAVI();
                                IPCameraDisplay.this.videoCreator = null;
                            }
                            if (IPCameraDisplay.this.record && IPCameraDisplay.this.imageToDisplay != null) {
                                new File("log/ipcam").mkdirs();
                                if (IPCameraDisplay.this.videoCreator == null) {
                                    IPCameraDisplay.this.videoCreator = new MJPEGCreator(IPCameraDisplay.this.imageToDisplay.getWidth(), IPCameraDisplay.this.imageToDisplay.getHeight(), 10.0);
                                }
                                if (IPCameraDisplay.this.cache.length >= numBytes && numBytes > 0) {
                                    IPCameraDisplay.this.videoCreator.addImage(IPCameraDisplay.this.cache, numBytes);
                                }
                            }
                            ByteArrayInputStream bais = new ByteArrayInputStream(IPCameraDisplay.this.cache, 0, numBytes);
                            ImageInputStream iis = ImageIO.createImageInputStream(bais);
                            IPCameraDisplay.this.imageToDisplay = image = ImageIO.read(iis);
                            IPCameraDisplay.this.repaint();
                        }
                        IPCameraDisplay.this.status = "reconnecting";
                        is.close();
                        get.abort();
                    }
                    catch (Exception e) {
                        IPCameraDisplay.this.status = "Error: " + e.getMessage();
                        e.printStackTrace();
                        NeptusLog.pub().warn((Object)e);
                        IPCameraDisplay.this.repaint();
                        IPCameraDisplay.this.connected = false;
                    }
                    try {
                        Thread.sleep(IPCameraDisplay.this.millisBetweenTries);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().warn((Object)e);
                    }
                }
                NeptusLog.pub().info((Object)"<###>Thread exiting...");
            }
        };
    }

    String readLine(InputStream is, boolean debug) throws IOException {
        int offset = 0;
        int prev = 0;
        int r = 0;
        while (prev != 10) {
            try {
                r = is.read(this.buff, offset, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "ERROR";
            }
            if (r == -1) break;
            if (debug) {
                System.out.printf("%02x ", this.buff[offset]);
            }
            prev = (char)this.buff[offset++];
        }
        if (debug) {
            System.out.println();
        }
        return new String(this.buff, 0, offset).trim();
    }

    public void cleanSubPanel() {
        this.status = "stopping";
        this.url = null;
        this.connected = false;
        this.updater.interrupt();
    }

    public DefaultProperty[] getProperties() {
        this.previousURL = this.url;
        this.wasRecording = this.record;
        return super.getProperties();
    }

    public void propertiesChanged() {
        if (!this.url.equals(this.previousURL)) {
            this.reconnect();
        }
        try {
            if (this.wasRecording && !this.record && this.videoCreator != null) {
                this.videoCreator.finishAVI();
                this.videoCreator = null;
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static void main(String[] args) {
        IPCameraDisplay display = new IPCameraDisplay(null);
        GuiUtils.testFrame((JComponent)((Object)display), (String)"Camera Display");
    }

    public void initSubPanel() {
    }

    public static enum InterpolationStyle {
        Nearest_Neighbour,
        Bilinear,
        Bicubic;

    }
}

