/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ipcam;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class ImagePanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage image = null;
    private boolean initializedFactor = false;
    private double factor;

    public ImagePanel() {
        this.addComponentListener(this);
    }

    protected void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            if (!this.initializedFactor) {
                double factorh;
                this.initializedFactor = true;
                double factorw = (double)this.getWidth() / (double)this.image.getWidth();
                this.factor = factorw < (factorh = (double)this.getHeight() / (double)this.image.getHeight()) ? factorw : factorh;
            }
            ((Graphics2D)g).scale(this.factor, this.factor);
            g.drawImage(this.image, (int)(((double)this.getWidth() - this.factor * (double)this.image.getWidth()) / (this.factor * 2.0)), (int)(((double)this.getHeight() - this.factor * (double)this.image.getHeight()) / (this.factor * 2.0)), null);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.image != null) {
            double factorh;
            double factorw = (double)this.getWidth() / (double)this.image.getWidth();
            this.factor = factorw < (factorh = (double)this.getHeight() / (double)this.image.getHeight()) ? factorw : factorh;
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

