/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ipcam;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class LumeneraPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    BufferedImage image;
    String urltext = "http://10.0.10.74/cgi-usr/nph-image";
    int fps = 25;
    Thread refreshThread;
    public JButton btnRefresh = new JButton(new AbstractAction("Auto-refresh"){
        private static final long serialVersionUID = -1591503925037654541L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LumeneraPanel.this.refreshThread != null) {
                LumeneraPanel.this.refreshThread.interrupt();
            }
            LumeneraPanel.this.refreshThread = LumeneraPanel.this.getRefreshThread();
            LumeneraPanel.this.refreshThread.start();
        }
    });

    public Thread getRefreshThread() {
        return new Thread(new Runnable(){
            public boolean done = false;

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                long interval = 1000 / LumeneraPanel.this.fps;
                while (!this.done) {
                    long delta = System.currentTimeMillis() - currentTime;
                    if (delta < interval) continue;
                    LumeneraPanel.this.fetchNewImage();
                    currentTime = System.currentTimeMillis();
                }
            }
        });
    }

    public void fetchNewImage() {
        try {
            URL url = new URL(this.urltext);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            this.image = ImageIO.read(con.getInputStream());
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        LumeneraPanel panel = new LumeneraPanel();
        f.setLayout((LayoutManager)new MigLayout());
        f.setSize(800, 600);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.add((Component)panel, "w 100%, h 100%, wrap");
        f.add(panel.btnRefresh);
    }
}

