/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ipcam;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.FileUtil;

public class MJPEGCreator {
    int width = 0;
    int height = 0;
    double framerate = 0.0;
    int numFrames = 0;
    boolean countFrames = true;
    File aviFile = null;
    FileOutputStream aviOutput = null;
    FileChannel aviChannel = null;
    long riffOffset = 0L;
    long aviMovieOffset = 0L;
    AVIIndexList indexlist = null;

    public MJPEGCreator(int width, int height, double framerate) throws Exception {
        this(new File("log/ipcam/video_" + System.currentTimeMillis() / 1000L + ".avi"), width, height, framerate);
    }

    public MJPEGCreator(File aviFile, int width, int height, double framerate) throws Exception {
        this(aviFile, width, height, framerate, 0);
    }

    public MJPEGCreator(File aviFile, int width, int height, double framerate, int numFrames) throws Exception {
        if (numFrames != 0) {
            this.countFrames = false;
        }
        this.aviFile = aviFile;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.numFrames = numFrames;
        this.aviOutput = new FileOutputStream(aviFile);
        this.aviChannel = this.aviOutput.getChannel();
        RIFFHeader rh = new RIFFHeader();
        this.aviOutput.write(rh.toBytes());
        this.aviOutput.write(new AVIMainHeader().toBytes());
        this.aviOutput.write(new AVIStreamList().toBytes());
        this.aviOutput.write(new AVIStreamHeader().toBytes());
        this.aviOutput.write(new AVIStreamFormat().toBytes());
        this.aviOutput.write(new AVIJunk().toBytes());
        this.aviMovieOffset = this.aviChannel.position();
        this.aviOutput.write(new AVIMovieList().toBytes());
        this.indexlist = new AVIIndexList();
    }

    public void addImage(File image) throws Exception {
        byte[] imagedata = FileUtil.getFileAsByteArray((String)image.getCanonicalPath());
        this.addImage(imagedata, imagedata.length);
    }

    public void addImage(byte[] imagedata, int length) throws Exception {
        byte[] fcc = new byte[]{48, 48, 100, 98};
        int useLength = length;
        long position = this.aviChannel.position();
        int extra = (useLength + (int)position) % 4;
        if (extra > 0) {
            useLength += extra;
        }
        this.indexlist.addAVIIndex((int)position, useLength);
        this.aviOutput.write(fcc);
        this.aviOutput.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(useLength)));
        this.aviOutput.write(imagedata, 0, length);
        if (this.countFrames) {
            ++this.numFrames;
        }
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                this.aviOutput.write(0);
            }
        }
        imagedata = null;
    }

    public void addImage(Image image) throws Exception {
        byte[] imagedata = this.writeImageToBytes(image);
        this.addImage(imagedata, imagedata.length);
    }

    public void finishAVI() throws Exception {
        NeptusLog.pub().info((Object)"<###>closing avi file...");
        byte[] indexlistBytes = this.indexlist.toBytes();
        this.aviOutput.write(indexlistBytes);
        this.aviOutput.close();
        long size = this.aviFile.length();
        NeptusLog.pub().info((Object)("<###>   adding file size (" + size + ") to file"));
        RandomAccessFile raf = new RandomAccessFile(this.aviFile, "rw");
        raf.seek(4L);
        raf.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt((int)size - 8)));
        raf.seek(this.aviMovieOffset + 4L);
        raf.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt((int)(size - 8L - this.aviMovieOffset - (long)indexlistBytes.length))));
        if (this.countFrames) {
            NeptusLog.pub().info((Object)("<###>   adding frame count (" + this.numFrames + ") to file"));
            raf.seek(48L);
            raf.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.numFrames)));
            raf.seek(140L);
            raf.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.numFrames)));
        }
        raf.close();
        NeptusLog.pub().info((Object)"<###>   done.");
    }

    public static int swapInt(int v) {
        return v >>> 24 | v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00;
    }

    public static short swapShort(short v) {
        return (short)(v >>> 8 | v << 8);
    }

    public static byte[] intBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static byte[] shortBytes(short i) {
        byte[] b = new byte[]{(byte)(i >>> 8), (byte)(i & 0xFF)};
        return b;
    }

    private byte[] writeImageToBytes(Image image) throws Exception {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, this.width, this.height, null);
        ImageIO.write((RenderedImage)bi, "jpg", baos);
        baos.close();
        bi = null;
        g = null;
        return baos.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        double framerate = 10.0;
        File photoDir = new File("./log/ipcam/");
        Object[] files = photoDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("jpg");
            }
        });
        Arrays.sort(files);
        int numFrames = files.length;
        MJPEGCreator m = new MJPEGCreator(new File("movie.avi"), 640, 480, framerate, numFrames);
        for (int i = 0; i < files.length; ++i) {
            NeptusLog.pub().info((Object)("<###>processing file " + (i + 1) + " / " + files.length));
            m.addImage((File)files[i]);
        }
        m.finishAVI();
    }

    private class AVIJunk {
        public byte[] fcc = new byte[]{74, 85, 78, 75};
        public int size = 1808;
        public byte[] data = new byte[this.size];

        public AVIJunk() {
            Arrays.fill(this.data, (byte)0);
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.size)));
            baos.write(this.data);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIIndex {
        public byte[] fcc = new byte[]{48, 48, 100, 98};
        public int dwFlags = 16;
        public int dwOffset = 0;
        public int dwSize = 0;

        public AVIIndex(int dwOffset, int dwSize) {
            this.dwOffset = dwOffset;
            this.dwSize = dwSize;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwFlags)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwOffset)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwSize)));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIIndexList {
        public byte[] fcc = new byte[]{105, 100, 120, 49};
        public int cb = 0;
        public ArrayList<AVIIndex> ind = new ArrayList();

        public void addAVIIndex(int dwOffset, int dwSize) {
            this.ind.add(new AVIIndex(dwOffset, dwSize));
        }

        public byte[] toBytes() throws Exception {
            this.cb = 16 * this.ind.size();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.cb)));
            for (int i = 0; i < this.ind.size(); ++i) {
                AVIIndex in = this.ind.get(i);
                baos.write(in.toBytes());
            }
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIMovieList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int listSize = 0;
        public byte[] fcc2 = new byte[]{109, 111, 118, 105};

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.listSize)));
            baos.write(this.fcc2);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamFormat {
        public byte[] fcc = new byte[]{115, 116, 114, 102};
        public int cb = 40;
        public int biSize = 40;
        public int biWidth = 0;
        public int biHeight = 0;
        public short biPlanes = 1;
        public short biBitCount = (short)24;
        public byte[] biCompression = new byte[]{77, 74, 80, 71};
        public int biSizeImage = 0;
        public int biXPelsPerMeter = 0;
        public int biYPelsPerMeter = 0;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public AVIStreamFormat() {
            this.biWidth = MJPEGCreator.this.width;
            this.biHeight = MJPEGCreator.this.height;
            this.biSizeImage = MJPEGCreator.this.width * MJPEGCreator.this.height;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.cb)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biSize)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biWidth)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biHeight)));
            baos.write(MJPEGCreator.shortBytes(MJPEGCreator.swapShort(this.biPlanes)));
            baos.write(MJPEGCreator.shortBytes(MJPEGCreator.swapShort(this.biBitCount)));
            baos.write(this.biCompression);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biSizeImage)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biXPelsPerMeter)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biYPelsPerMeter)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biClrUsed)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.biClrImportant)));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamHeader {
        public byte[] fcc = new byte[]{115, 116, 114, 104};
        public int cb = 64;
        public byte[] fccType = new byte[]{118, 105, 100, 115};
        public byte[] fccHandler = new byte[]{77, 74, 80, 71};
        public int dwFlags = 0;
        public short wPriority = 0;
        public short wLanguage = 0;
        public int dwInitialFrames = 0;
        public int dwScale = 0;
        public int dwRate = 1000000;
        public int dwStart = 0;
        public int dwLength = 0;
        public int dwSuggestedBufferSize = 0;
        public int dwQuality = -1;
        public int dwSampleSize = 0;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        public AVIStreamHeader() {
            this.dwScale = (int)(1.0 / MJPEGCreator.this.framerate * 1000000.0);
            this.dwLength = MJPEGCreator.this.numFrames;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.cb)));
            baos.write(this.fccType);
            baos.write(this.fccHandler);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwFlags)));
            baos.write(MJPEGCreator.shortBytes(MJPEGCreator.swapShort(this.wPriority)));
            baos.write(MJPEGCreator.shortBytes(MJPEGCreator.swapShort(this.wLanguage)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwInitialFrames)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwScale)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwRate)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwStart)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwLength)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwQuality)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwSampleSize)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.left)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.top)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.right)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.bottom)));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int size = 124;
        public byte[] fcc2 = new byte[]{115, 116, 114, 108};

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.size)));
            baos.write(this.fcc2);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIMainHeader {
        public byte[] fcc = new byte[]{97, 118, 105, 104};
        public int cb = 56;
        public int dwMicroSecPerFrame = 0;
        public int dwMaxBytesPerSec = 10000000;
        public int dwPaddingGranularity = 0;
        public int dwFlags = 65552;
        public int dwTotalFrames = 0;
        public int dwInitialFrames = 0;
        public int dwStreams = 1;
        public int dwSuggestedBufferSize = 0;
        public int dwWidth = 0;
        public int dwHeight = 0;
        public int[] dwReserved = new int[4];

        public AVIMainHeader() {
            this.dwMicroSecPerFrame = (int)(1.0 / MJPEGCreator.this.framerate * 1000000.0);
            this.dwWidth = MJPEGCreator.this.width;
            this.dwHeight = MJPEGCreator.this.height;
            this.dwTotalFrames = MJPEGCreator.this.numFrames;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.cb)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwMicroSecPerFrame)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwMaxBytesPerSec)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwPaddingGranularity)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwFlags)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwTotalFrames)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwInitialFrames)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwStreams)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwWidth)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwHeight)));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwReserved[0])));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwReserved[1])));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwReserved[2])));
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.dwReserved[3])));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class RIFFHeader {
        public byte[] fcc = new byte[]{82, 73, 70, 70};
        public int fileSize = 0;
        public byte[] fcc2 = new byte[]{65, 86, 73, 32};
        public byte[] fcc3 = new byte[]{76, 73, 83, 84};
        public int listSize = 200;
        public byte[] fcc4 = new byte[]{104, 100, 114, 108};

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.fileSize)));
            baos.write(this.fcc2);
            baos.write(this.fcc3);
            baos.write(MJPEGCreator.intBytes(MJPEGCreator.swapInt(this.listSize)));
            baos.write(this.fcc4);
            baos.close();
            return baos.toByteArray();
        }
    }
}

