/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.j3d.browser;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.media.j3d.GraphicsConfigTemplate3D;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.URL;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.web3d.browser.AWTConsoleWindow;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;
import org.web3d.util.LoadURLAction;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.renderer.j3d.browser.VRMLBrowserCanvas;
import org.web3d.vrml.renderer.j3d.browser.VRMLUniverse;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.X3DComponent;

public class X3DBrowserAWTPanel
extends Panel
implements X3DComponent,
BrowserComponent,
ViewpointSelectionListener,
KeyListener,
ComponentListener,
WindowListener,
Runnable,
FileHandler {
    private static final int PAUSED_FPS = 1;
    private static final String BROWSER_BUTTON_PROPERTY = "CONSOLE.button";
    private static final String DEFAULT_BROWSER_BUTTON = "images/navigation/ButtonConsole.gif";
    private static final String BROWSER_OPEN_PROPERTY = "OPEN.button";
    private static final String DEFAULT_OPEN_BUTTON = "images/locationbar/openIcon32x32.gif";
    private static final String BROWSER_RELOAD_PROPERTY = "RELOAD.button";
    private static final String DEFAULT_RELOAD_BUTTON = "images/locationbar/reloadIcon32x32.gif";
    private SAIBrowser saiBrowser;
    private VRMLBrowserCanvas mainCanvas;
    private VRMLUniverse universe;
    private ViewpointManager vpManager;
    private WorldLoaderManager worldLoader;
    private TextField urlTextField;
    private Button locationGoButton;
    private Button openButton;
    private Button reloadButton;
    private Label statusLabel;
    private Label descriptionLabel;
    private Label urlLabel;
    private Label fpsLabel;
    private AWTConsoleWindow console;
    private int numSamples;
    private boolean wireframe;
    private int polygonMode;
    private boolean showFPS;
    private String contentDirectory;
    private int frameCycleTime;
    private float lastFPS;
    private boolean elumensMode;
    private boolean firstFocused;

    public X3DBrowserAWTPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, String string, boolean bl11, String string2, String string3, String string4) {
        this(false, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, string, bl11, string2, string3, string4, null);
    }

    public X3DBrowserAWTPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string, boolean bl12, String string2, String string3, String string4) {
        this(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, string, bl12, string2, string3, string4, null);
    }

    public X3DBrowserAWTPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string, boolean bl12, String string2, String string3, String string4, Properties properties) {
        super(new BorderLayout());
        this.setSize(800, 600);
        this.numSamples = 1;
        this.firstFocused = false;
        this.frameCycleTime = -1;
        this.wireframe = false;
        this.elumensMode = false;
        this.showFPS = bl11;
        this.contentDirectory = string;
        if (string4.equals("medium")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
        } else if (string4.equals("high")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
        }
        if (bl12) {
            if (string2.equals("low")) {
                this.numSamples = 2;
            } else if (string2.equals("medium")) {
                System.out.println("Trying for 4 samples of antialiasing.");
                this.numSamples = 4;
            } else if (string2.equals("high")) {
                System.out.println("Trying for 8 samples of antialiasing.");
                this.numSamples = 8;
            }
        }
        this.console = new AWTConsoleWindow();
        this.console.messageReport("Initializing Java3D X3D browser.\n");
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        this.mainCanvas = new VRMLBrowserCanvas(graphicsConfiguration2, bl);
        this.mainCanvas.initialize();
        this.mainCanvas.addComponentListener(this);
        this.mainCanvas.addKeyListener(this);
        this.descriptionLabel = new Label();
        this.urlLabel = new Label();
        this.add((Component)((Object)this.mainCanvas), "Center");
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        this.vpManager = this.mainCanvas.getViewpointManager();
        this.universe = this.mainCanvas.getUniverse();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        this.console = new AWTConsoleWindow();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        javaSAIScriptEngine.setErrorReporter((ErrorReporter)this.console);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        eCMAScriptEngine.setErrorReporter((ErrorReporter)this.console);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.universe, this.worldLoader);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        x3DCommonBrowser.setErrorReporter((ErrorReporter)this.console);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.console);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, (ErrorReporter)this.console);
        this.urlTextField = new TextField();
        this.statusLabel = new Label();
        this.fpsLabel = new Label();
        if (bl4) {
            Object object;
            Label label = new Label(" Location: ");
            this.locationGoButton = new Button(" Go! ");
            this.locationGoButton.setEnabled(!bl6);
            this.urlTextField.setEditable(!bl6);
            if (!bl6) {
                object = new LoadURLAction((FileHandler)this, this.urlTextField);
                this.locationGoButton.addActionListener((ActionListener)object);
                this.urlTextField.addActionListener((ActionListener)object);
            }
            object = new Panel(new BorderLayout());
            ((Container)object).add((Component)label, "West");
            ((Container)object).add((Component)this.locationGoButton, "East");
            ((Container)object).add((Component)this.urlTextField, "Center");
            if (bl8 || bl9) {
                Panel panel = new Panel(new BorderLayout());
                Panel panel2 = new Panel(new BorderLayout());
                if (bl8) {
                    this.openButton = new Button("Open");
                    panel.add((Component)this.openButton, "West");
                }
                if (bl9) {
                    this.reloadButton = new Button("Reload");
                    panel.add((Component)this.reloadButton, "East");
                }
                panel2.add((Component)panel, "West");
                panel2.add((Component)object, "Center");
                if (bl5) {
                    this.add((Component)panel2, "North");
                } else {
                    this.add((Component)panel2, "South");
                }
            } else if (bl5) {
                this.add((Component)object, "North");
            } else {
                this.add((Component)object, "South");
            }
        }
        if (bl2) {
            this.add((Component)this.descriptionLabel, "South");
            this.add((Component)this.urlLabel, "North");
        }
        this.mainCanvas.setErrorReporter((ErrorReporter)this.console);
        if (bl7) {
            this.console.setVisible(true);
        }
        if (bl11) {
            new Thread(this).start();
        }
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        this.saiBrowser.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 65: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.console.messageReport("Antialiasing not supported on Java3D yet.");
                break;
            }
            case 34: {
                this.vpManager.nextViewpoint();
                break;
            }
            case 33: {
                this.vpManager.previousViewpoint();
                break;
            }
            case 36: {
                this.vpManager.firstViewpoint();
                break;
            }
            case 35: {
                this.vpManager.lastViewpoint();
                break;
            }
            case 70: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("FLY");
                break;
            }
            case 87: {
                if ((keyEvent.getModifiers() & 2) != 0) {
                    this.universe.setNavigationMode("WALK");
                    break;
                }
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.wireframe = !this.wireframe;
                if (this.wireframe) {
                    this.polygonMode = 1;
                    this.statusLabel.setText("Wireframe mode enabled");
                    break;
                }
                this.statusLabel.setText("Wireframe mode disabled");
                this.polygonMode = 2;
                break;
            }
            case 69: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("EXAMINE");
                break;
            }
            case 90: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.elumensMode = !this.elumensMode;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.frameCycleTime < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameCycleTime);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Container container;
        Container container2 = this.getParent();
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        ((Window)container2).addWindowListener(this);
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.frameCycleTime < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameCycleTime);
        }
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Canvas getCanvas() {
        return this.mainCanvas;
    }

    public int getRendererType() {
        return this.universe.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.universe;
    }

    public ErrorReporter getErrorReporter() {
        return this.console;
    }

    public void setMinimumFrameInterval(int n) {
        this.mainCanvas.setMinimumFrameInterval(n);
        this.frameCycleTime = n;
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        this.mainCanvas.setEnabled(false);
        this.mainCanvas.browserShutdown();
    }

    public void viewpointSelected(ViewpointData viewpointData) {
    }

    public void loadURL(String string) throws IOException {
        Object object;
        this.urlTextField.setText(string);
        URL uRL = new URL(string);
        VRMLScene vRMLScene = null;
        long l = System.currentTimeMillis();
        try {
            object = uRL.getResource();
            Object object2 = ((ResourceConnection)object).getContent();
            if (!(object2 instanceof VRMLScene)) {
                if (object2 != null) {
                    System.out.println("Type: " + object2.getClass().toString());
                }
                return;
            }
            vRMLScene = (VRMLScene)object2;
        }
        catch (IOException iOException) {
            return;
        }
        catch (VRMLParseException vRMLParseException) {
            this.console.errorReport("Exception parsing file at line: " + vRMLParseException.getLineNumber() + " col: " + vRMLParseException.getColumnNumber() + "\n" + vRMLParseException.getMessage(), (Exception)((Object)vRMLParseException));
        }
        catch (Exception exception) {
            this.console.errorReport("Unexpected exception during parsing", exception);
        }
        if (vRMLScene == null) {
            return;
        }
        object = uRL.getRef();
        this.universe.setScene(vRMLScene, (String)object);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.firstFocused) {
                this.mainCanvas.requestFocus();
                this.firstFocused = this.mainCanvas.isFocusOwner();
            }
            this.displayFPS();
        }
    }

    private void displayFPS() {
        float f = this.universe.getCurrentFrameRate();
        if ((double)Math.abs(this.lastFPS - f) > 0.01) {
            String string = Float.toString(this.universe.getCurrentFrameRate());
            int n = string.length();
            if (n > 0) {
                this.fpsLabel.setText(string.substring(0, Math.min(5, n)));
            }
            this.lastFPS = f;
        }
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory(uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory(contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap(fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }
}

