/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.j3d.device.mouse;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerState;

public class MouseTracker
extends Tracker
implements MouseListener,
MouseMotionListener {
    private static final int mask = 14;
    private TrackerState tstate;
    private Vector3d mousePickDirection = new Vector3d(0.0, 0.0, -1.0);
    private Point3d mouseEyePosition = new Point3d();
    private Point3d mousePosition = new Point3d();
    private Transform3D viewTransform = new Transform3D();

    public MouseTracker() {
        this.tstate = new TrackerState();
        this.tstate.numButtons = 3;
        this.tstate.buttonMode[0] = 10;
        this.tstate.pickingEnabled[0] = true;
        this.tstate.buttonMode[1] = 0;
        this.tstate.pickingEnabled[1] = false;
        this.tstate.buttonMode[2] = 10;
        this.tstate.pickingEnabled[2] = false;
    }

    public int getActionMask() {
        return 14;
    }

    public void getState(TrackerState trackerState) {
        trackerState.actionMask = 14;
        trackerState.actionType = this.tstate.actionType;
        trackerState.devicePos[0] = this.tstate.devicePos[0];
        trackerState.devicePos[1] = this.tstate.devicePos[1];
        trackerState.devicePos[2] = this.tstate.devicePos[2];
        trackerState.deviceOri[0] = this.tstate.deviceOri[0];
        trackerState.deviceOri[1] = this.tstate.deviceOri[1];
        trackerState.deviceOri[2] = this.tstate.deviceOri[2];
        trackerState.worldPos[0] = this.tstate.worldPos[0];
        trackerState.worldPos[1] = this.tstate.worldPos[1];
        trackerState.worldPos[2] = this.tstate.worldPos[2];
        trackerState.worldOri[0] = this.tstate.worldOri[0];
        trackerState.worldOri[1] = this.tstate.worldOri[1];
        trackerState.worldOri[2] = this.tstate.worldOri[2];
        trackerState.numButtons = this.tstate.numButtons;
        for (int i = 0; i < this.tstate.numButtons; ++i) {
            trackerState.buttonMode[i] = this.tstate.buttonMode[i];
            trackerState.buttonState[i] = this.tstate.buttonState[i];
            trackerState.pickingEnabled[i] = this.tstate.pickingEnabled[i];
        }
        this.tstate.actionType = 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.tstate.actionType = 2;
        int n = mouseEvent.getModifiersEx();
        this.tstate.buttonState[0] = (n & 0x400) == 1024;
        this.tstate.buttonState[1] = (n & 0x800) == 2048;
        this.tstate.buttonState[2] = (n & 0x1000) == 4096;
        this.transformMouse(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.tstate.actionType = this.tstate.actionType == 2 ? 8 : 16;
        this.transformMouse(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.tstate.actionType == 0 || this.tstate.actionType == 4) {
            this.tstate.actionType = 4;
            this.transformMouse(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tstate.actionType == 0 || this.tstate.actionType == 32) {
            this.tstate.actionType = 32;
            this.transformMouse(mouseEvent);
        }
    }

    private void transformMouse(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        float f = component.getHeight();
        float f2 = component.getWidth();
        this.tstate.devicePos[0] = (float)mouseEvent.getX() / f2;
        this.tstate.devicePos[1] = (float)mouseEvent.getY() / f;
        this.tstate.devicePos[2] = 0.0f;
        Canvas3D canvas3D = (Canvas3D)mouseEvent.getSource();
        canvas3D.getCenterEyeInImagePlate(this.mouseEyePosition);
        canvas3D.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), this.mousePosition);
        canvas3D.getImagePlateToVworld(this.viewTransform);
        this.viewTransform.transform(this.mouseEyePosition);
        this.viewTransform.transform(this.mousePosition);
        this.mousePickDirection.sub((Tuple3d)this.mousePosition, (Tuple3d)this.mouseEyePosition);
        this.tstate.worldPos[0] = (float)this.mouseEyePosition.x;
        this.tstate.worldPos[1] = (float)this.mouseEyePosition.y;
        this.tstate.worldPos[2] = (float)this.mouseEyePosition.z;
        this.tstate.worldOri[0] = (float)this.mousePickDirection.x;
        this.tstate.worldOri[1] = (float)this.mousePickDirection.y;
        this.tstate.worldOri[2] = (float)this.mousePickDirection.z;
    }
}

