/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.j3d.loaders;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URN;
import org.j3d.renderer.java3d.loaders.ManagedLoader;
import org.web3d.browser.BrowserCore;
import org.web3d.j3d.loaders.J3DScene;
import org.web3d.j3d.loaders.SequentialContentLoader;
import org.web3d.j3d.loaders.StaticBrowserCore;
import org.web3d.j3d.loaders.StaticRouteManager;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.resolve.Web3DURNResolver;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.DefaultScriptLoader;
import org.web3d.vrml.nodes.loader.DefaultWorldLoaderManager;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.MemCacheLoadManager;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.DefaultHumanoidManager;
import org.web3d.vrml.nodes.runtime.DefaultNetworkManager;
import org.web3d.vrml.nodes.runtime.DefaultRouteManager;
import org.web3d.vrml.nodes.runtime.DefaultScriptManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedEventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedFrameStateManager;
import org.web3d.vrml.nodes.runtime.GeneralisedViewpointManager;
import org.web3d.vrml.nodes.runtime.ListsRouterFactory;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.RouterFactory;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.j3d.J3DSceneBuilderFactory;
import org.web3d.vrml.renderer.j3d.browser.VRMLBranchGroup;
import org.web3d.vrml.renderer.j3d.input.DefaultSensorManager;
import org.web3d.vrml.renderer.j3d.input.J3DUserInputHandler;
import org.web3d.vrml.renderer.j3d.input.UserInputBehavior;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;

public abstract class BaseLoader
extends LoaderBase
implements ManagedLoader {
    protected VRMLParserFactory parserFactory;
    private static boolean setupComplete = false;
    protected boolean vrml97Only = false;
    protected Map overrideCapBitsMap;
    protected Map requiredCapBitsMap;
    protected Map overrideFreqBitsMap;
    protected Map requiredFreqBitsMap;
    protected ErrorReporter errorReporter;
    protected VRMLScene parsedScene;
    private boolean navigationEnabled = false;
    private Web3DURNResolver resolver = new Web3DURNResolver();

    protected BaseLoader() {
        this(0);
    }

    public BaseLoader(int n) {
        super(n);
        try {
            this.parserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
    }

    public Scene load(Reader reader) throws IncorrectFormatException, ParsingErrorException {
        URL uRL = this.getBaseUrl();
        String string = null;
        if (uRL == null) {
            try {
                string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                System.out.println("Cannot get user dir in BaseLoader");
            }
        } else {
            string = uRL.toString();
        }
        InputSource inputSource = new InputSource(string, reader);
        return this.load(inputSource);
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        InputSource inputSource = new InputSource(file);
        return this.load(inputSource);
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputSource inputSource = new InputSource(uRL);
        return this.load(inputSource);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        this.overrideCapBitsMap = map;
        this.overrideFreqBitsMap = map2;
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        this.requiredCapBitsMap = map;
        this.requiredFreqBitsMap = map2;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public VRMLScene getVRMLScene() {
        return this.parsedScene;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void registerURNLocation(String string, String string2) throws IllegalArgumentException {
        this.resolver.registerPrefixLocation(string, string2);
    }

    private Scene load(InputSource inputSource) throws IncorrectFormatException, ParsingErrorException {
        boolean bl = (this.loadFlags & 4) != 0;
        boolean bl2 = (this.loadFlags & 2) != 0;
        boolean bl3 = (this.loadFlags & 1) != 0;
        boolean bl4 = (this.loadFlags & 0x20) != 0;
        boolean bl5 = (this.loadFlags & 0x10) != 0;
        boolean bl6 = (this.loadFlags & 8) != 0;
        J3DSceneBuilderFactory j3DSceneBuilderFactory = new J3DSceneBuilderFactory(this.vrml97Only, bl, bl2, bl3, bl4, bl5, bl6);
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        GeneralisedFrameStateManager generalisedFrameStateManager = new GeneralisedFrameStateManager();
        DefaultWorldLoaderManager defaultWorldLoaderManager = new DefaultWorldLoaderManager((FrameStateManager)generalisedFrameStateManager);
        defaultWorldLoaderManager.setErrorReporter(this.errorReporter);
        defaultWorldLoaderManager.registerBuilderFactory(1, (SceneBuilderFactory)j3DSceneBuilderFactory);
        defaultWorldLoaderManager.registerParserFactory(1, vRMLParserFactory);
        J3DScene j3DScene = new J3DScene();
        if (bl6) {
            DefaultRouteManager defaultRouteManager = new DefaultRouteManager();
            defaultRouteManager.setRouterFactory((RouterFactory)new ListsRouterFactory());
            DefaultScriptManager defaultScriptManager = new DefaultScriptManager();
            DefaultSensorManager defaultSensorManager = new DefaultSensorManager();
            defaultSensorManager.setNavigationEnabled(this.navigationEnabled);
            GeneralisedEventModelEvaluator generalisedEventModelEvaluator = new GeneralisedEventModelEvaluator();
            MemCacheLoadManager memCacheLoadManager = new MemCacheLoadManager();
            DefaultHumanoidManager defaultHumanoidManager = new DefaultHumanoidManager();
            DefaultNetworkManager defaultNetworkManager = new DefaultNetworkManager();
            DISProtocolHandler dISProtocolHandler = new DISProtocolHandler();
            defaultNetworkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
            NodeManager[] nodeManagerArray = new NodeManager[]{defaultHumanoidManager, defaultNetworkManager};
            GeneralisedViewpointManager generalisedViewpointManager = new GeneralisedViewpointManager();
            generalisedEventModelEvaluator.initialize((ScriptManager)defaultScriptManager, (RouteManager)defaultRouteManager, (SensorManager)defaultSensorManager, (FrameStateManager)generalisedFrameStateManager, (ExternalLoadManager)memCacheLoadManager, (ViewpointManager)generalisedViewpointManager, nodeManagerArray);
            generalisedEventModelEvaluator.setErrorReporter(this.errorReporter);
            VRMLBranchGroup vRMLBranchGroup = new VRMLBranchGroup(!bl6, (EventModelEvaluator)generalisedEventModelEvaluator);
            WorldLoader worldLoader = defaultWorldLoaderManager.fetchLoader();
            this.setupProperties(vRMLBranchGroup, (WorldLoaderManager)defaultWorldLoaderManager);
            try {
                this.parsedScene = worldLoader.loadNow((BrowserCore)vRMLBranchGroup, inputSource);
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
            defaultWorldLoaderManager.releaseLoader(worldLoader);
            UserInputBehavior userInputBehavior = new UserInputBehavior();
            j3DScene.addBehavior(userInputBehavior);
            vRMLBranchGroup.addChild((Node)userInputBehavior);
            J3DUserInputHandler j3DUserInputHandler = (J3DUserInputHandler)defaultSensorManager.getUserInputHandler();
            j3DUserInputHandler.setNavigationEnabled(this.navigationEnabled);
            DefaultScriptLoader defaultScriptLoader = new DefaultScriptLoader();
            defaultScriptManager.setScriptLoader((ScriptLoader)defaultScriptLoader);
            VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)vRMLBranchGroup, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)vRMLBranchGroup, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            vRML97ScriptEngine.setErrorReporter(this.errorReporter);
            javascriptScriptEngine.setErrorReporter(this.errorReporter);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
            Behavior[] behaviorArray = vRMLBranchGroup.getSystemBehaviors();
            for (int i = 0; i < behaviorArray.length; ++i) {
                j3DScene.addBehavior(behaviorArray[i]);
            }
            vRMLBranchGroup.setScene(this.parsedScene, null);
            j3DScene.setRootNode(vRMLBranchGroup);
        } else {
            StaticRouteManager staticRouteManager = new StaticRouteManager();
            StaticBrowserCore staticBrowserCore = new StaticBrowserCore();
            this.setupProperties(staticBrowserCore, (WorldLoaderManager)defaultWorldLoaderManager);
            SequentialContentLoader sequentialContentLoader = new SequentialContentLoader(vRMLParserFactory, j3DSceneBuilderFactory, (FrameStateManager)generalisedFrameStateManager, staticBrowserCore);
            VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)staticBrowserCore, (RouteManager)staticRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            vRML97ScriptEngine.setErrorReporter(this.errorReporter);
            JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)staticBrowserCore, (RouteManager)staticRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            javascriptScriptEngine.setErrorReporter(this.errorReporter);
            sequentialContentLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
            sequentialContentLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
            try {
                this.parsedScene = sequentialContentLoader.loadContent(inputSource);
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
            J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.parsedScene.getRootNode();
            BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
            j3DScene.setRootNode(branchGroup);
        }
        j3DScene.setValues(this.parsedScene);
        return j3DScene;
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileNameMap fileNameMap;
                ContentHandlerFactory contentHandlerFactory;
                System.setProperty("sun.awt.font.advancecache", "off");
                if (System.getProperty("uri.content.handler.pkgs") == null) {
                    System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                }
                if (System.getProperty("uri.protocol.handler.pkgs") == null) {
                    System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                }
                if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                    contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                    URI.setContentHandlerFactory(contentHandlerFactory);
                }
                if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                    fileNameMap = new VRMLFileNameMap(fileNameMap);
                    URI.setFileNameMap(fileNameMap);
                }
                URN.addResolver(BaseLoader.this.resolver);
                BaseLoader.this.setupPropertiesProtected();
                return null;
            }
        });
        setupComplete = true;
    }

    void setupPropertiesProtected() {
    }
}

