/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.j3d.loaders;

import com.sun.j3d.loaders.Scene;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Fog;
import javax.media.j3d.Light;
import javax.media.j3d.Sound;
import javax.media.j3d.TransformGroup;
import org.web3d.util.FloatArray;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DLightNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DScene
implements Scene {
    private static final Background[] EMPTY_BACKGROUND = new Background[0];
    private static final Behavior[] EMPTY_BEHAVIOR = new Behavior[0];
    private static final Fog[] EMPTY_FOG = new Fog[0];
    private static final Light[] EMPTY_LIGHT = new Light[0];
    private static final Sound[] EMPTY_SOUND = new Sound[0];
    private static final TransformGroup[] EMPTY_VIEW = new TransformGroup[0];
    private String description;
    private BranchGroup rootNode;
    private Hashtable defMap = new Hashtable();
    private ArrayList backgrounds = new ArrayList(0);
    private ArrayList behaviors = new ArrayList(0);
    private ArrayList fogs = new ArrayList(0);
    private float[] fovs;
    private ArrayList lights;
    private ArrayList sounds = new ArrayList(0);
    private ArrayList views;

    J3DScene() {
        this.lights = new ArrayList(0);
        this.views = new ArrayList(0);
        this.fovs = new float[0];
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public Background[] getBackgroundNodes() {
        Background[] backgroundArray = null;
        if (this.backgrounds.size() != 0) {
            backgroundArray = this.backgrounds.toArray(EMPTY_BACKGROUND);
        }
        return backgroundArray;
    }

    public Behavior[] getBehaviorNodes() {
        Behavior[] behaviorArray = null;
        if (this.behaviors.size() != 0) {
            behaviorArray = this.behaviors.toArray(EMPTY_BEHAVIOR);
        }
        return behaviorArray;
    }

    public Fog[] getFogNodes() {
        Fog[] fogArray = null;
        if (this.fogs.size() != 0) {
            fogArray = this.fogs.toArray(EMPTY_FOG);
        }
        return fogArray;
    }

    public float[] getHorizontalFOVs() {
        float[] fArray = null;
        if (this.fovs != null) {
            fArray = new float[this.fovs.length];
            System.arraycopy(this.fovs, 0, fArray, 0, this.fovs.length);
        }
        return fArray;
    }

    public Light[] getLightNodes() {
        Light[] lightArray = null;
        if (this.lights.size() != 0) {
            lightArray = this.lights.toArray(EMPTY_LIGHT);
        }
        return lightArray;
    }

    public Sound[] getSoundNodes() {
        Sound[] soundArray = null;
        if (this.sounds.size() != 0) {
            soundArray = this.sounds.toArray(EMPTY_SOUND);
        }
        return soundArray;
    }

    public TransformGroup[] getViewGroups() {
        TransformGroup[] transformGroupArray = null;
        if (this.views.size() != 0) {
            transformGroupArray = this.views.toArray(EMPTY_VIEW);
        }
        return transformGroupArray;
    }

    public BranchGroup getSceneGroup() {
        return this.rootNode;
    }

    public Hashtable getNamedObjects() {
        return this.defMap;
    }

    void addBehavior(Behavior behavior) {
        if (behavior != null) {
            this.behaviors.add(behavior);
        }
    }

    void setValues(VRMLScene vRMLScene) {
        Light[] lightArray;
        int n;
        ArrayList arrayList;
        J3DVRMLNode j3DVRMLNode;
        Map map = vRMLScene.getDEFNodes();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            j3DVRMLNode = (J3DVRMLNode)map.get(k);
            arrayList = j3DVRMLNode.getSceneGraphObject();
            if (arrayList == null) continue;
            this.defMap.put(k, arrayList);
        }
        arrayList = vRMLScene.getBySecondaryType(5);
        int n2 = arrayList.size();
        FloatArray floatArray = new FloatArray();
        block6: for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (J3DVRMLNode)arrayList.get(n);
            int n3 = j3DVRMLNode.getPrimaryType();
            switch (n3) {
                case 4: {
                    this.backgrounds.add(j3DVRMLNode.getSceneGraphObject());
                    continue block6;
                }
                case 18: {
                    this.fogs.add(j3DVRMLNode.getSceneGraphObject());
                    continue block6;
                }
                case 55: {
                    floatArray.add(((VRMLViewpointNodeType)j3DVRMLNode).getFieldOfView());
                    lightArray = (Light[])j3DVRMLNode;
                    this.views.add(lightArray.getPlatformGroup());
                }
            }
        }
        arrayList = vRMLScene.getByPrimaryType(27);
        n2 = arrayList.size();
        this.lights.ensureCapacity(n2 * 2);
        for (n = 0; n < n2; ++n) {
            J3DLightNodeType j3DLightNodeType = (J3DLightNodeType)arrayList.get(n);
            lightArray = j3DLightNodeType.getLights();
            for (int i = 0; i < lightArray.length; ++i) {
                this.lights.add(lightArray[i]);
            }
        }
        arrayList = vRMLScene.getByPrimaryType(27);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (J3DVRMLNode)arrayList.get(n);
            this.sounds.add(j3DVRMLNode.getSceneGraphObject());
        }
        this.fovs = floatArray.toArray();
    }

    void setRootNode(BranchGroup branchGroup) {
        this.rootNode = branchGroup;
    }
}

