/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.j3d.loaders;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.web3d.browser.BrowserCore;
import org.web3d.j3d.loaders.CacheDetails;
import org.web3d.j3d.loaders.WeakRefFileCache;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.loader.SceneBuilder;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLReader;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;

class SequentialContentLoader {
    private static final String JAVA_MIME = "application/x-java";
    private static WeakRefFileCache cache = new WeakRefFileCache();
    private BrowserCore browserCore;
    private FrameStateManager stateManager;
    private VRMLParserFactory parserFactory;
    private SceneBuilder builder;
    private ErrorReporter errorReporter;
    private VRMLReader reader;
    private HashMap engineMap;

    SequentialContentLoader(VRMLParserFactory vRMLParserFactory, SceneBuilderFactory sceneBuilderFactory, FrameStateManager frameStateManager, BrowserCore browserCore) {
        this.parserFactory = vRMLParserFactory;
        this.stateManager = frameStateManager;
        this.browserCore = browserCore;
        this.builder = sceneBuilderFactory.createBuilder();
        this.builder.setFrameStateManager(this.stateManager);
        this.engineMap = new HashMap();
    }

    VRMLScene loadContent(InputSource inputSource) throws IOException {
        this.reader = this.parserFactory.newVRMLReader();
        this.reader.setContentHandler((ContentHandler)this.builder);
        this.reader.setScriptHandler((ScriptHandler)this.builder);
        this.reader.setProtoHandler((ProtoHandler)this.builder);
        this.reader.setRouteHandler((RouteHandler)this.builder);
        this.reader.parse(inputSource);
        VRMLScene vRMLScene = this.builder.getScene();
        this.loadScene(vRMLScene);
        return vRMLScene;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.builder.setErrorReporter(this.errorReporter);
    }

    public void registerScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.engineMap.put(stringArray[i], scriptEngine);
        }
    }

    private void loadScene(VRMLScene vRMLScene) {
        VRMLScriptNodeType vRMLScriptNodeType;
        int n;
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)vRMLScene.getRootNode();
        ArrayList arrayList = vRMLScene.getByPrimaryType(41);
        int n2 = arrayList.size();
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                vRMLScriptNodeType = (VRMLScriptNodeType)arrayList.get(n);
                this.loadScript(vRMLScriptNodeType);
            }
        }
        if ((n2 = (arrayList = vRMLScene.getByPrimaryType(24)).size()) != 0) {
            for (n = 0; n < n2; ++n) {
                vRMLScriptNodeType = (VRMLInlineNodeType)arrayList.get(n);
                this.loadInlineNode((VRMLInlineNodeType)vRMLScriptNodeType);
            }
        }
        if ((n2 = (arrayList = vRMLScene.getBySecondaryType(44)).size()) != 0) {
            for (n = 0; n < n2; ++n) {
                vRMLScriptNodeType = (VRMLSingleExternalNodeType)arrayList.get(n);
                if (vRMLScriptNodeType instanceof VRMLInlineNodeType || vRMLScriptNodeType instanceof VRMLScriptNodeType) continue;
                this.loadExternalNode((VRMLSingleExternalNodeType)vRMLScriptNodeType);
            }
        }
        if ((n2 = (arrayList = vRMLScene.getBySecondaryType(30)).size()) != 0) {
            for (n = 0; n < n2; ++n) {
                vRMLScriptNodeType = (VRMLMultiExternalNodeType)arrayList.get(n);
                this.loadExternalNode((VRMLMultiExternalNodeType)vRMLScriptNodeType);
            }
        }
    }

    private void loadExternalNode(VRMLSingleExternalNodeType vRMLSingleExternalNodeType) {
        boolean bl = false;
        Object object = null;
        if (vRMLSingleExternalNodeType.getLoadState() == 3) {
            return;
        }
        vRMLSingleExternalNodeType.setLoadState(2);
        String[] stringArray = vRMLSingleExternalNodeType.getUrl();
        int n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; !bl && i < n; ++i) {
            CacheDetails cacheDetails;
            String string = stringArray[i];
            int n2 = string.lastIndexOf(35);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if ((cacheDetails = cache.checkForFile(string)) != null) {
                String string2 = cacheDetails.getContentType();
                object = cacheDetails.getContent();
                if (!vRMLSingleExternalNodeType.checkValidContentType(string2)) continue;
                vRMLSingleExternalNodeType.setLoadedURI(stringArray[i]);
                vRMLSingleExternalNodeType.setContent(string2, object);
                bl = true;
                continue;
            }
            bl = this.loadExternal(stringArray[i], string, vRMLSingleExternalNodeType);
        }
        if (bl) {
            vRMLSingleExternalNodeType.setLoadState(3);
        } else {
            vRMLSingleExternalNodeType.setLoadState(4);
        }
    }

    private void loadExternalNode(VRMLMultiExternalNodeType vRMLMultiExternalNodeType) {
        int[] nArray = vRMLMultiExternalNodeType.getUrlFieldIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            this.loadExternalNode(vRMLMultiExternalNodeType, nArray[i]);
        }
    }

    private void loadExternalNode(VRMLMultiExternalNodeType vRMLMultiExternalNodeType, int n) {
        boolean bl = false;
        if (vRMLMultiExternalNodeType.getLoadState(n) == 3) {
            return;
        }
        vRMLMultiExternalNodeType.setLoadState(n, 2);
        String[] stringArray = vRMLMultiExternalNodeType.getUrl(n);
        int n2 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; !bl && i < n2; ++i) {
            CacheDetails cacheDetails;
            String string = stringArray[i];
            int n3 = string.lastIndexOf(35);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if ((cacheDetails = cache.checkForFile(string)) != null) {
                String string2 = cacheDetails.getContentType();
                Object object = cacheDetails.getContent();
                if (!vRMLMultiExternalNodeType.checkValidContentType(n, string2)) continue;
                vRMLMultiExternalNodeType.setLoadedURI(n, stringArray[i]);
                vRMLMultiExternalNodeType.setContent(n, string2, object);
                bl = true;
                continue;
            }
            bl = this.loadExternal(stringArray[i], string, n, vRMLMultiExternalNodeType);
        }
        if (bl) {
            vRMLMultiExternalNodeType.setLoadState(n, 3);
        } else {
            vRMLMultiExternalNodeType.setLoadState(n, 4);
        }
    }

    private void loadInlineNode(VRMLInlineNodeType vRMLInlineNodeType) {
        boolean bl = false;
        String[] stringArray = vRMLInlineNodeType.getUrl();
        URL[] uRLArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                URI uRI = URIUtils.createURI(stringArray[i]);
                uRLArray = uRI.getURLList();
            }
            catch (IOException iOException) {
                continue;
            }
            if (uRLArray == null) continue;
            for (int j = 0; j < uRLArray.length; ++j) {
                try {
                    InputSource inputSource = new InputSource(uRLArray[j]);
                    this.builder.reset();
                    this.reader.parse(inputSource);
                    VRMLScene vRMLScene = this.builder.getScene();
                    vRMLInlineNodeType.setContent("model/vrml", (Object)vRMLScene);
                    this.loadScene(vRMLScene);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean loadExternal(String string, String string2, VRMLSingleExternalNodeType vRMLSingleExternalNodeType) {
        boolean bl = false;
        URL[] uRLArray = null;
        Object object = null;
        try {
            URI uRI = URIUtils.createURI(string2);
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            return false;
        }
        if (uRLArray == null) {
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            ResourceConnection resourceConnection;
            try {
                resourceConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                continue;
            }
            try {
                String string3;
                if (!this.makeConnection(resourceConnection) || (string3 = resourceConnection.getContentType()) == null || (object = resourceConnection.getContent()) == null) continue;
                if (!vRMLSingleExternalNodeType.checkValidContentType(string3)) {
                    resourceConnection.close();
                    continue;
                }
                vRMLSingleExternalNodeType.setLoadedURI(string);
                vRMLSingleExternalNodeType.setContent(string3, object);
                cache.cacheFile(string2, string3, object);
                bl = true;
                break;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.errorReport("Error setting external content:", (Exception)illegalArgumentException);
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                // empty catch block
            }
        }
        if (object instanceof VRMLScene) {
            this.loadScene((VRMLScene)object);
        }
        return bl;
    }

    private boolean loadExternal(String string, String string2, int n, VRMLMultiExternalNodeType vRMLMultiExternalNodeType) {
        boolean bl = false;
        URL[] uRLArray = null;
        try {
            URI uRI = URIUtils.createURI(string2);
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            return false;
        }
        if (uRLArray == null) {
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            ResourceConnection resourceConnection;
            try {
                resourceConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                continue;
            }
            try {
                Object object;
                String string3;
                if (!this.makeConnection(resourceConnection) || (string3 = resourceConnection.getContentType()) == null || (object = resourceConnection.getContent()) == null) continue;
                if (!vRMLMultiExternalNodeType.checkValidContentType(n, string3)) {
                    resourceConnection.close();
                    continue;
                }
                vRMLMultiExternalNodeType.setLoadedURI(n, string);
                vRMLMultiExternalNodeType.setContent(n, string3, object);
                cache.cacheFile(string2, string3, object);
                bl = true;
                break;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.errorReport("Error setting external content:", (Exception)illegalArgumentException);
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void loadScript(VRMLScriptNodeType vRMLScriptNodeType) {
        vRMLScriptNodeType.setLoadState(2);
        String[] stringArray = vRMLScriptNodeType.getUrl();
        URL[] uRLArray = null;
        boolean bl = false;
        block10: for (int i = 0; !bl && i < stringArray.length; ++i) {
            String string;
            String string2;
            Object object;
            String string3;
            CacheDetails cacheDetails;
            String string4 = stringArray[i];
            int n = string4.lastIndexOf(35);
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
            if ((cacheDetails = cache.checkForFile(string4)) != null) {
                string3 = cacheDetails.getContentType();
                ScriptEngine scriptEngine = (ScriptEngine)this.engineMap.get(string3);
                if (scriptEngine == null) continue;
                object = cacheDetails.getContent();
                bl = true;
                try {
                    string2 = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string3, object);
                    vRMLScriptNodeType.setContent(string3, (Object)string2);
                }
                catch (InvalidScriptContentException invalidScriptContentException) {
                    string = "Invalid content for script " + string4;
                    this.errorReporter.errorReport(string, (Exception)((Object)invalidScriptContentException));
                }
                continue;
            }
            if (string4.endsWith(".class")) {
                ScriptEngine scriptEngine = (ScriptEngine)this.engineMap.get(JAVA_MIME);
                bl = this.loadClass(string4, vRMLScriptNodeType, scriptEngine);
            }
            try {
                URI uRI = URIUtils.createURI(string4);
                uRLArray = uRI.getURLList();
            }
            catch (IOException iOException) {
                string2 = "URI does not resolve to anything useful.\nURI is " + string4;
                this.errorReporter.warningReport(string2, (Exception)iOException);
            }
            if (uRLArray == null) {
                this.errorReporter.warningReport("Script contains no URLs. Ignoring", null);
                continue;
            }
            for (int j = 0; j < uRLArray.length; ++j) {
                ResourceConnection resourceConnection;
                try {
                    resourceConnection = uRLArray[j].getResource();
                }
                catch (IOException iOException) {
                    string = "Can't find resource " + uRLArray[j];
                    this.errorReporter.warningReport(string, (Exception)iOException);
                    continue;
                }
                if (!this.makeConnection(resourceConnection)) continue;
                try {
                    string3 = resourceConnection.getContentType();
                    if (string3 == null || (string2 = (ScriptEngine)this.engineMap.get(string3)) == null) continue;
                    object = resourceConnection.getContent();
                    string = string2.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string3, object);
                    cache.cacheFile(string4, string3, object);
                    vRMLScriptNodeType.setContent(string3, (Object)string);
                    bl = true;
                    continue block10;
                }
                catch (IOException iOException) {
                    string = "IO Error reading external file " + string4;
                    this.errorReporter.warningReport(string, (Exception)iOException);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorReporter.warningReport("Can't set external content", (Exception)illegalArgumentException);
                    continue;
                }
                catch (InvalidScriptContentException invalidScriptContentException) {
                    string = "Invalid content for script url " + string4;
                    this.errorReporter.warningReport(string, (Exception)((Object)invalidScriptContentException));
                }
            }
        }
        if (bl) {
            vRMLScriptNodeType.setLoadState(3);
            vRMLScriptNodeType.initialize(0.0);
        } else {
            vRMLScriptNodeType.setLoadState(4);
            this.errorReporter.errorReport("Could not load any URLs for script", null);
        }
    }

    private boolean loadClass(String string, VRMLScriptNodeType vRMLScriptNodeType, ScriptEngine scriptEngine) {
        boolean bl = true;
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, n2);
        String string4 = null;
        Throwable throwable = null;
        try {
            java.net.URL[] uRLArray = new java.net.URL[]{new java.net.URL(string2)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = uRLClassLoader.loadClass(string3);
            ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
            cache.cacheFile(string, JAVA_MIME, clazz);
            vRMLScriptNodeType.setContent(JAVA_MIME, (Object)scriptWrapper);
        }
        catch (MalformedURLException malformedURLException) {
            string4 = "Invalid URL for the script " + string2;
            throwable = malformedURLException;
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string4 = "Couldn't find the Java class " + string3 + " at: " + string2;
            throwable = classNotFoundException;
            bl = false;
        }
        catch (InvalidScriptContentException invalidScriptContentException) {
            string4 = "Invalid content for script " + string;
            throwable = invalidScriptContentException;
            bl = false;
        }
        if (string4 != null) {
            this.errorReporter.errorReport(string4, (Exception)throwable);
        }
        return bl;
    }

    private boolean makeConnection(final ResourceConnection resourceConnection) {
        boolean bl = true;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    resourceConnection.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = "IO Error reading external file " + resourceConnection.getURI();
            bl = false;
            this.errorReporter.warningReport(string, privilegedActionException.getException());
        }
        return bl;
    }
}

