/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d;

import java.util.Map;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLLinkNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRExternPrototypeDecl;
import org.web3d.vrml.renderer.CRMainSceneBuilder;
import org.web3d.vrml.renderer.j3d.J3DExternProtoCreator;
import org.web3d.vrml.renderer.j3d.J3DProtoCreator;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;
import org.web3d.vrml.sav.SAVException;

class J3DMainSceneBuilder
extends CRMainSceneBuilder {
    private J3DExternProtoCreator externProtoCreator;
    private Map overrideCapBitsMap;
    private Map requiredCapBitsMap;
    private Map overrideFreqBitsMap;
    private Map requiredFreqBitsMap;
    private boolean haveCapBitsMaps;

    J3DMainSceneBuilder(VRMLNodeFactory vRMLNodeFactory) {
        super(vRMLNodeFactory);
    }

    public void reset() {
        super.reset();
        this.haveCapBitsMaps = false;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        this.overrideCapBitsMap = map;
        this.overrideFreqBitsMap = map2;
        if (map != null || map2 != null) {
            this.haveCapBitsMaps = true;
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        this.requiredCapBitsMap = map;
        this.requiredFreqBitsMap = map2;
        if (map != null || map2 != null) {
            this.haveCapBitsMaps = true;
        }
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        super.startDocument(string, string2, string3, string4, string5, string6);
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentNode;
        if (this.haveCapBitsMaps) {
            j3DVRMLNode.setCapabilityOverrideMap(this.overrideCapBitsMap, this.overrideFreqBitsMap);
            j3DVRMLNode.setCapabilityRequiredMap(this.requiredCapBitsMap, this.requiredFreqBitsMap);
        }
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        int n;
        Object object;
        CRExternPrototypeDecl cRExternPrototypeDecl;
        PrototypeDecl prototypeDecl;
        if (this.ignoreNodeCounter > 0) {
            ++this.ignoreNodeCounter;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add((Object)string2);
            }
            return;
        }
        if (this.badFieldName) {
            this.ignoreNodeCounter = 1;
            return;
        }
        if (this.staticDepthCounter > 0) {
            ++this.staticDepthCounter;
        }
        J3DVRMLNode j3DVRMLNode = null;
        if (this.protoMap.containsKey(string) || this.externProtoMap.containsKey(string)) {
            prototypeDecl = null;
            prototypeDecl = (PrototypeDecl)this.protoMap.get(string);
            if (prototypeDecl == null && (prototypeDecl = (PrototypeDecl)(cRExternPrototypeDecl = (CRExternPrototypeDecl)this.externProtoMap.get(string)).getProtoDetails()) == null) {
                if (this.externProtoCreator == null) {
                    this.externProtoCreator = new J3DExternProtoCreator(this.worldURL);
                }
                j3DVRMLNode = this.externProtoCreator.createInstance((ExternalPrototypeDecl)cRExternPrototypeDecl);
                j3DVRMLNode.setVersion(this.majorVersion, this.minorVersion, this.inStatic);
                cRExternPrototypeDecl.addInstance(this.nodeStack[this.topOfStack], this.currentFieldIndex, (VRMLNodeType)j3DVRMLNode);
            }
            if (prototypeDecl != null) {
                if (this.protoCreator == null) {
                    this.protoCreator = new J3DProtoCreator(this.nodeFactory, this.worldURL, this.majorVersion, this.minorVersion);
                    this.protoCreator.setFrameStateManager(this.stateManager);
                    this.protoCreator.setErrorReporter(this.errorReporter);
                }
                j3DVRMLNode = (J3DVRMLNode)this.protoCreator.newInstance((VRMLNodeTemplate)prototypeDecl, (VRMLExecutionSpace)this.root, this.majorVersion, this.minorVersion, this.inStatic);
            }
        } else {
            j3DVRMLNode = (J3DVRMLNode)this.nodeFactory.createVRMLNode(string, this.inStatic);
        }
        j3DVRMLNode.setErrorReporter(this.errorReporter);
        prototypeDecl = null;
        cRExternPrototypeDecl = null;
        if (j3DVRMLNode != null) {
            object = j3DVRMLNode.getClass();
            n = 0;
            if (this.dontLoadTypes.contains(object)) {
                n = 1;
            } else if (j3DVRMLNode instanceof VRMLProtoInstance && (cRExternPrototypeDecl = (prototypeDecl = (VRMLProtoInstance)j3DVRMLNode).getImplementationNode()) != null && this.dontLoadTypes.contains(cRExternPrototypeDecl.getClass())) {
                n = 1;
            }
            if (n != 0) {
                this.ignoreNodeCounter = 1;
                if (string2 != null) {
                    this.defMap.remove(string2);
                    this.ignoreDefSet.add((Object)string2);
                    if (this.inStatic) {
                        this.staticNodeSet.add((Object)string2);
                    }
                }
                return;
            }
        } else {
            this.ignoreNodeCounter = 1;
            if (string2 != null) {
                this.defMap.remove(string2);
                this.ignoreDefSet.add((Object)string2);
                if (this.inStatic) {
                    this.staticNodeSet.add((Object)string2);
                }
            }
            return;
        }
        if (this.haveCapBitsMaps) {
            j3DVRMLNode.setCapabilityOverrideMap(this.overrideCapBitsMap, this.overrideFreqBitsMap);
            j3DVRMLNode.setCapabilityRequiredMap(this.requiredCapBitsMap, this.requiredFreqBitsMap);
        }
        if (this.topOfStack == 0 && !(j3DVRMLNode instanceof VRMLChildNodeType)) {
            while (cRExternPrototypeDecl instanceof VRMLProtoInstance) {
                cRExternPrototypeDecl = ((VRMLProtoInstance)cRExternPrototypeDecl).getImplementationNode();
            }
            if (cRExternPrototypeDecl != null && !(cRExternPrototypeDecl instanceof VRMLChildNodeType)) {
                this.ignoreNodeCounter = 1;
                throw new VRMLException("The root of a scene graph is required to be a ChildNodeType. This node is not: " + j3DVRMLNode.getVRMLNodeName());
            }
        }
        if (string2 != null) {
            if (this.majorVersion > 2 && this.defMap.containsKey(string2)) {
                throw new VRMLException("DEF name \"" + string2 + "\" already declared in this scope. " + "X3D requires unique DEF names per file");
            }
            j3DVRMLNode.setDEF();
            this.ignoreDefSet.remove((Object)string2);
            this.defMap.put(string2, j3DVRMLNode);
            this.scene.addDEFNode(string2, (VRMLNode)j3DVRMLNode);
            if (this.inStatic) {
                this.staticNodeSet.add((Object)string2);
            }
        }
        j3DVRMLNode.setFrameStateManager(this.stateManager);
        this.nodeStack[this.topOfStack].setValue(this.currentFieldIndex, (VRMLNodeType)j3DVRMLNode);
        ++this.topOfStack;
        this.nodeStack[this.topOfStack] = j3DVRMLNode;
        this.currentNode = j3DVRMLNode;
        object = j3DVRMLNode.getSecondaryType();
        block10: for (n = 0; n < ((Object)object).length; ++n) {
            switch (object[n]) {
                case 16: 
                case 30: 
                case 44: {
                    VRMLExternalNodeType vRMLExternalNodeType = (VRMLExternalNodeType)j3DVRMLNode;
                    vRMLExternalNodeType.setWorldUrl(this.worldURL);
                    continue block10;
                }
                case 28: {
                    VRMLLinkNodeType vRMLLinkNodeType = (VRMLLinkNodeType)j3DVRMLNode;
                    vRMLLinkNodeType.setWorldUrl(this.worldURL);
                }
            }
        }
        this.scene.addNode((VRMLNode)j3DVRMLNode);
        switch (j3DVRMLNode.getPrimaryType()) {
            case 59: {
                if (string2 != null) {
                    this.staticNodeSet.add((Object)string2);
                }
                this.staticDepthCounter = 1;
                this.inStatic = true;
                break;
            }
            case 41: {
                ((VRMLScriptNodeType)j3DVRMLNode).setExecutionSpace((VRMLExecutionSpace)this.root);
                break;
            }
            case 24: {
                ((VRMLInlineNodeType)j3DVRMLNode).setParentSpace((VRMLExecutionSpace)this.root);
            }
        }
    }

    protected void generateProtoCreator() {
        this.protoCreator = new J3DProtoCreator(this.nodeFactory, this.worldURL, this.majorVersion, this.minorVersion);
        this.protoCreator.setFrameStateManager(this.stateManager);
        this.protoCreator.setErrorReporter(this.errorReporter);
    }
}

