/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.browser;

import java.util.BitSet;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Point3d;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SphereGenerator;
import org.j3d.geom.terrain.ColorRampGenerator;
import org.web3d.vrml.renderer.j3d.input.J3DGlobalEffectsHandler;

class GlobalEffectsGroup
extends Group
implements J3DGlobalEffectsHandler {
    private static final int DEFAULT_NUM_SPHERE_FACES = 32;
    private static final int BOX_SIDE_VERTEX_COUNT = 4;
    private static final int[] BOX_STRIP_COUNTS = new int[]{4};
    private static final float BOX_SIZE = 0.7071f;
    private static final float[] SIN_TABLE;
    private static final float[] COS_TABLE;
    private static final int BOX_FORMAT = 35;
    private static final float[] BOX_TEX_COORDS;
    private static final int BACK = 0;
    private static final int FRONT = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int TOP = 4;
    private static final int BOTTOM = 5;
    private static final int SKY_SPHERE = 6;
    private static final int GROUND_SPHERE = 7;
    private static final int NUM_BG_OBJECTS = 8;
    private boolean isStatic;
    private TransformGroup cameraTransform;
    private BoundingSphere lightBounds;
    private ViewPlatform viewPlatform;
    private DirectionalLight headlight;
    private TransformGroup fogTransform;
    private Switch fogSwitch;
    private ExponentialFog exponentialFog;
    private LinearFog linearFog;
    private TransformGroup backgroundTransform;
    private BitSet linearFogSet;
    private BitSet exponentialFogSet;
    private Background background;
    private Appearance[] backgroundAppearances;
    private RenderingAttributes[] backgroundAttributes;
    private int currentNumSkyColors;
    private int currentNumGroundColors;
    private ColorRampGenerator skyColorCreator;
    private ColorRampGenerator gndColorCreator;
    private GeometryData skyData;
    private GeometryData groundData;
    private int maxSkyColors;
    private float skyAngleInc;
    private float[] skyHeights;
    private float[][] skyColors;
    private float[] gndHeights;
    private float gndMaxAngle;
    private IndexedTriangleStripArray skyGeometry;
    private IndexedTriangleStripArray groundGeometry;
    private Shape3D skyShape;
    private Shape3D groundShape;

    GlobalEffectsGroup(boolean bl) {
        this.isStatic = bl;
        this.lightBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setActivationRadius(Float.MAX_VALUE);
        this.headlight = new DirectionalLight();
        this.headlight.setInfluencingBounds((Bounds)this.lightBounds);
        this.headlight.setEnable(false);
        this.cameraTransform = new TransformGroup();
        this.cameraTransform.addChild((Node)this.viewPlatform);
        this.cameraTransform.addChild((Node)this.headlight);
        this.backgroundTransform = new TransformGroup();
        this.constructBackgroundShapes((Group)this.backgroundTransform);
        this.constructBackgroundBox((Group)this.backgroundTransform);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)this.backgroundTransform);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        this.background = new Background();
        this.background.setApplicationBounds((Bounds)boundingSphere);
        this.background.setGeometry(branchGroup);
        this.linearFogSet = new BitSet();
        this.linearFogSet.set(0);
        this.exponentialFogSet = new BitSet();
        this.exponentialFogSet.set(1);
        this.exponentialFog = new ExponentialFog();
        this.exponentialFog.setCapability(15);
        this.exponentialFog.setCapability(17);
        this.exponentialFog.setInfluencingBounds((Bounds)boundingSphere);
        this.linearFog = new LinearFog();
        this.linearFog.setCapability(15);
        this.linearFog.setCapability(17);
        this.linearFog.setInfluencingBounds((Bounds)boundingSphere);
        this.fogSwitch = new Switch();
        this.fogSwitch.setCapability(18);
        this.fogSwitch.setWhichChild(-1);
        this.fogSwitch.addChild((Node)this.linearFog);
        this.fogSwitch.addChild((Node)this.exponentialFog);
        this.fogTransform = new TransformGroup();
        this.fogTransform.addChild((Node)this.fogSwitch);
        this.addChild((Node)this.cameraTransform);
        this.addChild((Node)this.background);
        this.addChild((Node)this.fogTransform);
        if (!bl) {
            this.headlight.setCapability(13);
            this.fogSwitch.setCapability(18);
            this.exponentialFog.setCapability(17);
            this.linearFog.setCapability(17);
            this.cameraTransform.setCapability(18);
            this.backgroundTransform.setCapability(18);
            this.fogTransform.setCapability(18);
            this.background.setCapability(17);
        }
        this.currentNumSkyColors = 0;
        this.currentNumGroundColors = 0;
        this.maxSkyColors = 0;
        this.gndMaxAngle = 0.0f;
        this.skyData = new GeometryData();
        this.skyData.geometryType = 7;
        this.skyData.geometryComponents = 2;
        this.groundData = new GeometryData();
        this.groundData.geometryType = 7;
        this.groundData.geometryComponents = 2;
    }

    public void setViewMatrix(Transform3D transform3D) {
        this.cameraTransform.setTransform(transform3D);
    }

    public void setBackgroundMatrix(Transform3D transform3D) {
        this.backgroundTransform.setTransform(transform3D);
    }

    public void setFogMatrix(Transform3D transform3D) {
        this.fogTransform.setTransform(transform3D);
    }

    public void updateBackgroundTextures(Texture2D[] texture2DArray, boolean[] blArray) {
        for (int i = 0; i < 6; ++i) {
            if (!blArray[i]) continue;
            this.backgroundAppearances[i].setTexture((Texture)texture2DArray[i]);
            this.backgroundAttributes[i].setVisible(texture2DArray[i] != null);
        }
    }

    public void updateBackgroundGround(float[] fArray, float[] fArray2, int n) {
        if (n < 2) {
            this.groundShape.setGeometry(null);
        } else {
            this.updateGroundSphereGeom(fArray, fArray2, n);
            this.groundShape.setGeometry((Geometry)this.groundGeometry);
        }
    }

    public void updateBackgroundSky(float[] fArray, float[] fArray2, int n) {
        if (n == 1) {
            this.skyShape.setGeometry(null);
            this.background.setColor(fArray[0], fArray[1], fArray[2]);
        } else if (n == 0) {
            this.skyShape.setGeometry(null);
            this.background.setColor(0.0f, 0.0f, 0.0f);
        } else {
            this.background.setColor(0.0f, 0.0f, 0.0f);
            this.updateSkySphereGeom(fArray, fArray2, n);
            this.skyShape.setGeometry((Geometry)this.skyGeometry);
        }
    }

    public void enableFog(int n) {
        switch (n) {
            case 0: {
                this.fogSwitch.setWhichChild(-1);
                break;
            }
            case 1: {
                this.fogSwitch.setWhichChild(-3);
                this.fogSwitch.setChildMask(this.linearFogSet);
                break;
            }
            case 2: {
                this.fogSwitch.setWhichChild(-3);
                this.fogSwitch.setChildMask(this.exponentialFogSet);
            }
        }
    }

    public void setFogDetails(float f, float f2, float f3, float f4) {
        this.linearFog.setColor(f2, f3, f4);
        this.exponentialFog.setColor(f2, f3, f4);
        this.linearFog.setBackDistance((double)f);
        this.exponentialFog.setDensity(f);
    }

    ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    void useHeadlight(boolean bl) {
        this.headlight.setEnable(bl);
    }

    void addViewDependentChild(Group group) {
        this.cameraTransform.addChild((Node)group);
    }

    private void constructBackgroundBox(Group group) {
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(5);
        textureAttributes.setPerspectiveCorrectionMode(0);
        this.backgroundAppearances = new Appearance[6];
        this.backgroundAttributes = new RenderingAttributes[6];
        float[] fArray = new float[]{0.7071f, 0.7071f, 0.7071f, 0.7071f, -0.7071f, 0.7071f, -0.7071f, -0.7071f, 0.7071f, -0.7071f, 0.7071f, 0.7071f};
        float[] fArray2 = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f};
        this.backgroundAttributes[0] = new RenderingAttributes();
        this.backgroundAttributes[0].setCapability(6);
        this.backgroundAttributes[0].setVisible(false);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparencyMode(2);
        Appearance appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[0]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[0] = appearance;
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray, fArray2));
        group.addChild((Node)shape3D);
        float[] fArray3 = new float[]{-0.7071f, 0.7071f, -0.7071f, -0.7071f, -0.7071f, -0.7071f, 0.7071f, -0.7071f, -0.7071f, 0.7071f, 0.7071f, -0.7071f};
        float[] fArray4 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        this.backgroundAttributes[1] = new RenderingAttributes();
        this.backgroundAttributes[1].setCapability(6);
        this.backgroundAttributes[1].setVisible(false);
        appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[1]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[1] = appearance;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray3, fArray4));
        group.addChild((Node)shape3D);
        float[] fArray5 = new float[]{-0.7071f, 0.7071f, 0.7071f, -0.7071f, -0.7071f, 0.7071f, -0.7071f, -0.7071f, -0.7071f, -0.7071f, 0.7071f, -0.7071f};
        float[] fArray6 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.backgroundAttributes[2] = new RenderingAttributes();
        this.backgroundAttributes[2].setCapability(6);
        this.backgroundAttributes[2].setVisible(false);
        appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[2]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[2] = appearance;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray5, fArray6));
        group.addChild((Node)shape3D);
        float[] fArray7 = new float[]{0.7071f, 0.7071f, -0.7071f, 0.7071f, -0.7071f, -0.7071f, 0.7071f, -0.7071f, 0.7071f, 0.7071f, 0.7071f, 0.7071f};
        float[] fArray8 = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
        this.backgroundAttributes[3] = new RenderingAttributes();
        this.backgroundAttributes[3].setCapability(6);
        this.backgroundAttributes[3].setVisible(false);
        appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[3]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[3] = appearance;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray7, fArray8));
        group.addChild((Node)shape3D);
        float[] fArray9 = new float[]{-0.7071f, 0.7071f, 0.7071f, -0.7071f, 0.7071f, -0.7071f, 0.7071f, 0.7071f, -0.7071f, 0.7071f, 0.7071f, 0.7071f};
        float[] fArray10 = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
        this.backgroundAttributes[4] = new RenderingAttributes();
        this.backgroundAttributes[4].setCapability(6);
        this.backgroundAttributes[4].setVisible(false);
        appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[4]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[4] = appearance;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray9, fArray10));
        group.addChild((Node)shape3D);
        float[] fArray11 = new float[]{-0.7071f, -0.7071f, -0.7071f, -0.7071f, -0.7071f, 0.7071f, 0.7071f, -0.7071f, 0.7071f, 0.7071f, -0.7071f, -0.7071f};
        float[] fArray12 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.backgroundAttributes[5] = new RenderingAttributes();
        this.backgroundAttributes[5].setCapability(6);
        this.backgroundAttributes[5].setVisible(false);
        appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setRenderingAttributes(this.backgroundAttributes[5]);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.backgroundAppearances[5] = appearance;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray11, fArray12));
        group.addChild((Node)shape3D);
    }

    private GeometryArray createSideGeom(float[] fArray, float[] fArray2) {
        QuadArray quadArray = new QuadArray(4, 35);
        quadArray.setCoordinates(0, fArray);
        quadArray.setNormals(0, fArray2);
        quadArray.setTextureCoordinates(0, 0, BOX_TEX_COORDS);
        return quadArray;
    }

    private void constructBackgroundShapes(Group group) {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(2);
        polygonAttributes.setBackFaceNormalFlip(true);
        polygonAttributes.setPolygonOffset(-1.0f);
        PolygonAttributes polygonAttributes2 = new PolygonAttributes();
        polygonAttributes2.setCullFace(2);
        polygonAttributes2.setBackFaceNormalFlip(true);
        Material material = new Material();
        material.setLightingEnable(false);
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setMaterial(material);
        Appearance appearance2 = new Appearance();
        appearance2.setPolygonAttributes(polygonAttributes2);
        appearance2.setMaterial(material);
        this.skyShape = new Shape3D();
        this.skyShape.setCapability(13);
        this.skyShape.clearCapabilityIsFrequent(13);
        this.skyShape.setAppearance(appearance);
        this.groundShape = new Shape3D();
        this.groundShape.setCapability(13);
        this.groundShape.clearCapabilityIsFrequent(13);
        this.groundShape.setAppearance(appearance2);
        group.addChild((Node)this.groundShape);
        group.addChild((Node)this.skyShape);
    }

    private void updateSkySphereGeom(float[] fArray, float[] fArray2, int n) {
        int n2;
        if (this.skyColorCreator == null) {
            this.skyColorCreator = new ColorRampGenerator();
        }
        boolean bl = (double)fArray2[n - 1] < Math.PI;
        int n3 = n;
        if (bl) {
            ++n3;
        }
        if (this.skyHeights == null || this.skyHeights.length != n3) {
            this.skyHeights = new float[n3];
            this.skyColors = new float[n3][3];
        }
        int n4 = 0;
        this.skyHeights[0] = 1.0f;
        this.skyColors[0][0] = fArray[n4++];
        this.skyColors[0][1] = fArray[n4++];
        this.skyColors[0][2] = fArray[n4++];
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            this.skyHeights[n2] = (float)Math.cos(fArray2[n2 - 1]);
            this.skyColors[n2][0] = fArray[n4++];
            this.skyColors[n2][1] = fArray[n4++];
            this.skyColors[n2][2] = fArray[n4++];
        }
        n2 = n3 - 1;
        this.skyHeights[n2] = -1.0f;
        if (bl) {
            this.skyColors[n2][0] = fArray[n4 - 3];
            this.skyColors[n2][1] = fArray[n4 - 2];
            this.skyColors[n2][2] = fArray[n4 - 1];
        } else {
            this.skyColors[n2][0] = fArray[n4++];
            this.skyColors[n2][1] = fArray[n4++];
            this.skyColors[n2][2] = fArray[n4++];
        }
        this.skyColorCreator.setColorRamp(this.skyHeights, this.skyColors);
        if (n > this.maxSkyColors) {
            this.maxSkyColors = n > 32 ? n : 32;
            this.skyAngleInc = (float)Math.PI / (float)this.maxSkyColors;
            SphereGenerator sphereGenerator = new SphereGenerator(1.0f, this.maxSkyColors);
            sphereGenerator.generate(this.skyData);
            this.skyData.colors = new float[this.skyData.vertexCount * 3];
            int n5 = 7;
            this.skyGeometry = new IndexedTriangleStripArray(this.skyData.vertexCount, n5, this.skyData.indexesCount, this.skyData.stripCounts);
            this.skyGeometry.setCapability(3);
            this.skyGeometry.setCoordinates(0, this.skyData.coordinates);
            this.skyGeometry.setNormals(0, this.skyData.normals);
            this.skyGeometry.setCoordinateIndices(0, this.skyData.indexes);
            this.skyGeometry.setColorIndices(0, this.skyData.indexes);
            this.skyGeometry.setNormalIndices(0, this.skyData.indexes);
        }
        this.skyColorCreator.generate(this.skyData);
        this.skyGeometry.setColors(0, this.skyData.colors);
    }

    private void updateGroundSphereGeom(float[] fArray, float[] fArray2, int n) {
        boolean bl;
        if (this.gndColorCreator == null) {
            this.gndColorCreator = new ColorRampGenerator();
        }
        boolean bl2 = bl = (double)fArray2[n - 1] < Math.PI;
        if (this.gndHeights == null || this.gndHeights.length != n) {
            this.gndHeights = new float[n];
        }
        this.gndHeights[0] = -1.0f;
        for (int i = 1; i < n; ++i) {
            this.gndHeights[i] = -((float)Math.cos(fArray2[i - 1]));
        }
        this.gndColorCreator.setColorRamp(this.gndHeights, fArray, n, false);
        if (fArray2[n - 2] != this.gndMaxAngle) {
            this.generateGroundCoords(fArray2[n - 2], n);
            this.gndMaxAngle = fArray2[n - 2];
        }
        this.gndColorCreator.generate(this.groundData);
        this.groundGeometry.setColors(0, this.groundData.colors);
    }

    private void generateGroundCoords(float f, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n > 32 ? n : 32;
        float f2 = f / (float)n6;
        this.groundData.vertexCount = n5 = 32 * (n6 + 1);
        if (this.groundData.coordinates == null || this.groundData.vertexCount < n5 * 3) {
            this.groundData.coordinates = new float[n5 * 3];
            this.groundData.colors = new float[n5 * 3];
        }
        int n7 = n6 * 2 * 33;
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n6];
        int n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 * 32;
            nArray2[n4] = 66;
            for (n2 = 0; n2 < 32; ++n2) {
                int n9 = n2 + n3;
                nArray[n8++] = n9 + 32;
                nArray[n8++] = n9;
            }
            nArray[n8++] = n3 + 32;
            nArray[n8++] = n3;
        }
        n4 = 7;
        this.groundGeometry = new IndexedTriangleStripArray(this.groundData.vertexCount, n4, n7, nArray2);
        this.groundGeometry.setCapability(3);
        this.groundGeometry.setCoordinateIndices(0, nArray);
        this.groundGeometry.setColorIndices(0, nArray);
        this.groundGeometry.setNormalIndices(0, nArray);
        n3 = 1;
        for (n2 = 0; n2 < 32; ++n2) {
            this.groundData.coordinates[n3] = -1.0f;
            n3 += 3;
        }
        --n3;
        for (n2 = 1; n2 <= n6; ++n2) {
            float f3 = 0.8f * (float)Math.sin(f2 * (float)n2);
            float f4 = -((float)Math.cos(f2 * (float)n2));
            for (int i = 0; i < 32; ++i) {
                this.groundData.coordinates[n3++] = f3 * SIN_TABLE[i];
                this.groundData.coordinates[n3++] = f4;
                this.groundData.coordinates[n3++] = f3 * COS_TABLE[i];
            }
        }
        this.groundGeometry.setCoordinates(0, this.groundData.coordinates);
        this.groundGeometry.setNormals(0, this.groundData.coordinates);
        this.groundShape.setGeometry((Geometry)this.groundGeometry);
    }

    static {
        BOX_TEX_COORDS = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        COS_TABLE = new float[32];
        SIN_TABLE = new float[32];
        double d = 0.19634954084936207;
        for (int i = 0; i < 32; ++i) {
            GlobalEffectsGroup.COS_TABLE[i] = (float)Math.cos(d * (double)i + 1.5707963267948966);
            GlobalEffectsGroup.SIN_TABLE[i] = (float)Math.sin(d * (double)i + 1.5707963267948966);
        }
    }
}

