/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.browser;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;

public class PerFrameBehavior
extends Behavior {
    private static final int START_TICK_ID = 101;
    private static final int TIME_FUDGE_FACTOR = 1;
    private WakeupOnElapsedTime tickCritter;
    private WakeupOnBehaviorPost sleepCritter;
    private WakeupOnElapsedFrames frameCritter;
    private EventModelEvaluator eventModel;
    private ErrorReporter errorReporter;
    private boolean enabled;
    private long currentWallTime;
    private long lastWallTime;
    private BrowserCore browser;
    private EventModelStatusListener eventModelStatusListener;
    private long timingTotal;
    private int timingCount;
    private long timingLast;

    public PerFrameBehavior(EventModelEvaluator eventModelEvaluator, BrowserCore browserCore) {
        if (eventModelEvaluator == null) {
            throw new NullPointerException("Evaluator was null");
        }
        this.eventModel = eventModelEvaluator;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.browser = browserCore;
        this.tickCritter = new WakeupOnElapsedTime(25L);
        this.frameCritter = new WakeupOnElapsedFrames(0);
        this.sleepCritter = new WakeupOnBehaviorPost((Behavior)this, 101);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.POSITIVE_INFINITY);
        this.setSchedulingBounds((Bounds)boundingSphere);
        this.enabled = false;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.eventModelStatusListener = eventModelStatusListener;
    }

    public void initialize() {
        this.lastWallTime = System.currentTimeMillis();
        this.currentWallTime = System.currentTimeMillis();
        if (this.enabled) {
            this.wakeupOn((WakeupCondition)this.tickCritter);
        } else {
            this.wakeupOn((WakeupCondition)this.sleepCritter);
        }
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.eventModelStatusListener != null) {
            this.eventModelStatusListener.preEventEvaluation();
        }
        this.currentWallTime = System.currentTimeMillis();
        this.timingTotal += this.currentWallTime - this.timingLast;
        this.timingLast = this.currentWallTime;
        ++this.timingCount;
        if (this.timingCount % 10 == 0) {
            this.browser.setLastRenderTime(this.timingTotal / 10L);
            this.timingTotal = 0L;
            this.timingCount = 0;
        }
        if (this.currentWallTime - this.lastWallTime <= 0L) {
            ++this.currentWallTime;
        }
        Object object = null;
        this.eventModel.evaluate(this.currentWallTime);
        object = this.enabled ? this.frameCritter : this.sleepCritter;
        if (this.eventModelStatusListener != null) {
            this.eventModelStatusListener.postEventEvaluation();
        }
        this.wakeupOn((WakeupCondition)object);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setEnable(boolean bl) {
        super.setEnable(bl);
        if (bl && !this.enabled) {
            this.enabled = bl;
            this.postId(101);
        }
    }
}

