/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.browser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.j3d.renderer.java3d.navigation.ViewpointTransition;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.runtime.BindableNodeListener;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.renderer.j3d.J3DNodeFactory;
import org.web3d.vrml.renderer.j3d.browser.GlobalEffectsGroup;
import org.web3d.vrml.renderer.j3d.browser.PerFrameBehavior;
import org.web3d.vrml.renderer.j3d.input.J3DSensorManager;
import org.web3d.vrml.renderer.j3d.input.J3DUserInputHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DBackgroundNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DFogNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DViewpointNodeType;

public class VRMLBranchGroup
extends BranchGroup
implements BrowserCore,
BindableNodeListener,
EventModelInitListener {
    private static final float INFINITE_VIS_LIMIT = 10000.0f;
    private static final int VP_TRANSITION_TIME = 2000;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private ScriptLoader scriptLoader;
    private ExternalLoadManager loadManager;
    private RouteManager routeManager;
    private View commonView;
    private J3DViewpointNodeType currentViewpoint;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private PhysicalBody avatarBody;
    private PhysicalEnvironment avatarEnvironment;
    private BranchGroup commonSceneGraph;
    private BranchGroup contentSceneGraph;
    private BindableNodeManager viewpointStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;
    private ArrayList viewList;
    private J3DUserInputHandler userInput;
    private J3DSensorManager sensorManager;
    private ViewpointTransition vpTransition;
    private boolean inSetup;
    private ArrayList coreListeners;
    private GlobalEffectsGroup globalEffects;
    private boolean isStatic;
    private EventModelEvaluator eventModel;
    private PerFrameBehavior frameTicker;
    private long lastRenderTime;

    public VRMLBranchGroup(boolean bl, EventModelEvaluator eventModelEvaluator) {
        SensorManager sensorManager;
        this.isStatic = bl;
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener((EventModelInitListener)this);
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        this.globalEffects = new GlobalEffectsGroup(bl);
        if (!this.isStatic) {
            this.viewList = new ArrayList();
            this.vpTransition = new ViewpointTransition();
            this.frameTicker = new PerFrameBehavior(this.eventModel, this);
        }
        if (!((sensorManager = this.eventModel.getSensorManager()) instanceof J3DSensorManager)) {
            throw new IllegalArgumentException("Not a Java3D sensor manager");
        }
        this.sensorManager = (J3DSensorManager)sensorManager;
        this.sensorManager.setGlobalEffectsHandler(this.globalEffects);
        this.userInput = (J3DUserInputHandler)this.sensorManager.getUserInputHandler();
        J3DNodeFactory j3DNodeFactory = J3DNodeFactory.getJ3DNodeFactory();
        try {
            j3DNodeFactory.setSpecVersion(3, 1);
            j3DNodeFactory.setProfile("Interactive");
            j3DNodeFactory.addComponent("EnvironmentalEffects", 2);
        }
        catch (UnsupportedProfileException unsupportedProfileException) {
            // empty catch block
        }
        J3DViewpointNodeType j3DViewpointNodeType = (J3DViewpointNodeType)j3DNodeFactory.createVRMLNode("Viewpoint", false);
        j3DViewpointNodeType.setDescription("Default viewpoint");
        j3DViewpointNodeType.setupFinished();
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)j3DNodeFactory.createVRMLNode("NavigationInfo", false);
        vRMLNavigationInfoNodeType.setupFinished();
        J3DBackgroundNodeType j3DBackgroundNodeType = (J3DBackgroundNodeType)j3DNodeFactory.createVRMLNode("Background", false);
        j3DBackgroundNodeType.setupFinished();
        J3DFogNodeType j3DFogNodeType = (J3DFogNodeType)j3DNodeFactory.createVRMLNode("Fog", false);
        j3DFogNodeType.setFogType(0);
        j3DFogNodeType.setupFinished();
        this.eventModel.setDefaultBindables((VRMLViewpointNodeType)j3DViewpointNodeType, vRMLNavigationInfoNodeType, (VRMLBackgroundNodeType)j3DBackgroundNodeType, (VRMLFogNodeType)j3DFogNodeType);
        this.viewpointStack = this.eventModel.getBindableManager(55);
        this.navInfoStack = this.eventModel.getBindableManager(31);
        Node node = (Node)j3DViewpointNodeType.getSceneGraphObject();
        Node node2 = (Node)j3DBackgroundNodeType.getSceneGraphObject();
        Node node3 = (Node)j3DFogNodeType.getSceneGraphObject();
        this.contentSceneGraph = new BranchGroup();
        this.contentSceneGraph.setCapability(13);
        this.contentSceneGraph.setCapability(14);
        this.commonSceneGraph = new BranchGroup();
        this.commonSceneGraph.addChild(node);
        this.commonSceneGraph.addChild(node2);
        this.commonSceneGraph.addChild(node3);
        this.commonSceneGraph.addChild((Node)this.globalEffects);
        if (!this.isStatic) {
            this.commonSceneGraph.addChild((Node)this.frameTicker);
        }
        this.addChild((Node)this.commonSceneGraph);
        this.addChild((Node)this.contentSceneGraph);
        this.viewpointStack.setNodeChangeListener((BindableNodeListener)this);
        this.navInfoStack.setNodeChangeListener((BindableNodeListener)this);
        this.inSetup = false;
    }

    public void worldInitComplete() {
        VRMLClock vRMLClock = this.eventModel.getVRMLClock();
        double d = vRMLClock.getTime();
        this.fireInitEvent();
        this.currentNavInfo.setBind(true, true, d);
        this.currentViewpoint.setBind(true, true, d);
        this.inSetup = false;
    }

    public void changeWorld() {
        if (this.isStatic) {
            return;
        }
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = this.nextScene;
        if (this.currentScene == null) {
            return;
        }
        this.defMap = this.currentScene.getDEFNodes();
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentScene.getRootNode();
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        this.currentSpace = (VRMLExecutionSpace)j3DVRMLNode;
        this.userInput.setPickableScene(branchGroup);
        this.sensorManager.setWorldRoot(branchGroup);
        this.contentSceneGraph.addChild((Node)branchGroup);
        this.setupView();
        VRMLClock vRMLClock = this.eventModel.getVRMLClock();
        vRMLClock.resetTimeZero();
        this.frameTicker.setEnable(true);
    }

    public void newNodeBound(VRMLBindableNodeType vRMLBindableNodeType) {
        int n = vRMLBindableNodeType.getPrimaryType();
        if (vRMLBindableNodeType instanceof J3DViewpointNodeType) {
            this.changeViewpoints((J3DViewpointNodeType)vRMLBindableNodeType);
        } else if (vRMLBindableNodeType instanceof VRMLNavigationInfoNodeType) {
            this.changeNavInfo((VRMLNavigationInfoNodeType)vRMLBindableNodeType);
        }
    }

    public void bindableAdded(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
    }

    public void bindableRemoved(VRMLBindableNodeType vRMLBindableNodeType) {
    }

    public int getRendererType() {
        return 1;
    }

    public String getIDString() {
        return "java3d";
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        float f = (float)this.lastRenderTime / 1000.0f;
        return 1.0f / f;
    }

    public void setLastRenderTime(long l) {
        this.lastRenderTime = l;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.frameTicker.setEventModelStatusListener(eventModelStatusListener);
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.addNavigationStateListener(navigationStateListener);
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.removeNavigationStateListener(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.addSensorStatusListener(sensorStatusListener);
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.removeSensorStatusListener(sensorStatusListener);
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        string = this.currentScene != null ? this.currentScene.getWorldRootURL() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.inSetup = true;
        if (!this.isStatic) {
            this.nextScene = vRMLScene;
            this.eventModel.setScene(vRMLScene, string);
            if (this.frameTicker != null) {
                this.frameTicker.setEnable(true);
            }
            return;
        }
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = vRMLScene;
        this.defMap = this.currentScene.getDEFNodes();
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentScene.getRootNode();
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        this.currentSpace = (VRMLExecutionSpace)j3DVRMLNode;
        this.eventModel.setScene(vRMLScene, string);
        this.contentSceneGraph.addChild((Node)branchGroup);
        this.setupView();
        this.currentSpace = (VRMLExecutionSpace)j3DVRMLNode;
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public J3DViewpointNodeType getViewpoint() {
        return this.currentViewpoint;
    }

    public Behavior[] getSystemBehaviors() {
        Behavior[] behaviorArray = this.isStatic ? new Behavior[]{} : new Behavior[]{this.frameTicker};
        return behaviorArray;
    }

    public void setPrimaryView(View view) {
        if (view == null) {
            if (this.commonView != null) {
                this.commonView.attachViewPlatform(null);
                this.viewList.remove(this.commonView);
                this.commonView = null;
            }
            return;
        }
        if (this.commonView != view) {
            view.attachViewPlatform(this.globalEffects.getViewPlatform());
        }
        this.commonView = view;
        if (!this.viewList.contains(view)) {
            this.viewList.add(view);
        }
        this.setupView();
    }

    public void addView(View view) {
        if (view == null || this.viewList.contains(view)) {
            return;
        }
        this.viewList.add(view);
        if (this.currentScene != null) {
            view.setPhysicalBody(this.avatarBody);
            view.setPhysicalEnvironment(this.avatarEnvironment);
            view.setFrontClipPolicy(2);
            view.setBackClipPolicy(2);
            view.attachViewPlatform(this.globalEffects.getViewPlatform());
        }
    }

    public void removeView(View view) {
        if (view == null || !this.viewList.contains(view)) {
            return;
        }
        this.viewList.remove(view);
    }

    public void setNavigationMode(String string) {
        this.userInput.setNavigationMode(string);
    }

    public void fitToWorld(boolean bl) {
        System.out.println("Fit to world not implemented");
    }

    private void setupView() {
        this.avatarBody = new PhysicalBody();
        this.avatarEnvironment = new PhysicalEnvironment();
        if (this.commonView != null) {
            this.commonView.setPhysicalBody(this.avatarBody);
            this.commonView.setPhysicalEnvironment(this.avatarEnvironment);
            this.commonView.setFrontClipPolicy(2);
            this.commonView.setBackClipPolicy(2);
        }
    }

    private void clearCurrentWorld() {
        this.frameTicker.setEnable(false);
        this.currentSpace = null;
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentScene.getRootNode();
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        branchGroup.detach();
        this.eventModel.clear();
        this.clearInlines((BasicScene)this.currentScene);
        this.userInput.setPickableScene(null);
        this.userInput.setViewInfo(null, null, null);
    }

    private void changeViewpoints(J3DViewpointNodeType j3DViewpointNodeType) {
        if (j3DViewpointNodeType.getJump() || this.inSetup) {
            this.currentViewpoint = j3DViewpointNodeType;
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            Transform3D transform3D = this.currentViewpoint.getViewTransform();
            transformGroup.setTransform(transform3D);
            if (this.commonView != null) {
                this.commonView.setFieldOfView((double)this.currentViewpoint.getFieldOfView());
                SceneGraphPath sceneGraphPath = this.currentViewpoint.getSceneGraphPath();
                if (this.checkForLinks(sceneGraphPath)) {
                    this.userInput.setViewInfo(this.commonView, transformGroup, sceneGraphPath);
                } else {
                    this.userInput.setViewInfo(this.commonView, transformGroup, null);
                }
            }
        } else {
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            TransformGroup transformGroup2 = j3DViewpointNodeType.getPlatformGroup();
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D2 = new Transform3D();
            Transform3D transform3D3 = j3DViewpointNodeType.getViewTransform();
            SceneGraphPath sceneGraphPath = this.currentViewpoint.getSceneGraphPath();
            SceneGraphPath sceneGraphPath2 = j3DViewpointNodeType.getSceneGraphPath();
            boolean bl = this.checkForLinks(sceneGraphPath);
            boolean bl2 = this.checkForLinks(sceneGraphPath2);
            if (bl) {
                transformGroup.getLocalToVworld(sceneGraphPath, transform3D);
            } else {
                transformGroup.getLocalToVworld(transform3D);
            }
            if (bl2) {
                transformGroup2.getLocalToVworld(sceneGraphPath2, transform3D2);
            } else {
                transformGroup2.getLocalToVworld(transform3D2);
            }
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            Quat4d quat4d = new Quat4d();
            Quat4d quat4d2 = new Quat4d();
            Quat4d quat4d3 = new Quat4d();
            transform3D2.get(quat4d2, vector3d2);
            transform3D.get(quat4d, vector3d);
            vector3d3.sub((Tuple3d)vector3d2, (Tuple3d)vector3d);
            quat4d3.sub((Tuple4d)quat4d2, (Tuple4d)quat4d);
            Transform3D transform3D4 = new Transform3D();
            transform3D4.set(quat4d3, vector3d3, 1.0);
            transform3D4.set(vector3d3);
            transformGroup2.setTransform(transform3D4);
            if (this.commonView != null) {
                this.commonView.setFieldOfView((double)j3DViewpointNodeType.getFieldOfView());
            }
            this.currentViewpoint = j3DViewpointNodeType;
            if (this.commonView != null) {
                this.vpTransition.transitionTo(this.commonView, transformGroup2, transform3D3, 2000);
                this.userInput.setViewInfo(this.commonView, transformGroup2, sceneGraphPath2);
                if (bl2) {
                    this.userInput.setViewInfo(this.commonView, transformGroup2, sceneGraphPath2);
                } else {
                    this.userInput.setViewInfo(this.commonView, transformGroup2, null);
                }
            }
        }
        this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
    }

    private void changeNavInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        float f = this.currentNavInfo.getVisibilityLimit();
        if (f <= 0.0f) {
            f = 10000.0f;
        }
        if (this.commonView != null) {
            this.commonView.setBackClipDistance((double)f);
            float[] fArray = this.currentNavInfo.getAvatarSize();
            float f2 = fArray[0] / 2.0f;
            if (f2 < 0.001f) {
                f2 = 0.001f;
            }
            this.commonView.setFrontClipDistance((double)f2);
        }
        this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        this.userInput.setNavigationInfo(this.currentNavInfo);
    }

    private void clearInlines(BasicScene basicScene) {
        J3DVRMLNode j3DVRMLNode;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(24);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (J3DVRMLNode)arrayList.get(n);
            SceneGraphObject sceneGraphObject = j3DVRMLNode.getSceneGraphObject();
            if (sceneGraphObject instanceof BranchGroup) {
                ((BranchGroup)sceneGraphObject).detach();
            } else {
                System.out.println("Inline root node is not a BG! " + sceneGraphObject.getClass());
            }
            VRMLScene vRMLScene = (VRMLScene)((VRMLInlineNodeType)j3DVRMLNode).getContainedScene();
            if (vRMLScene == null) continue;
            J3DVRMLNode j3DVRMLNode2 = (J3DVRMLNode)vRMLScene.getRootNode();
            BranchGroup branchGroup = (BranchGroup)j3DVRMLNode2.getSceneGraphObject();
            branchGroup.detach();
            this.clearInlines((BasicScene)vRMLScene);
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (VRMLProtoInstance)arrayList.get(n);
            this.clearInlines(j3DVRMLNode.getContainedScene());
        }
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private boolean checkForLinks(SceneGraphPath sceneGraphPath) {
        boolean bl = false;
        if (sceneGraphPath == null) {
            return false;
        }
        int n = sceneGraphPath.nodeCount();
        for (int i = 0; i < n && !bl; ++i) {
            if (!(sceneGraphPath.getNode(i) instanceof Link)) continue;
            bl = true;
        }
        return bl;
    }
}

