/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.View;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.InvalidConfigurationException;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.loader.DefaultWorldLoaderManager;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedViewpointManager;
import org.web3d.vrml.nodes.runtime.InputDeviceManager;
import org.web3d.vrml.nodes.runtime.NetworkManager;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.RouterFactory;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.j3d.J3DSceneBuilderFactory;
import org.web3d.vrml.renderer.j3d.browser.OverlayHandler;
import org.web3d.vrml.renderer.j3d.browser.VRMLDependentCanvas;
import org.web3d.vrml.renderer.j3d.browser.VRMLUniverse;
import org.web3d.vrml.renderer.j3d.input.J3DPickingManager;
import org.web3d.vrml.renderer.j3d.input.J3DSensorManager;
import org.web3d.vrml.renderer.j3d.nodes.J3DViewpointNodeType;
import org.web3d.vrml.sav.InputSource;

public class VRMLBrowserCanvas
extends Canvas3D
implements SensorStatusListener,
BrowserCoreListener,
OverlayHandler {
    public static final String SCRIPT_LOADER_PROP = "org.web3d.xj3d.script.loader.class";
    public static final String SCRIPT_MANAGER_PROP = "org.web3d.xj3d.script.manager.class";
    public static final String FILE_LOADER_PROP = "org.web3d.xj3d.file.loader.class";
    public static final String ROUTER_FACTORY_PROP = "org.web3d.xj3d.router.factory.class";
    public static final String ROUTER_MANAGER_PROP = "org.web3d.xj3d.router.manager.class";
    public static final String STATE_MANAGER_PROP = "org.web3d.xj3d.state.manager.class";
    public static final String SENSOR_MANAGER_PROP = "org.web3d.xj3d.sensor.manager.class";
    public static final String NETWORK_MANAGER_PROP = "org.web3d.xj3d.network.manager.class";
    public static final String PICKING_MANAGER_PROP = "org.web3d.xj3d.sensor.manager.class";
    public static final String EVENT_MODEL_PROP = "org.web3d.xj3d.eventmodel.evaluator.class";
    private static final String DEFAULT_SCRIPT_LOADER = "org.web3d.vrml.nodes.loader.DefaultScriptLoader";
    private static final String DEFAULT_SCRIPT_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultScriptManager";
    private static final String DEFAULT_EXTERNAL = "org.web3d.vrml.nodes.loader.MemCacheLoadManager";
    private static final String DEFAULT_ROUTER_FACTORY = "org.web3d.vrml.nodes.runtime.ListsRouterFactory";
    private static final String DEFAULT_ROUTER_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultRouteManager";
    private static final String DEFAULT_STATE_MANAGER = "org.web3d.vrml.nodes.runtime.GeneralisedFrameStateManager";
    private static final String DEFAULT_SENSOR_MANAGER = "org.web3d.vrml.renderer.j3d.input.DefaultSensorManager";
    private static final String DEFAULT_NETWORK_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultNetworkManager";
    private static final String DEFAULT_PICKING_MANAGER = "org.web3d.vrml.renderer.j3d.input.DefaultPickingManager";
    private static final String DEFAULT_EVENT_MODEL = "org.web3d.vrml.nodes.runtime.GeneralisedEventModelEvaluator";
    private static final String NOT_VP_MSG = "Referenced item is not a viewpoint";
    private static final String NO_SCRIPT_LOAD_MSG = "The class that you specificed for the script loader is not a  valid instance of ScriptLoader";
    private static final String NO_SCRIPT_MGR_MSG = "The class that you specificed for the script manager is not a valid instance of ScriptManager";
    private static final String NO_LOADER_LOAD_MSG = "The class that you specificed for the load manager is not a valid instance of ExternalLoadManager";
    private static final String NO_ROUTER_LOAD_MSG = "The class that you specificed for the router factory is not a valid instance of RouterFactory";
    private static final String NO_ROUTER_MGR_MSG = "The class that you specificed for the router manager is not a valid instance of RouteManager";
    private static final String NO_STATE_MGR_MSG = "The class that you specificed for the frame state manager is not a valid instance of FrameStateManager";
    private static final String NO_SENSOR_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of J3DSensorManager";
    private static final String NO_NETWORK_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of NetworkManager";
    private static final String NO_PICKING_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of J3DPickingManager";
    private static final String NO_EVENT_MODEL_MSG = "The class that you specificed for the event model is not a valid instance of EventModelEvaluator";
    private static final String SEND_LINK_MSG = "There was an error sending the link changed notification";
    private static final String LOAD_URL_FAIL_MSG = "The URLs failed to load: ";
    private VRMLViewpointNodeType currentViewpoint;
    private VRMLUniverse universe;
    private View localView;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ExternalLoadManager loadManager;
    private RouteManager routeManager;
    private J3DSensorManager sensorManager;
    private NetworkManager networkManager;
    private EventModelEvaluator eventModel;
    private WorldLoaderManager worldLoader;
    private ViewpointManager viewpointManager;
    private HashSet childCanvases;
    private HashMap viewpointDefMap;
    private ErrorReporter errorReporter;
    private boolean vrml97Only;
    private boolean disableInternalLink;

    public VRMLBrowserCanvas(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        this(graphicsConfiguration, bl, null, false);
    }

    public VRMLBrowserCanvas(GraphicsConfiguration graphicsConfiguration, boolean bl, View view) {
        this(graphicsConfiguration, bl, view, false);
    }

    public VRMLBrowserCanvas(GraphicsConfiguration graphicsConfiguration, boolean bl, boolean bl2) {
        this(graphicsConfiguration, bl, null, bl2);
    }

    public VRMLBrowserCanvas(GraphicsConfiguration graphicsConfiguration, boolean bl, View view, boolean bl2) {
        super(graphicsConfiguration);
        this.vrml97Only = bl;
        this.disableInternalLink = bl2;
        this.localView = view == null ? new View() : view;
        this.localView.addCanvas3D((Canvas3D)this);
        this.setBackground(Color.black);
        this.childCanvases = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public Canvas3D getPrimaryCanvas() {
        return this;
    }

    public void deviceOver(int n, String string) {
    }

    public void deviceNotOver(int n) {
    }

    public void deviceActivated(int n) {
    }

    public void linkActivated(String[] stringArray) {
        if (!this.disableInternalLink) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].charAt(0) == '#') {
                    String string = stringArray[i].substring(1);
                    VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.viewpointDefMap.get(string);
                    if (vRMLViewpointNodeType != null) {
                        VRMLClock vRMLClock = this.universe.getVRMLClock();
                        double d = vRMLClock.getTime();
                        if (this.currentViewpoint != null) {
                            this.currentViewpoint.setBind(false, true, d);
                        }
                        vRMLViewpointNodeType.setBind(true, true, d);
                        this.currentViewpoint = vRMLViewpointNodeType;
                        continue;
                    }
                    this.errorReporter.warningReport(NOT_VP_MSG, null);
                    continue;
                }
                System.out.println("Warning only loading the first URL");
                this.loadWorld(stringArray[0]);
            }
        }
    }

    public void browserShutdown() {
        this.viewpointDefMap.clear();
    }

    public void browserDisposed() {
    }

    public void urlLoadFailed(String string) {
        this.errorReporter.errorReport(LOAD_URL_FAIL_MSG + string, null);
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        J3DViewpointNodeType j3DViewpointNodeType = this.universe.getViewpoint();
        this.currentViewpoint = j3DViewpointNodeType;
        Map map = vRMLScene.getDEFNodes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (!(v instanceof VRMLViewpointNodeType)) continue;
            this.viewpointDefMap.put(string, v);
        }
    }

    public void initialize() {
        Canvas3D canvas3D;
        Object object;
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{System.getProperty(VRMLBrowserCanvas.SCRIPT_LOADER_PROP, VRMLBrowserCanvas.DEFAULT_SCRIPT_LOADER), System.getProperty(VRMLBrowserCanvas.SCRIPT_MANAGER_PROP, VRMLBrowserCanvas.DEFAULT_SCRIPT_MANAGER), System.getProperty(VRMLBrowserCanvas.FILE_LOADER_PROP, VRMLBrowserCanvas.DEFAULT_EXTERNAL), System.getProperty(VRMLBrowserCanvas.ROUTER_FACTORY_PROP, VRMLBrowserCanvas.DEFAULT_ROUTER_FACTORY), System.getProperty(VRMLBrowserCanvas.ROUTER_MANAGER_PROP, VRMLBrowserCanvas.DEFAULT_ROUTER_MANAGER), System.getProperty(VRMLBrowserCanvas.STATE_MANAGER_PROP, VRMLBrowserCanvas.DEFAULT_STATE_MANAGER), System.getProperty("org.web3d.xj3d.sensor.manager.class", VRMLBrowserCanvas.DEFAULT_SENSOR_MANAGER), System.getProperty("org.web3d.xj3d.sensor.manager.class", VRMLBrowserCanvas.DEFAULT_PICKING_MANAGER), System.getProperty(VRMLBrowserCanvas.EVENT_MODEL_PROP, VRMLBrowserCanvas.DEFAULT_EVENT_MODEL), System.getProperty(VRMLBrowserCanvas.NETWORK_MANAGER_PROP, VRMLBrowserCanvas.DEFAULT_NETWORK_MANAGER)};
                return stringArray;
            }
        });
        ScriptLoader scriptLoader = null;
        RouterFactory routerFactory = null;
        J3DPickingManager j3DPickingManager = null;
        int n = 0;
        scriptLoader = (ScriptLoader)this.loadClass(stringArray[0], true, NO_SCRIPT_LOAD_MSG);
        this.scriptManager = (ScriptManager)this.loadClass(stringArray[1], true, NO_SCRIPT_MGR_MSG);
        this.loadManager = (ExternalLoadManager)this.loadClass(stringArray[2], true, NO_LOADER_LOAD_MSG);
        routerFactory = (RouterFactory)this.loadClass(stringArray[3], true, NO_ROUTER_LOAD_MSG);
        this.routeManager = (RouteManager)this.loadClass(stringArray[4], true, NO_ROUTER_MGR_MSG);
        this.stateManager = (FrameStateManager)this.loadClass(stringArray[5], true, NO_STATE_MGR_MSG);
        this.sensorManager = (J3DSensorManager)this.loadClass(stringArray[6], true, NO_SENSOR_MGR_MSG);
        j3DPickingManager = (J3DPickingManager)this.loadClass(stringArray[7], false, NO_PICKING_MGR_MSG);
        this.eventModel = (EventModelEvaluator)this.loadClass(stringArray[8], true, NO_EVENT_MODEL_MSG);
        this.networkManager = (NetworkManager)this.loadClass(stringArray[9], false, NO_NETWORK_MGR_MSG);
        if (this.networkManager != null) {
            ++n;
        }
        InputDeviceManager inputDeviceManager = new InputDeviceManager("java3d", (Component)((Object)this), (Object)this);
        if (this.sensorManager != null) {
            this.sensorManager.setInputManager(inputDeviceManager);
            this.sensorManager.setPickingManager(j3DPickingManager);
        }
        if (this.networkManager != null) {
            try {
                object = new DISProtocolHandler();
                this.networkManager.addProtocolHandler((NetworkProtocolHandler)object);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.errorReporter.warningReport("DISProtocol handler not found", null);
            }
        }
        object = new NodeManager[n];
        n = 0;
        if (this.networkManager != null) {
            object[n++] = this.networkManager;
        }
        if (this.scriptManager == null || this.routeManager == null || this.sensorManager == null || this.stateManager == null || this.loadManager == null) {
            throw new InvalidConfigurationException("Missing required Manager");
        }
        this.routeManager.setRouterFactory(routerFactory);
        this.scriptManager.setScriptLoader(scriptLoader);
        this.viewpointManager = new GeneralisedViewpointManager();
        this.eventModel.initialize(this.scriptManager, this.routeManager, (SensorManager)this.sensorManager, this.stateManager, this.loadManager, this.viewpointManager, object);
        this.universe = new VRMLUniverse(this.eventModel, true, this);
        this.universe.setPrimaryView(this.localView);
        this.universe.addSensorStatusListener(this);
        this.universe.addCoreListener(this);
        Object[] objectArray = this.childCanvases.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            canvas3D = (Canvas3D)objectArray[i];
            this.universe.addView(canvas3D.getView());
        }
        this.viewpointDefMap = new HashMap();
        J3DSceneBuilderFactory j3DSceneBuilderFactory = new J3DSceneBuilderFactory(this.vrml97Only, true, true, true, true, true, true);
        canvas3D = null;
        try {
            canvas3D = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        if (this.vrml97Only) {
            canvas3D.setProperty("Required-Version", (Object)"2.0");
            canvas3D.setProperty("Required-Format", (Object)"VRML");
        }
        this.worldLoader = new DefaultWorldLoaderManager(this.stateManager);
        this.worldLoader.setErrorReporter(this.errorReporter);
        this.worldLoader.registerBuilderFactory(1, (SceneBuilderFactory)j3DSceneBuilderFactory);
        this.worldLoader.registerParserFactory(1, (VRMLParserFactory)canvas3D);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.startRenderer();
        } else {
            this.stopRenderer();
        }
    }

    public void setMinimumFrameInterval(int n) {
        this.localView.setMinimumFrameCycleTime((long)n);
    }

    public void loadWorld(String string) {
        Object object;
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = null;
        try {
            object = new InputSource(string);
            vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, (InputSource)object);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Failed to load ", exception);
            this.worldLoader.releaseLoader(worldLoader);
            return;
        }
        this.worldLoader.releaseLoader(worldLoader);
        object = null;
        int n = string.indexOf("#");
        if (n > -1) {
            object = string.substring(n + 1);
        }
        this.universe.setScene(vRMLScene, (String)object);
        J3DViewpointNodeType j3DViewpointNodeType = this.universe.getViewpoint();
        this.currentViewpoint = j3DViewpointNodeType;
        this.viewpointDefMap.clear();
        Map map = vRMLScene.getDEFNodes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            if (!(v instanceof VRMLViewpointNodeType)) continue;
            this.viewpointDefMap.put(string2, v);
        }
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public ViewpointManager getViewpointManager() {
        return this.viewpointManager;
    }

    public ExternalLoadManager getExternalLoadManager() {
        return this.loadManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public WorldLoaderManager getWorldLoaderManager() {
        return this.worldLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public EventModelEvaluator getEventModelEvaluator() {
        return this.eventModel;
    }

    public VRMLUniverse getUniverse() {
        return this.universe;
    }

    public void registerDependentCanvas(VRMLDependentCanvas vRMLDependentCanvas) {
        if (this.childCanvases.contains((Object)vRMLDependentCanvas)) {
            return;
        }
        this.childCanvases.add((Object)vRMLDependentCanvas);
        if (this.universe != null) {
            this.universe.addView(vRMLDependentCanvas.getView());
        }
    }

    public void unregisterDependentCanvas(VRMLDependentCanvas vRMLDependentCanvas) {
        if (!this.childCanvases.contains((Object)vRMLDependentCanvas)) {
            return;
        }
        this.childCanvases.remove((Object)vRMLDependentCanvas);
        if (this.universe != null) {
            this.universe.removeView(vRMLDependentCanvas.getView());
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        Object object = this.errorReporter = errorReporter == null ? new DefaultErrorReporter() : errorReporter;
        if (this.worldLoader == null) {
            return;
        }
        this.scriptManager.setErrorReporter(this.errorReporter);
        this.stateManager.setErrorReporter(this.errorReporter);
        this.loadManager.setErrorReporter(this.errorReporter);
        this.routeManager.setErrorReporter(this.errorReporter);
        this.sensorManager.setErrorReporter(this.errorReporter);
        this.networkManager.setErrorReporter(this.errorReporter);
        this.eventModel.setErrorReporter(this.errorReporter);
        this.worldLoader.setErrorReporter(this.errorReporter);
    }

    private Object loadClass(final String string, final boolean bl, final String string2) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string);
                    return clazz.newInstance();
                }
                catch (Error error) {
                    if (bl) {
                        Exception exception = new Exception(error.getMessage(), error);
                        VRMLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    } else {
                        VRMLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                    }
                }
                catch (Exception exception) {
                    if (bl) {
                        VRMLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    }
                    VRMLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                }
                return null;
            }
        });
        return t;
    }
}

