/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.browser;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.j3d.renderer.java3d.navigation.ViewpointTransition;
import org.j3d.renderer.java3d.overlay.OverlayManager;
import org.j3d.renderer.java3d.overlay.UpdateControlBehavior;
import org.j3d.renderer.java3d.overlay.UpdateManager;
import org.j3d.terrain.TerrainData;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeListener;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.common.browser.OverlayWrapper;
import org.web3d.vrml.renderer.j3d.browser.GlobalEffectsGroup;
import org.web3d.vrml.renderer.j3d.browser.OverlayHandler;
import org.web3d.vrml.renderer.j3d.browser.PerFrameBehavior;
import org.web3d.vrml.renderer.j3d.browser.RendererEffectsGroup;
import org.web3d.vrml.renderer.j3d.input.J3DSensorManager;
import org.web3d.vrml.renderer.j3d.input.J3DTerrainManager;
import org.web3d.vrml.renderer.j3d.input.J3DUserInputHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DBackgroundNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DFogNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DOverlayStructureNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DViewpointNodeType;

public class VRMLUniverse
extends VirtualUniverse
implements BrowserCore,
BindableNodeListener,
EventModelInitListener,
J3DParentPathRequestHandler {
    private static final float INFINITE_VIS_LIMIT = 10000.0f;
    private static final int VP_TRANSITION_TIME = 2000;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private View commonView;
    private J3DViewpointNodeType currentViewpoint;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private PhysicalBody avatarBody;
    private PhysicalEnvironment avatarEnvironment;
    private Locale locale;
    private OrderedGroup ogroup;
    private BranchGroup bogroup;
    private BranchGroup commonSceneGraph;
    private BindableNodeManager viewpointStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;
    private ArrayList viewList;
    private J3DUserInputHandler userInput;
    private J3DSensorManager sensorManager;
    private ViewpointTransition vpTransition;
    private boolean inSetup;
    private ArrayList coreListeners;
    private VRMLNodeFactory nodeFactory;
    private GlobalEffectsGroup globalEffects;
    private RendererEffectsGroup rendererEffects;
    private EventModelEvaluator eventModel;
    private PerFrameBehavior frameTicker;
    private OverlayManager overlayManager;
    private OverlayWrapper overlayWrapper;
    private boolean hasOverlays;
    private float fieldOfView;
    private ObjectArray j3dScenePath;
    private TerrainData terrain_data;
    private long lastRenderTime;
    private ArrayList viewpointStatusListeners;
    static /* synthetic */ Class class$javax$media$j3d$PhysicalEnvironment;

    public VRMLUniverse(EventModelEvaluator eventModelEvaluator, boolean bl, OverlayHandler overlayHandler) {
        Object object;
        Canvas3D canvas3D;
        SensorManager sensorManager;
        if (eventModelEvaluator != null) {
            this.eventModel = eventModelEvaluator;
            this.eventModel.setInitListener((EventModelInitListener)this);
        }
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        this.viewList = new ArrayList();
        this.j3dScenePath = new ObjectArray();
        this.vpTransition = new ViewpointTransition();
        this.viewpointStatusListeners = new ArrayList(1);
        this.globalEffects = new GlobalEffectsGroup(false);
        this.rendererEffects = new RendererEffectsGroup(false);
        this.locale = new Locale((VirtualUniverse)this);
        this.bogroup = new BranchGroup();
        this.bogroup.setCapability(14);
        this.bogroup.setCapability(13);
        this.ogroup = new OrderedGroup();
        this.ogroup.setCapability(14);
        this.ogroup.setCapability(13);
        this.ogroup.setCapability(18);
        this.bogroup.addChild((Node)this.ogroup);
        this.locale.addBranchGraph(this.bogroup);
        this.commonSceneGraph = new BranchGroup();
        this.commonSceneGraph.setCapability(13);
        this.commonSceneGraph.setCapability(14);
        this.commonSceneGraph.addChild((Node)this.globalEffects);
        this.commonSceneGraph.addChild((Node)this.rendererEffects);
        if (bl) {
            this.frameTicker = new PerFrameBehavior(eventModelEvaluator, this);
            this.commonSceneGraph.addChild((Node)this.frameTicker);
        }
        this.fieldOfView = 0.0f;
        this.hasOverlays = false;
        if (this.eventModel != null) {
            J3DPathAwareNodeType j3DPathAwareNodeType;
            sensorManager = this.eventModel.getSensorManager();
            if (!(sensorManager instanceof J3DSensorManager)) {
                throw new IllegalArgumentException("Not a Java3D sensor manager");
            }
            this.sensorManager = (J3DSensorManager)sensorManager;
            this.sensorManager.setGlobalEffectsHandler(this.globalEffects);
            this.sensorManager.setRendererEffectsHandler(this.rendererEffects);
            this.userInput = (J3DUserInputHandler)this.sensorManager.getUserInputHandler();
            canvas3D = DefaultNodeFactory.createFactory((String)"java3d");
            this.nodeFactory = canvas3D;
            try {
                canvas3D.setSpecVersion(3, 1);
                canvas3D.setProfile("Interactive");
                canvas3D.addComponent("EnvironmentalEffects", 2);
            }
            catch (UnsupportedProfileException unsupportedProfileException) {
                // empty catch block
            }
            object = (J3DViewpointNodeType)canvas3D.createVRMLNode("Viewpoint", false);
            object.setDescription("Default viewpoint");
            object.setupFinished();
            VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)canvas3D.createVRMLNode("NavigationInfo", false);
            vRMLNavigationInfoNodeType.setupFinished();
            J3DBackgroundNodeType j3DBackgroundNodeType = (J3DBackgroundNodeType)canvas3D.createVRMLNode("Background", false);
            j3DBackgroundNodeType.setupFinished();
            J3DFogNodeType j3DFogNodeType = (J3DFogNodeType)canvas3D.createVRMLNode("Fog", false);
            j3DFogNodeType.setFogType(0);
            j3DFogNodeType.setupFinished();
            this.eventModel.setDefaultBindables((VRMLViewpointNodeType)object, vRMLNavigationInfoNodeType, (VRMLBackgroundNodeType)j3DBackgroundNodeType, (VRMLFogNodeType)j3DFogNodeType);
            this.viewpointStack = this.eventModel.getBindableManager(55);
            this.navInfoStack = this.eventModel.getBindableManager(31);
            this.backgroundStack = this.eventModel.getBindableManager(4);
            this.fogStack = this.eventModel.getBindableManager(18);
            if (object instanceof J3DPathAwareNodeType) {
                j3DPathAwareNodeType = (J3DPathAwareNodeType)object;
                j3DPathAwareNodeType.addParentPathListener(this);
            }
            if (j3DBackgroundNodeType instanceof J3DPathAwareNodeType) {
                j3DPathAwareNodeType = (J3DPathAwareNodeType)((Object)j3DBackgroundNodeType);
                j3DPathAwareNodeType.addParentPathListener(this);
            }
            if (j3DFogNodeType instanceof J3DPathAwareNodeType) {
                j3DPathAwareNodeType = (J3DPathAwareNodeType)((Object)j3DFogNodeType);
                j3DPathAwareNodeType.addParentPathListener(this);
            }
            j3DPathAwareNodeType = (Node)object.getSceneGraphObject();
            Node node = (Node)j3DBackgroundNodeType.getSceneGraphObject();
            Node node2 = (Node)j3DFogNodeType.getSceneGraphObject();
            this.commonSceneGraph.addChild(node);
            this.commonSceneGraph.addChild((Node)j3DPathAwareNodeType);
            this.commonSceneGraph.addChild(node2);
        }
        if (overlayHandler != null) {
            sensorManager = new UpdateControlBehavior();
            sensorManager.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1.0E32));
            canvas3D = overlayHandler.getPrimaryCanvas();
            this.overlayManager = new OverlayManager(canvas3D, (UpdateManager)sensorManager);
            object = new J3DTerrainManager(canvas3D);
            this.rendererEffects.setTerrainManager((J3DTerrainManager)object);
            this.commonSceneGraph.addChild((Node)sensorManager);
            this.globalEffects.addViewDependentChild((Group)this.overlayManager);
            this.overlayWrapper = new OverlayWrapper((Component)canvas3D);
            this.ogroup.addChild((Node)this.commonSceneGraph);
        } else {
            this.bogroup.addChild((Node)this.commonSceneGraph);
        }
        this.viewpointStack.setNodeChangeListener((BindableNodeListener)this);
        this.navInfoStack.setNodeChangeListener((BindableNodeListener)this);
        this.inSetup = false;
    }

    public boolean hasParentPathChanged() {
        return false;
    }

    public ObjectArray getParentPath(J3DVRMLNode j3DVRMLNode) {
        this.j3dScenePath.clear();
        this.j3dScenePath.add((Object)this.locale);
        return this.j3dScenePath;
    }

    public void worldInitComplete() {
        this.fireInitEvent();
        this.inSetup = false;
    }

    public void changeWorld() {
        ArrayList arrayList;
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = this.nextScene;
        this.hasOverlays = false;
        if (this.currentScene == null) {
            return;
        }
        this.defMap = this.currentScene.getDEFNodes();
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentScene.getRootNode();
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        this.currentSpace = (VRMLExecutionSpace)j3DVRMLNode;
        if (j3DVRMLNode instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)((Object)j3DVRMLNode)).addParentPathListener(this);
        }
        this.userInput.setPickableScene(branchGroup);
        this.sensorManager.setWorldRoot(branchGroup);
        if (this.overlayManager != null) {
            arrayList = this.currentScene.getByPrimaryType(63);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                J3DOverlayStructureNodeType j3DOverlayStructureNodeType = (J3DOverlayStructureNodeType)arrayList.get(i);
                j3DOverlayStructureNodeType.setOverlayManager(this.overlayManager);
            }
            this.overlayWrapper.setSurfaces(arrayList);
            if (n > 0) {
                this.hasOverlays = true;
                this.ogroup.addChild((Node)branchGroup);
                this.ogroup.setChildIndexOrder(new int[]{1, 0});
            } else {
                this.bogroup.addChild((Node)branchGroup);
            }
        } else {
            this.bogroup.addChild((Node)branchGroup);
        }
        this.setupView();
        arrayList = this.eventModel.getVRMLClock();
        arrayList.resetTimeZero();
        if (this.overlayManager != null) {
            this.overlayManager.viewChanged();
        }
        if (this.frameTicker != null) {
            this.frameTicker.setEnable(true);
        }
    }

    public void newNodeBound(VRMLBindableNodeType vRMLBindableNodeType) {
        int n = vRMLBindableNodeType.getPrimaryType();
        if (vRMLBindableNodeType instanceof J3DViewpointNodeType) {
            this.changeViewpoints((J3DViewpointNodeType)vRMLBindableNodeType);
        } else if (vRMLBindableNodeType instanceof VRMLNavigationInfoNodeType) {
            this.changeNavInfo((VRMLNavigationInfoNodeType)vRMLBindableNodeType);
        }
    }

    public void bindableAdded(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointAdded((VRMLViewpointNodeType)vRMLBindableNodeType, bl);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public void bindableRemoved(VRMLBindableNodeType vRMLBindableNodeType) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointRemoved((VRMLViewpointNodeType)vRMLBindableNodeType);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public int getRendererType() {
        return 1;
    }

    public String getIDString() {
        return "java3d";
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        float f = (float)this.lastRenderTime / 1000.0f;
        return 1.0f / f;
    }

    public void setLastRenderTime(long l) {
        this.lastRenderTime = l;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.frameTicker.setEventModelStatusListener(eventModelStatusListener);
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.addNavigationStateListener(navigationStateListener);
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.removeNavigationStateListener(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.addSensorStatusListener(sensorStatusListener);
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.removeSensorStatusListener(sensorStatusListener);
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener != null && !this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        this.viewpointStatusListeners.remove(viewpointStatusListener);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        string = this.currentScene != null ? this.currentScene.getWorldRootURL() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("user.dir");
                string = string.replace('\\', '/');
                string = "file:///" + string;
                return string;
            }
        });
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.inSetup = true;
        this.nextScene = vRMLScene;
        if (this.eventModel != null) {
            this.eventModel.setScene(vRMLScene, string);
        }
        if (this.frameTicker != null) {
            this.frameTicker.setEnable(true);
        }
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public VRMLNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setFieldOfView(float f) {
        this.fieldOfView = f;
    }

    public void addSceneGraphExtras(BranchGroup branchGroup) {
        this.commonSceneGraph.addChild((Node)branchGroup);
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public J3DViewpointNodeType getViewpoint() {
        return this.currentViewpoint;
    }

    public void setPrimaryView(View view) {
        if (view == null) {
            return;
        }
        this.setupView();
        if (this.commonView != view) {
            view.setPhysicalBody(this.avatarBody);
            view.setPhysicalEnvironment(this.avatarEnvironment);
            view.setFrontClipPolicy(2);
            view.setBackClipPolicy(2);
            view.attachViewPlatform(this.globalEffects.getViewPlatform());
        }
        this.commonView = view;
        if (!this.viewList.contains(view)) {
            this.viewList.add(view);
        }
    }

    public void setPhysicalBody(PhysicalBody physicalBody) {
        this.avatarBody = physicalBody == null ? new PhysicalBody() : physicalBody;
        int n = this.viewList.size();
        for (int i = 0; i < n; ++i) {
            View view = (View)this.viewList.get(i);
            view.setPhysicalBody(this.avatarBody);
        }
    }

    public void addView(View view) {
        if (view == null || this.viewList.contains(view)) {
            return;
        }
        this.viewList.add(view);
        if (this.currentScene != null) {
            view.setPhysicalBody(this.avatarBody);
            view.setPhysicalEnvironment(this.avatarEnvironment);
            view.setFrontClipPolicy(2);
            view.setBackClipPolicy(2);
            view.attachViewPlatform(this.globalEffects.getViewPlatform());
        }
    }

    public void removeView(View view) {
        if (view == null || !this.viewList.contains(view)) {
            return;
        }
        this.viewList.remove(view);
    }

    public void setNavigationMode(String string) {
        this.userInput.setNavigationMode(string);
    }

    public void fitToWorld(boolean bl) {
        System.out.println("Fit to world not implemented");
    }

    private void setupView() {
        this.avatarBody = new PhysicalBody();
        this.avatarEnvironment = new PhysicalEnvironment();
        int n = this.viewList.size();
        for (int i = 0; i < n; ++i) {
            View view = (View)this.viewList.get(i);
            view.setPhysicalBody(this.avatarBody);
            view.setPhysicalEnvironment(this.avatarEnvironment);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        ClassLoader classLoader;
                        boolean bl = false;
                        try {
                            classLoader = this.getClass().getClassLoader();
                            Class<?> clazz = classLoader.loadClass("com.sun.j3d.audioengines.headspace.HeadspaceMixer");
                            Constructor<?> constructor = clazz.getConstructor(class$javax$media$j3d$PhysicalEnvironment == null ? (class$javax$media$j3d$PhysicalEnvironment = VRMLUniverse.class$("javax.media.j3d.PhysicalEnvironment")) : class$javax$media$j3d$PhysicalEnvironment);
                            AudioDevice3DL2 audioDevice3DL2 = (AudioDevice3DL2)constructor.newInstance(VRMLUniverse.this.avatarEnvironment);
                            audioDevice3DL2.initialize();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            classNotFoundException.printStackTrace();
                            bl = true;
                        }
                        catch (InstantiationException instantiationException) {
                            instantiationException.printStackTrace();
                            bl = true;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            bl = true;
                        }
                        catch (SecurityException securityException) {
                            securityException.printStackTrace();
                            bl = true;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            noSuchMethodException.printStackTrace();
                            bl = true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                            bl = true;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                            bl = true;
                        }
                        if (bl) {
                            System.out.println("HeadspaceMixer not loading, defaulting to JavaSoundMixer");
                            classLoader = new JavaSoundMixer(VRMLUniverse.this.avatarEnvironment);
                            classLoader.initialize();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                System.out.println("Error starting Audio, can't get privilege");
            }
            view.setFrontClipPolicy(2);
            view.setBackClipPolicy(2);
        }
    }

    private void clearCurrentWorld() {
        if (this.frameTicker != null) {
            this.frameTicker.setEnable(false);
        }
        this.userInput.setPickableScene(null);
        this.currentSpace = null;
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.currentScene.getRootNode();
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        try {
            branchGroup.detach();
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            System.out.println("Can't detach root");
            capabilityNotSetException.printStackTrace();
        }
        if (j3DVRMLNode instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)((Object)j3DVRMLNode)).removeParentPathListener(this);
        }
        this.eventModel.clear();
        this.sensorManager.setWorldRoot(null);
        this.clearInlines((BasicScene)this.currentScene);
        this.overlayManager.clearOverlays();
        this.userInput.setPickableScene(null);
        this.userInput.setViewInfo(null, null, null);
        if (this.hasOverlays) {
            this.ogroup.removeChild((Node)branchGroup);
        } else {
            this.bogroup.removeChild((Node)branchGroup);
        }
    }

    private void changeViewpoints(J3DViewpointNodeType j3DViewpointNodeType) {
        if (j3DViewpointNodeType.getJump() || this.inSetup) {
            this.currentViewpoint = j3DViewpointNodeType;
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            Transform3D transform3D = this.currentViewpoint.getViewTransform();
            transformGroup.setTransform(transform3D);
            if (this.fieldOfView == 0.0f) {
                this.commonView.setFieldOfView((double)this.currentViewpoint.getFieldOfView());
            } else {
                this.commonView.setFieldOfView((double)this.fieldOfView);
            }
            SceneGraphPath sceneGraphPath = this.currentViewpoint.getSceneGraphPath();
            if (this.checkForLinks(sceneGraphPath)) {
                this.userInput.setViewInfo(this.commonView, transformGroup, sceneGraphPath);
            } else {
                this.userInput.setViewInfo(this.commonView, transformGroup, null);
            }
        } else {
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            TransformGroup transformGroup2 = j3DViewpointNodeType.getPlatformGroup();
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D2 = new Transform3D();
            Transform3D transform3D3 = j3DViewpointNodeType.getViewTransform();
            SceneGraphPath sceneGraphPath = this.currentViewpoint.getSceneGraphPath();
            SceneGraphPath sceneGraphPath2 = j3DViewpointNodeType.getSceneGraphPath();
            boolean bl = this.checkForLinks(sceneGraphPath);
            boolean bl2 = this.checkForLinks(sceneGraphPath2);
            if (bl) {
                transformGroup.getLocalToVworld(sceneGraphPath, transform3D);
            } else {
                transformGroup.getLocalToVworld(transform3D);
            }
            if (bl2) {
                transformGroup2.getLocalToVworld(sceneGraphPath2, transform3D2);
            } else {
                transformGroup2.getLocalToVworld(transform3D2);
            }
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            Quat4d quat4d = new Quat4d();
            Quat4d quat4d2 = new Quat4d();
            Quat4d quat4d3 = new Quat4d();
            transform3D2.get(quat4d2, vector3d2);
            transform3D.get(quat4d, vector3d);
            vector3d3.sub((Tuple3d)vector3d2, (Tuple3d)vector3d);
            quat4d3.sub((Tuple4d)quat4d2, (Tuple4d)quat4d);
            Transform3D transform3D4 = new Transform3D();
            transform3D4.set(quat4d3, vector3d3, 1.0);
            transform3D4.set(vector3d3);
            transformGroup2.setTransform(transform3D4);
            if (this.fieldOfView == 0.0f) {
                this.commonView.setFieldOfView((double)j3DViewpointNodeType.getFieldOfView());
            } else {
                this.commonView.setFieldOfView((double)this.fieldOfView);
            }
            this.vpTransition.transitionTo(this.commonView, transformGroup2, transform3D3, 2000);
            this.currentViewpoint = j3DViewpointNodeType;
            if (bl2) {
                this.userInput.setViewInfo(this.commonView, transformGroup2, sceneGraphPath2);
            } else {
                this.userInput.setViewInfo(this.commonView, transformGroup2, null);
            }
        }
        if (this.currentNavInfo != null) {
            this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        }
        if (this.overlayManager != null) {
            this.overlayManager.viewChanged();
        }
    }

    private void changeNavInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        float f = this.currentNavInfo.getVisibilityLimit();
        if (f <= 0.0f) {
            f = 10000.0f;
        }
        this.commonView.setBackClipDistance((double)f);
        float[] fArray = this.currentNavInfo.getAvatarSize();
        float f2 = fArray[0] / 2.0f;
        if (f2 < 0.001f) {
            f2 = 0.001f;
        }
        this.commonView.setFrontClipDistance((double)f2);
        this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        this.userInput.setNavigationInfo(this.currentNavInfo);
    }

    private void clearInlines(BasicScene basicScene) {
        J3DVRMLNode j3DVRMLNode;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(24);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (J3DVRMLNode)arrayList.get(n);
            SceneGraphObject sceneGraphObject = j3DVRMLNode.getSceneGraphObject();
            if (sceneGraphObject instanceof BranchGroup) {
                ((BranchGroup)sceneGraphObject).detach();
            } else {
                System.out.println("Inline root node is not a BG! " + sceneGraphObject.getClass());
            }
            VRMLScene vRMLScene = (VRMLScene)((VRMLInlineNodeType)j3DVRMLNode).getContainedScene();
            if (vRMLScene == null) continue;
            J3DVRMLNode j3DVRMLNode2 = (J3DVRMLNode)vRMLScene.getRootNode();
            BranchGroup branchGroup = (BranchGroup)j3DVRMLNode2.getSceneGraphObject();
            branchGroup.detach();
            this.clearInlines((BasicScene)vRMLScene);
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            j3DVRMLNode = (VRMLProtoInstance)arrayList.get(n);
            this.clearInlines(j3DVRMLNode.getContainedScene());
        }
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private boolean checkForLinks(SceneGraphPath sceneGraphPath) {
        boolean bl = false;
        if (sceneGraphPath == null) {
            return false;
        }
        int n = sceneGraphPath.nodeCount();
        for (int i = 0; i < n && !bl; ++i) {
            if (!(sceneGraphPath.getNode(i) instanceof Link)) continue;
            bl = true;
        }
        return bl;
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

